/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;

public class DNSServer {
    public static final String busPack = "net.sf.jfdns";
    public static boolean debug = false;
    private Server server;
    private DatagramSocket ds;
    private static int maxmtu = 512;
    private ArrayList<String> uplink = new ArrayList();
    private ArrayList<String> records = new ArrayList();
    private ArrayList<String> allows = new ArrayList();
    private ArrayList<String> denies = new ArrayList();
    private ArrayList<Entry> cache = new ArrayList();
    private Object cacheLock = new Object();
    private int uplinktimeout = 2000;
    private int cachetimeout = 3600000;
    private boolean uplinks_down = false;
    private static final String defaultConfig = "[global]\nuplink=8.8.8.8\nuplink=8.8.4.4\nuplinktimeout=2000 #default 2 seconds\n#cachetimeout=3600000 #default 1 hour\n[records]\n#name,type,ttl,value\n#mydomain.com,cname,3600,www.mydomain.com\n#www.mydomain.com,a,3600,192.168.0.2\n#mydomain.com,mx,3600,50,mail.mydomain.com\n#mail.mydomain.com,a,3600,192.168.0.3\n#www.mydomain.com,aaaa,3600,1234:1234:1234:1234:1234:1234:1234:1234\n";
    private static final int QR = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int OPCODE_QUERY = 0;
    private static final int OPCODE_IQUERY = 16384;
    private static final int OPCODE_UPDATE = 10240;
    private static final int AA = 1024;
    private static final int TC = 512;
    private static final int RD = 256;
    private static final int RA = 128;
    private static final int Z = 64;
    private static final int AD = 32;
    private static final int CD = 16;
    private static final int ERR_NO_ERROR = 0;
    private static final int ERR_NO_SUCH_NAME = 3;
    private static final int A = 1;
    private static final int NS = 2;
    private static final int CNAME = 5;
    private static final int SOA = 6;
    private static final int PTR = 12;
    private static final int MX = 15;
    private static final int TXT = 16;
    private static final int AAAA = 28;
    private static final int LOC = 29;
    private static final int SRV = 33;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;
    private static DNSServer dns;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfdns.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfdns.log";
    }

    public void start() {
        this.stop();
        this.server = new Server(this);
        this.server.start();
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
    }

    private void loadConfig() {
        JFLog.log("loadConfig");
        Section section = Section.None;
        try {
            String ln;
            BufferedReader br = new BufferedReader(new FileReader(DNSServer.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while ((ln = br.readLine()) != null) {
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim().toLowerCase();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                if (ln.equals("[records]")) {
                    section = Section.Records;
                    continue;
                }
                if (ln.startsWith("[")) continue;
                switch (section.ordinal()) {
                    case 1: {
                        int idx = ln.indexOf(61);
                        if (idx == -1) break;
                        String key = ln.substring(0, idx).trim();
                        String value = ln.substring(idx + 1).trim();
                        switch (key) {
                            case "uplink": {
                                this.uplink.add(value);
                                break;
                            }
                            case "uplinktimeout": {
                                this.uplinktimeout = JF.atoi(value);
                                break;
                            }
                            case "allow": {
                                if (this.allows.contains(value)) break;
                                this.allows.add(value);
                                break;
                            }
                            case "cachetimeout": {
                                this.cachetimeout = JF.atoi(value);
                                break;
                            }
                            case "deny": {
                                if (this.denies.contains(value)) break;
                                this.denies.add(value);
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.records.add(ln);
                    }
                }
            }
            br.close();
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            this.uplink.add("8.8.8.8");
            try {
                FileOutputStream fos = new FileOutputStream(DNSServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33005;
        }
        return 777;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(DNSServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        dns = new DNSServer();
        dns.start();
    }

    public static void serviceStop() {
        JFLog.log("DNS : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        dns.stop();
    }

    private class Server
    extends Thread {
        public boolean active;
        final /* synthetic */ DNSServer this$0;

        private Server(DNSServer dNSServer) {
            DNSServer dNSServer2 = dNSServer;
            Objects.requireNonNull(dNSServer2);
            this.this$0 = dNSServer2;
        }

        @Override
        public void run() {
            this.active = true;
            JFLog.append(DNSServer.getLogFile(), false);
            JFLog.setRetention(30);
            JFLog.log("DNS : Starting service");
            try {
                this.this$0.loadConfig();
                this.this$0.busClient = new JBusClient(DNSServer.busPack, new JBusMethods());
                this.this$0.busClient.setPort(DNSServer.getBusPort());
                this.this$0.busClient.start();
                for (int a = 0; a < 5; ++a) {
                    try {
                        this.this$0.ds = new DatagramSocket(53);
                        break;
                    }
                    catch (Exception e) {
                        if (a == 4) {
                            JFLog.log(e);
                            return;
                        }
                        JF.sleep(1000);
                        continue;
                    }
                }
                while (this.active) {
                    byte[] data = new byte[maxmtu];
                    DatagramPacket packet = new DatagramPacket(data, maxmtu);
                    this.this$0.ds.receive(packet);
                    new Worker(this.this$0, packet).start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    static enum Section {
        None,
        Global,
        Records;

    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = DNSServer.dns.busClient;
            JBusClient cfr_ignored_1 = DNSServer.dns.busClient;
            DNSServer.dns.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(DNSServer.dns.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(DNSServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            dns.stop();
            dns = new DNSServer();
            dns.start();
        }
    }

    private class Worker
    extends Thread {
        private DatagramPacket packet;
        private byte[] data;
        private int dataLength;
        private int nameLength;
        private byte[] reply;
        private int replyOffset;
        private ByteBuffer bb;
        private ByteBuffer replyBuffer;
        private short id;
        private short flgs;
        private int opcode;
        final /* synthetic */ DNSServer this$0;

        public Worker(DNSServer dNSServer, DatagramPacket packet) {
            DNSServer dNSServer2 = dNSServer;
            Objects.requireNonNull(dNSServer2);
            this.this$0 = dNSServer2;
            this.packet = packet;
        }

        @Override
        public void run() {
            try {
                this.data = this.packet.getData();
                this.dataLength = this.packet.getLength();
                this.bb = ByteBuffer.wrap(this.data);
                this.bb.order(ByteOrder.BIG_ENDIAN);
                this.id = this.bb.getShort(0);
                this.flgs = this.bb.getShort(2);
                if ((this.flgs & 0x8000) != 0) {
                    throw new Exception("response sent to server");
                }
                this.opcode = this.flgs & 0x7800;
                switch (this.opcode) {
                    default: {
                        throw new Exception("opcode not supported:" + this.opcode);
                    }
                    case 16384: {
                        throw new Exception("inverse query not supported");
                    }
                    case 10240: {
                        throw new Exception("update not supported");
                    }
                    case 0: 
                }
                this.doQuery();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void doQuery() throws Exception {
            int cndQ = this.bb.getShort(4);
            if (cndQ != 1) {
                throw new Exception("only 1 question supported");
            }
            short cndA = this.bb.getShort(6);
            if (cndA != 0) {
                throw new Exception("query with answers?");
            }
            short cndS = this.bb.getShort(8);
            if (cndS != 0) {
                throw new Exception("query with auth names?");
            }
            short cndAdd = this.bb.getShort(10);
            if (cndAdd != 0) {
                throw new Exception("query with adds?");
            }
            int offset = 12;
            for (int a = 0; a < cndQ; ++a) {
                String domain = this.getName(this.data, offset);
                short type = this.bb.getShort(offset += this.nameLength);
                short cls = this.bb.getShort(offset += 2);
                if (cls != 1) {
                    throw new Exception("only internet class supported");
                }
                offset += 2;
                if (domain.endsWith(".in-addr.arpa")) {
                    this.sendReply(domain, "*.in-addr.arpa,ptr,1440,localdomain", type, this.id);
                    continue;
                }
                if (domain.endsWith(".ip6.arpa")) {
                    this.sendReply(domain, "*.ip6.arpa,ptr,1440,localdomain", type, this.id);
                    continue;
                }
                if (this.queryLocal(domain, type, this.id)) continue;
                boolean updateOnly = false;
                if (this.queryCache(domain, type, this.id)) {
                    updateOnly = true;
                }
                this.queryRemote(domain, type, this.id, updateOnly);
            }
        }

        private void doUpdate() throws Exception {
        }

        private String getName(byte[] data, int offset) {
            StringBuilder name = new StringBuilder();
            boolean jump = false;
            this.nameLength = 0;
            while (true) {
                int length;
                if (!jump) {
                    ++this.nameLength;
                }
                if ((length = data[offset++] & 0xFF) == 0) break;
                if (length >= 192) {
                    if (!jump) {
                        ++this.nameLength;
                    }
                    jump = true;
                    int newOffset = (length & 0x3F) << 8;
                    newOffset += data[offset] & 0xFF;
                    offset = newOffset;
                    continue;
                }
                if (!jump) {
                    this.nameLength += length;
                }
                if (name.length() != 0) {
                    name.append(".");
                }
                name.append(new String(data, offset, length));
                offset += length;
            }
            return name.toString();
        }

        private int encodeName(String domain) {
            String[] p = domain.split("[.]");
            int length = 0;
            for (int a = 0; a < p.length; ++a) {
                int strlen = p[a].length();
                this.reply[this.replyOffset++] = (byte)strlen;
                ++length;
                System.arraycopy(p[a].getBytes(), 0, this.reply, this.replyOffset, strlen);
                this.replyOffset += strlen;
                length += strlen;
            }
            this.reply[this.replyOffset++] = 0;
            return ++length;
        }

        private boolean queryLocal(String domain, int type, int id) {
            Object match = domain + "," + this.typeToString(type) + ",";
            match = ((String)match).toLowerCase();
            int cnt = this.this$0.records.size();
            for (int a = 0; a < cnt; ++a) {
                String record = this.this$0.records.get(a);
                if (!record.startsWith((String)match)) continue;
                this.sendReply(domain, record, type, id);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean queryCache(String domain, int type, int id) {
            JFLog.log("queryCache:domain=" + domain + ",type=" + type);
            Object match = domain + "," + this.typeToString(type) + ",";
            match = ((String)match).toLowerCase();
            long timeout = System.currentTimeMillis() - (long)this.this$0.cachetimeout;
            Object object = this.this$0.cacheLock;
            synchronized (object) {
                int cnt = this.this$0.cache.size();
                int a = 0;
                while (a < cnt) {
                    Entry entry = this.this$0.cache.get(a);
                    if (entry.ts < timeout) {
                        if (!this.this$0.uplinks_down) {
                            this.this$0.cache.remove(a);
                            --cnt;
                            continue;
                        }
                        ++a;
                        continue;
                    }
                    if (entry.record.startsWith((String)match)) {
                        BE.setuint16(entry.value, 0, id);
                        this.sendReply(domain, entry.value);
                        return true;
                    }
                    ++a;
                }
            }
            return false;
        }

        private boolean isAllowed(String domain) {
            int a;
            int cnt = this.this$0.allows.size();
            for (a = 0; a < cnt; ++a) {
                if (!domain.matches(this.this$0.allows.get(a))) continue;
                return true;
            }
            cnt = this.this$0.denies.size();
            for (a = 0; a < cnt; ++a) {
                if (!domain.matches(this.this$0.denies.get(a))) continue;
                return false;
            }
            return true;
        }

        private String typeToString(int type) {
            switch (type) {
                case 1: {
                    return "A";
                }
                case 5: {
                    return "CNAME";
                }
                case 15: {
                    return "MX";
                }
                case 28: {
                    return "AAAA";
                }
                case 6: {
                    return "SOA";
                }
                case 12: {
                    return "PTR";
                }
            }
            return "A";
        }

        private void queryRemote(String domain, int type, int id, boolean updateOnly) {
            JFLog.log("queryRemote:domain=" + domain + ",type=" + type);
            if (!this.isAllowed(domain)) {
                JFLog.log("not allowed:" + domain);
                if (updateOnly) {
                    return;
                }
                if (type == 28) {
                    this.sendReply(domain, domain + "," + this.typeToString(type) + ",3600,0:0:0:0:0:FFFF:5DB8:D822", type, id);
                } else {
                    this.sendReply(domain, domain + "," + this.typeToString(type) + ",3600,93.184.216.34", type, id);
                }
                return;
            }
            int cnt = this.this$0.uplink.size();
            for (int idx = 0; idx < cnt; ++idx) {
                try {
                    DatagramPacket out = new DatagramPacket(this.data, this.dataLength);
                    out.setAddress(InetAddress.getByName(this.this$0.uplink.get(0)));
                    out.setPort(53);
                    DatagramSocket sock = new DatagramSocket();
                    sock.setSoTimeout(this.this$0.uplinktimeout);
                    sock.send(out);
                    this.reply = new byte[maxmtu];
                    DatagramPacket in = new DatagramPacket(this.reply, this.reply.length);
                    sock.receive(in);
                    this.reply = Arrays.copyOf(this.reply, in.getLength());
                    if (!updateOnly) {
                        this.sendReply(domain, this.reply);
                    }
                    this.updateCache(domain, type, this.reply);
                    this.this$0.uplinks_down = false;
                    return;
                }
                catch (Exception e) {
                    JFLog.log(e);
                    String up = this.this$0.uplink.remove(0);
                    this.this$0.uplink.add(up);
                    continue;
                }
            }
            this.this$0.uplinks_down = true;
            JFLog.log("Query Remote failed for domain=" + domain);
        }

        private void sendReply(String domain, byte[] outData) {
            JFLog.log("sendReply:" + domain + " to " + String.valueOf(this.packet.getAddress()) + ":" + this.packet.getPort());
            try {
                DatagramPacket out = new DatagramPacket(outData, outData.length);
                out.setAddress(this.packet.getAddress());
                out.setPort(this.packet.getPort());
                this.this$0.ds.send(out);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void sendReply(String query, String record, int type, int id) {
            JFLog.log("sendReply:query=" + query + ",record=" + record + ",type=" + type);
            String[] f = record.split(",");
            int ttl = JF.atoi(f[2]);
            this.reply = new byte[maxmtu];
            this.replyBuffer = ByteBuffer.wrap(this.reply);
            this.replyBuffer.order(ByteOrder.BIG_ENDIAN);
            this.replyOffset = 0;
            this.putShort((short)id);
            this.putShort((short)-31616);
            this.putShort((short)1);
            this.putShort((short)1);
            this.putShort((short)0);
            this.putShort((short)0);
            this.encodeName(query);
            this.putShort((short)type);
            this.putShort((short)1);
            switch (type) {
                case 1: {
                    this.encodeName(query);
                    this.putShort((short)type);
                    this.putShort((short)1);
                    this.putInt(ttl);
                    this.putShort((short)4);
                    this.putIP4(f[3]);
                    break;
                }
                case 5: 
                case 12: {
                    this.encodeName(query);
                    this.putShort((short)type);
                    this.putShort((short)1);
                    this.putInt(ttl);
                    int rdataOffset = this.replyOffset;
                    this.putShort((short)0);
                    int rdataLength = this.encodeName(f[3]);
                    this.replyBuffer.putShort(rdataOffset, (short)rdataLength);
                    break;
                }
                case 15: {
                    this.encodeName(query);
                    this.putShort((short)type);
                    this.putShort((short)1);
                    this.putInt(ttl);
                    int rdataOffset = this.replyOffset;
                    this.putShort((short)0);
                    this.putShort((short)JF.atoi(f[3]));
                    int rdataLength = this.encodeName(f[4]);
                    this.replyBuffer.putShort(rdataOffset, (short)(rdataLength + 2));
                    break;
                }
                case 28: {
                    this.encodeName(query);
                    this.putShort((short)type);
                    this.putShort((short)1);
                    this.putInt(ttl);
                    this.putShort((short)16);
                    this.putIP6(f[3]);
                }
            }
            this.sendReply(query, Arrays.copyOf(this.reply, this.replyOffset));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(String domain, int type, byte[] reply) {
            Object match = domain + "," + this.typeToString(type) + ",";
            match = ((String)match).toLowerCase();
            Object object = this.this$0.cacheLock;
            synchronized (object) {
                int cnt = this.this$0.cache.size();
                for (int a = 0; a < cnt; ++a) {
                    Entry entry = this.this$0.cache.get(a);
                    if (!entry.record.equals(match)) continue;
                    entry.value = reply;
                    entry.ts = System.currentTimeMillis();
                    return;
                }
                Entry entry = new Entry();
                entry.record = match;
                entry.value = reply;
                entry.ts = System.currentTimeMillis();
                this.this$0.cache.add(entry);
            }
        }

        private void putIP4(String ip) {
            String[] p = ip.split("[.]", -1);
            for (int a = 0; a < 4; ++a) {
                this.reply[this.replyOffset++] = (byte)JF.atoi(p[a]);
            }
        }

        private void putIP6(String ip) {
            String[] p = ip.split(":", -1);
            for (int a = 0; a < 8; ++a) {
                this.putShort((short)JF.atox(p[a]));
            }
        }

        private void putShort(short value) {
            this.replyBuffer.putShort(this.replyOffset, value);
            this.replyOffset += 2;
        }

        private void putInt(int value) {
            this.replyBuffer.putInt(this.replyOffset, value);
            this.replyOffset += 4;
        }
    }

    private static class Entry {
        public String record;
        public byte[] value;
        public long ts;

        private Entry() {
        }
    }
}

