/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.KeyParams;
import javaforce.LE;
import javaforce.MD5;
import javaforce.net.IP4Port;

public class FileSyncServer {
    private static boolean debug = false;
    private static boolean embedded = false;
    public static final int VERSION = 1;
    public static final int port = 33203;
    private String passwd;
    private String root;
    private Server server;
    private Object lock = new Object();
    private ArrayList<Client> clients = new ArrayList();
    public static final byte REQ_AUTH = 1;
    public static final byte REQ_FILE_OPEN = 16;
    public static final byte REQ_FILE_BLOCK_HASH = 17;
    public static final byte REQ_FILE_BLOCK_DATA = 18;
    public static final byte REQ_FILE_TRUNCATE = 19;
    public static final byte REQ_FILE_CREATE = 20;
    public static final byte REQ_FILE_DELETE = 21;
    public static final byte REQ_FOLDER_OPEN = 32;
    public static final byte REQ_FOLDER_CREATE = 33;
    public static final byte REQ_FOLDER_DELETE = 34;
    public static final byte REQ_FOLDER_LIST = 35;
    public static final byte RET_OKAY = 0;
    public static final byte RET_ERROR = 1;
    public static final byte RET_CHANGE = 2;
    public static final byte RET_NO_CHANGE = 3;
    public static final byte RET_NO_EXIST = 4;
    public static final int AUTH_PASSWD = 1;
    public static final int HASH_MD5 = 1;
    public static final int HASH_MD5_SEED = 2;
    public static final int max_auth_len = 256;
    public static final int max_data_len = 0x100040;

    public FileSyncServer(String passwd, String rootFolder) {
        this.passwd = passwd;
        this.root = rootFolder;
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jffilesync.key";
    }

    private static void genKeyFile() {
        KeyParams params = new KeyParams();
        params.dname = "CN=javaforce.sourceforge.net, O=server, OU=filesyncserver, C=CA";
        params.exts = new String[0];
        params.validity = "3650";
        KeyMgmt.create(FileSyncServer.getKeyFile(), "password", "filesyncserver", params, "password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClient(Client client) {
        JFLog.log("client+=" + client.remote);
        Object object = this.lock;
        synchronized (object) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(Client client) {
        JFLog.log("client-=" + client.remote);
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(client);
        }
    }

    public void start() {
        this.stop();
        this.server = new Server(this);
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        try {
            this.server.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        Object object = this.lock;
        synchronized (object) {
            Client[] cs;
            for (Client c : cs = this.clients.toArray(new Client[0])) {
                c.close();
            }
            this.clients.clear();
        }
    }

    public static void setEmbedded(boolean state) {
        embedded = state;
    }

    public static void print_hash(byte[] hash) {
        StringBuilder s = new StringBuilder();
        s.append("hash=");
        for (int i = 0; i < 16; ++i) {
            byte b = hash[i];
            if (i > 0) {
                s.append(",");
            }
            s.append(Integer.toHexString(b & 0xFF));
        }
        JFLog.log(s.toString());
    }

    public static void main(String[] args) {
        FileSyncServer service2 = new FileSyncServer("password", "/tmp");
        service2.start();
        while (true) {
            JF.sleep(1000);
        }
    }

    private class Client
    extends Thread {
        public String remote;
        private Socket s;
        private InputStream is;
        private OutputStream os;
        private boolean active;
        private byte[] req;
        private int req_len;
        private String folder;
        private String filename;
        private byte[] file_data;
        private RandomAccessFile file_io;
        private long file_date;
        private long file_size;
        private byte[] reply;
        private int reply_len;
        private byte[] buf;
        private byte[] hash_md5;
        private MD5 md5;
        final /* synthetic */ FileSyncServer this$0;

        public Client(FileSyncServer fileSyncServer, Socket s) {
            FileSyncServer fileSyncServer2 = fileSyncServer;
            Objects.requireNonNull(fileSyncServer2);
            this.this$0 = fileSyncServer2;
            this.req = new byte[0x100040];
            this.file_data = new byte[0x100040];
            this.reply = new byte[0x100040];
            this.buf = new byte[8];
            this.hash_md5 = new byte[16];
            this.md5 = new MD5();
            this.s = s;
            this.remote = s.getInetAddress().getHostAddress();
            this.folder = "/";
        }

        @Override
        public void run() {
            block37: {
                this.active = true;
                try {
                    this.is = this.s.getInputStream();
                    this.os = this.s.getOutputStream();
                    int cmd = this.is.read();
                    if (cmd == -1) {
                        throw new Exception("read error");
                    }
                    if (cmd != 1) {
                        throw new Exception("auth not received");
                    }
                    if (this.is.readNBytes(this.req, 0, 4) != 4) {
                        throw new Exception("read error");
                    }
                    this.req_len = LE.getuint32(this.req, 0);
                    if (debug) {
                        JFLog.log(String.format("c.cmd=%x len=%d", cmd, this.req_len));
                    }
                    if (this.req_len < 8) {
                        throw new Exception("auth too small");
                    }
                    if (this.req_len > 256) {
                        throw new Exception("auth too long");
                    }
                    if (this.is.readNBytes(this.req, 0, 8) != 8) {
                        throw new Exception("read error");
                    }
                    int c_version = LE.getuint32(this.req, 0);
                    this.req_len -= 4;
                    int auth_type = LE.getuint32(this.req, 4);
                    this.req_len -= 4;
                    if (this.is.readNBytes(this.req, 0, this.req_len) != this.req_len) {
                        throw new Exception("auth data not received");
                    }
                    switch (auth_type) {
                        case 1: {
                            String client_password = new String(this.req, 0, this.req_len);
                            if (debug) {
                                JFLog.log("client_password={" + client_password + "}");
                            }
                            if (debug) {
                                JFLog.log("server_password={" + this.this$0.passwd + "}");
                            }
                            if (!this.this$0.passwd.equals(client_password)) {
                                throw new Exception("access denied");
                            }
                            if (debug) {
                                JFLog.log("Login granted:" + this.remote);
                            }
                            this.reset();
                            this.write((byte)0);
                            this.write(4);
                            this.write(1);
                            if (debug) {
                                JFLog.log(String.format("s.cmd=%x len=%d", this.reply[0], this.reply_len - 5));
                            }
                            this.os.write(this.reply, 0, this.reply_len);
                            break;
                        }
                        default: {
                            throw new Exception("unknown auth type");
                        }
                    }
                    while (this.active) {
                        cmd = this.is.read();
                        if (cmd == -1) {
                            throw new Exception("read error");
                        }
                        if (this.is.readNBytes(this.req, 0, 4) != 4) {
                            throw new Exception("read error");
                        }
                        this.req_len = LE.getuint32(this.req, 0);
                        if (debug) {
                            JFLog.log(String.format("c.cmd=%x len=%d", cmd, this.req_len));
                        }
                        if (this.req_len > 0x100040) {
                            throw new Exception("data packet too big");
                        }
                        if (this.is.readNBytes(this.req, 0, this.req_len) != this.req_len) {
                            throw new Exception("read data error");
                        }
                        this.reply_len = 0;
                        switch (cmd) {
                            case 16: {
                                this.req_file_open();
                                break;
                            }
                            case 17: {
                                this.req_file_block_hash();
                                break;
                            }
                            case 18: {
                                this.req_file_block_data();
                                break;
                            }
                            case 19: {
                                this.req_file_truncate();
                                break;
                            }
                            case 20: {
                                this.req_file_create();
                                break;
                            }
                            case 21: {
                                this.req_file_delete();
                                break;
                            }
                            case 32: {
                                this.req_folder_open();
                                break;
                            }
                            case 33: {
                                this.req_folder_create();
                                break;
                            }
                            case 34: {
                                this.req_folder_delete();
                                break;
                            }
                            case 35: {
                                this.req_folder_list();
                                break;
                            }
                            default: {
                                throw new Exception("unknown cmd");
                            }
                        }
                        if (debug) {
                            JFLog.log(String.format("s.cmd=%x len=%d", this.reply[0], this.reply_len - 5));
                        }
                        this.os.write(this.reply, 0, this.reply_len);
                    }
                }
                catch (Exception e) {
                    if (!debug) break block37;
                    JFLog.log(e);
                }
            }
            this.file_close();
            this.close();
            this.this$0.removeClient(this);
        }

        public void close() {
            this.active = false;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void reset() {
            this.reply_len = 0;
        }

        private boolean write(byte b) {
            this.reply[this.reply_len++] = b;
            return true;
        }

        private boolean write(int len) {
            LE.setuint32(this.buf, 0, len);
            return this.write(this.buf, 0, 4);
        }

        private boolean write(long len) {
            LE.setuint64(this.buf, 0, len);
            return this.write(this.buf, 0, 8);
        }

        private boolean write(byte[] buf, int offset, int length) {
            if (this.reply_len + length > 0x100040) {
                return this.error((byte)1);
            }
            System.arraycopy(buf, offset, this.reply, this.reply_len, length);
            this.reply_len += length;
            return true;
        }

        private boolean error(byte code) {
            this.reset();
            return this.write(code, null);
        }

        private boolean write(byte code, byte[] data) {
            this.write(code);
            if (data != null) {
                if (!this.write(data.length)) {
                    return false;
                }
                if (!this.write(data, 0, data.length)) {
                    return false;
                }
            } else if (!this.write(0)) {
                return false;
            }
            return true;
        }

        private void file_open(File file) throws Exception {
            if (this.file_io != null) {
                this.file_close();
            }
            this.file_io = new RandomAccessFile(file, "rw");
            this.file_date = file.lastModified();
            this.file_size = file.length();
        }

        private void file_close() {
            if (this.file_io == null) {
                return;
            }
            try {
                this.file_io.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file_io = null;
        }

        private boolean req_file_open() {
            if (this.req_len < 17) {
                JFLog.log("Error:req_file_open():req too short");
                return this.error((byte)1);
            }
            if (this.file_io != null) {
                this.file_close();
            }
            long date = LE.getuint64(this.req, 0);
            this.req_len -= 8;
            long size = LE.getuint64(this.req, 8);
            this.req_len -= 8;
            this.filename = LE.getString(this.req, 16, this.req_len);
            if (this.filename.contains("..") || this.filename.contains("/")) {
                return this.error((byte)1);
            }
            try {
                String path = this.this$0.root + this.folder + this.filename;
                File file = new File(path);
                if (!file.exists()) {
                    this.write((byte)4, null);
                    this.file_open(file);
                    return true;
                }
                this.file_open(file);
                boolean change = false;
                if (this.file_date < date) {
                    change = true;
                } else if (this.file_size != size) {
                    change = true;
                }
                if (!change) {
                    this.write((byte)3, null);
                } else {
                    this.write((byte)2);
                    this.write(16);
                    this.write(this.file_date);
                    this.write(this.file_size);
                }
            }
            catch (Exception e) {
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_file_block_hash() {
            if (this.file_io == null) {
                JFLog.log("Error:req_file_block_hash():file not open");
                return this.error((byte)1);
            }
            if (this.req_len < 17) {
                JFLog.log("Error:req_file_block_hash():req too short");
                return this.error((byte)1);
            }
            int pos = 0;
            int hash_type = LE.getuint32(this.req, pos);
            this.req_len -= 4;
            long file_offset = LE.getuint64(this.req, pos += 4);
            this.req_len -= 8;
            int block_len = LE.getuint32(this.req, pos += 8);
            this.req_len -= 4;
            pos += 4;
            if (debug) {
                JFLog.log(String.format("block_hash:%d %d %d", hash_type, file_offset, block_len));
            }
            try {
                this.file_io.seek(file_offset);
                if (this.file_io.getFilePointer() != file_offset) {
                    throw new Exception("bad seek");
                }
                if (file_offset + (long)block_len > this.file_io.length()) {
                    throw new Exception("block beyond eof");
                }
                this.file_io.readFully(this.file_data, 0, block_len);
                switch (hash_type) {
                    case 1: {
                        if (this.req_len != 16) {
                            throw new Exception("missing hash");
                        }
                        System.arraycopy(this.req, pos, this.hash_md5, 0, 16);
                        this.md5.init();
                        this.md5.add(this.file_data, 0, block_len);
                        byte[] res = this.md5.done();
                        if (debug) {
                            FileSyncServer.print_hash(res);
                        }
                        if (Arrays.compare(res, this.hash_md5) == 0) {
                            this.write((byte)3, null);
                            break;
                        }
                        this.write((byte)2, null);
                        break;
                    }
                    case 2: {
                        if (this.req_len != 32) {
                            throw new Exception("missing hash,seed");
                        }
                        System.arraycopy(this.req, pos, this.hash_md5, 0, 16);
                        this.md5.init();
                        this.md5.add(this.req, pos += 16, 16);
                        this.md5.add(this.file_data, 0, block_len);
                        byte[] res = this.md5.done();
                        if (debug) {
                            FileSyncServer.print_hash(res);
                        }
                        if (Arrays.compare(res, this.hash_md5) == 0) {
                            this.write((byte)3, null);
                            break;
                        }
                        this.write((byte)2, null);
                        break;
                    }
                    default: {
                        throw new Exception("unknown hash");
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_file_block_data() {
            if (this.file_io == null) {
                return this.error((byte)1);
            }
            if (this.req_len < 9) {
                return this.error((byte)1);
            }
            int pos = 0;
            long file_offset = LE.getuint64(this.req, pos);
            this.req_len -= 8;
            pos += 8;
            try {
                this.file_io.seek(file_offset);
                if (this.file_io.getFilePointer() != file_offset) {
                    throw new Exception("seek failed");
                }
                this.file_io.write(this.req, pos, this.req_len);
                this.write((byte)0, null);
            }
            catch (Exception e) {
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_file_truncate() {
            if (this.file_io == null) {
                return this.error((byte)1);
            }
            if (this.req_len != 8) {
                return this.error((byte)1);
            }
            int pos = 0;
            long file_size = LE.getuint64(this.req, pos);
            this.req_len -= 8;
            pos += 8;
            try {
                this.file_io.setLength(file_size);
                file_size = this.file_io.length();
                this.write((byte)0, null);
            }
            catch (Exception e) {
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_file_create() {
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            this.filename = LE.getString(this.req, 0, this.req_len);
            if (this.filename.contains("..") || this.filename.contains("/")) {
                return this.error((byte)1);
            }
            String path = this.this$0.root + this.folder + this.filename;
            try {
                File file = new File(path);
                this.file_open(file);
                this.write((byte)0, null);
            }
            catch (Exception e) {
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_file_delete() {
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            this.filename = LE.getString(this.req, 0, this.req_len);
            if (this.filename.contains("..") || this.filename.contains("/")) {
                return this.error((byte)1);
            }
            String path = this.this$0.root + this.folder + this.filename;
            try {
                File file = new File(path);
                if (!file.exists()) {
                    this.write((byte)4, null);
                    return true;
                }
                if (file.delete()) {
                    this.write((byte)0, null);
                } else {
                    this.write((byte)1, null);
                }
            }
            catch (Exception e) {
                return this.error((byte)1);
            }
            return true;
        }

        private boolean req_folder_open() {
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            String new_folder = "/" + LE.getString(this.req, 0, this.req_len) + "/";
            if (new_folder.contains("..")) {
                return this.error((byte)1);
            }
            File file = new File(this.this$0.root + new_folder);
            if (!file.exists() || !file.isDirectory()) {
                return this.error((byte)1);
            }
            this.folder = new_folder;
            this.write((byte)0, null);
            return true;
        }

        private boolean req_folder_create() {
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            String new_folder = "/" + LE.getString(this.req, 0, this.req_len) + "/";
            if (new_folder.contains("..")) {
                return this.error((byte)1);
            }
            File file = new File(this.this$0.root + new_folder);
            if (file.mkdirs()) {
                this.folder = new_folder;
                this.write((byte)0, null);
            } else {
                this.write((byte)1, null);
            }
            return true;
        }

        private boolean req_folder_delete() {
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            String sub_folder = "/" + LE.getString(this.req, 0, this.req_len) + "/";
            if (sub_folder.contains("..") || !sub_folder.startsWith("/") || !sub_folder.endsWith("/")) {
                return this.error((byte)1);
            }
            File file = new File(this.this$0.root + sub_folder);
            if (!file.exists()) {
                return this.error((byte)4);
            }
            if (!file.isDirectory()) {
                return this.error((byte)1);
            }
            if (file.delete()) {
                this.write((byte)0, null);
            } else {
                this.write((byte)1, null);
            }
            return true;
        }

        private boolean req_folder_list() {
            StringBuilder list;
            if (this.file_io != null) {
                this.file_close();
            }
            if (this.req_len < 1) {
                return this.error((byte)1);
            }
            String sub_folder = LE.getString(this.req, 0, this.req_len);
            if (sub_folder.contains("..") || !sub_folder.startsWith("/") || !sub_folder.endsWith("/")) {
                return this.error((byte)1);
            }
            File file = new File(this.this$0.root + sub_folder);
            if (file.exists() && file.isDirectory()) {
                File[] files;
                list = new StringBuilder();
                for (File child : files = file.listFiles()) {
                    String name = child.getName();
                    if (child.isDirectory()) {
                        list.append("/");
                    }
                    list.append(name);
                    list.append("\n");
                }
            } else {
                return this.error((byte)1);
            }
            byte[] binlist = list.toString().getBytes();
            this.write((byte)0, binlist);
            return true;
        }
    }

    private class Server
    extends Thread {
        public boolean active;
        public ServerSocket ss;
        public IP4Port bind;
        final /* synthetic */ FileSyncServer this$0;

        private Server(FileSyncServer fileSyncServer) {
            FileSyncServer fileSyncServer2 = fileSyncServer;
            Objects.requireNonNull(fileSyncServer2);
            this.this$0 = fileSyncServer2;
            this.bind = new IP4Port();
        }

        @Override
        public void run() {
            this.active = true;
            if (!embedded) {
                JFLog.append(JF.getLogPath() + "/jffilesync.log", true);
                JFLog.setRetention(30);
                JFLog.log("FileSync : Starting service");
            }
            JFLog.log("FileSyncServer:CreateServerSocketSSL on port 33203");
            KeyMgmt keys = new KeyMgmt();
            if (!new File(FileSyncServer.getKeyFile()).exists()) {
                JFLog.log("FileSyncServer:Warning:Generating self-signed SSL keys");
                FileSyncServer.genKeyFile();
            }
            try {
                FileInputStream fis = new FileInputStream(FileSyncServer.getKeyFile());
                keys.open(fis, "password");
                fis.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.ss = JF.createServerSocketSSL(keys);
            this.bind.setIP("0.0.0.0");
            this.bind.port = 33203;
            try {
                this.ss.bind(this.bind.toInetSocketAddress());
                while (this.active) {
                    Socket s = this.ss.accept();
                    Client client = new Client(this.this$0, s);
                    this.this$0.addClient(client);
                    client.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }
}

