/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LDAP;
import javaforce.MD5;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.EMail;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;

public class POP3Server {
    public static final String busPack = "net.sf.jfpop3";
    public static boolean debug = false;
    private Server server;
    private ArrayList<ServerWorker> servers = new ArrayList();
    private ArrayList<ClientWorker> clients = new ArrayList();
    private String domain;
    private String ldap_domain;
    private String ldap_server;
    private ArrayList<EMail> users;
    private Object lock = new Object();
    private IP4Port bind = new IP4Port();
    private ArrayList<Subnet4> subnet_src_list;
    private ArrayList<Integer> ports = new ArrayList();
    private ArrayList<Integer> ssl_ports = new ArrayList();
    private static final int FLAG_ADMIN = 1;
    private static final String defaultConfig = "[global]\nport=110\n#secure=995\n#bind=192.168.100.2\n#domain=example.com\n#ldap_domain=example.com\n#ldap_server=192.168.200.2\n#admin=user:pass\n#account=user:pass\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n";
    private static POP3Server pop3;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfpop3.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfpop3.log";
    }

    public static String getMailboxFolder(String user) {
        StringBuilder path = new StringBuilder();
        if (JF.isWindows()) {
            path.append(System.getenv("ProgramData").replaceAll("\\\\", "/"));
            path.append("/jfsmtp/mail");
        } else {
            path.append("/var/jfsmtp/mail");
        }
        if (user != null) {
            path.append("/");
            path.append(user);
        }
        String mail = path.toString();
        new File(mail).mkdirs();
        return mail;
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33010;
        }
        return 777;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(ClientWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(ClientWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(sess);
        }
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jfpop3.key";
    }

    public void start() {
        this.stop();
        this.server = new Server(this);
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        Object object = this.lock;
        synchronized (object) {
            ClientWorker[] ca;
            ServerWorker[] sa;
            for (ServerWorker s : sa = this.servers.toArray(new ServerWorker[0])) {
                s.close();
            }
            this.servers.clear();
            for (ClientWorker s : ca = this.clients.toArray(new ClientWorker[0])) {
                s.close();
            }
            this.clients.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        this.users = new ArrayList();
        Section section = Section.None;
        this.bind.setIP("0.0.0.0");
        this.bind.port = 110;
        this.subnet_src_list = new ArrayList();
        try {
            BufferedReader br = new BufferedReader(new FileReader(POP3Server.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                block2 : switch (section.ordinal()) {
                    case 0: 
                    case 1: {
                        switch (key) {
                            case "port": {
                                this.ports.add(Integer.valueOf(ln.substring(5)));
                                break;
                            }
                            case "secure": {
                                this.ssl_ports.add(Integer.valueOf(ln.substring(7)));
                                break;
                            }
                            case "bind": {
                                if (this.bind.setIP(value)) break;
                                JFLog.log("SMTP:bind:Invalid IP:" + value);
                                break;
                            }
                            case "admin": 
                            case "account": {
                                EMail user = new EMail();
                                int cln = value.indexOf(58);
                                if (cln == -1) {
                                    JFLog.log("Invalid user:" + value);
                                    break block2;
                                }
                                user.user = value.substring(0, cln);
                                user.pass = value.substring(cln + 1);
                                user.flags = key.equals("admin") ? 1 : 0;
                                this.users.add(user);
                                break;
                            }
                            case "domain": {
                                this.domain = value;
                                break;
                            }
                            case "ldap_domain": {
                                this.ldap_domain = value;
                                break;
                            }
                            case "ldap_server": {
                                this.ldap_server = value;
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("POP3:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("POP3:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("POP3:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("POP3:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(POP3Server.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private boolean ip_src_allowed(String ip4) {
        if (this.subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : this.subnet_src_list) {
            if (!net.isWithin(target)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(POP3Server.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        pop3 = new POP3Server();
        pop3.start();
    }

    public static void serviceStop() {
        JFLog.log("POP3 : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        pop3.stop();
    }

    public static boolean createKeys() {
        return KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfpop3", "-keypass", "password", "-storepass", "password", "-keystore", POP3Server.getKeyFile(), "-validity", "3650", "-dname", "CN=jfpop3.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"});
    }

    private class Server
    extends Thread {
        private boolean active;
        final /* synthetic */ POP3Server this$0;

        private Server(POP3Server pOP3Server) {
            POP3Server pOP3Server2 = pOP3Server;
            Objects.requireNonNull(pOP3Server2);
            this.this$0 = pOP3Server2;
        }

        @Override
        public void run() {
            this.active = true;
            JFLog.append(JF.getLogPath() + "/jfpop3.log", true);
            JFLog.setRetention(30);
            JFLog.log("POP3 : Starting service");
            try {
                ServerWorker worker;
                this.this$0.loadConfig();
                this.this$0.busClient = new JBusClient(POP3Server.busPack, new JBusMethods());
                this.this$0.busClient.setPort(POP3Server.getBusPort());
                this.this$0.busClient.start();
                for (int p : this.this$0.ports) {
                    worker = new ServerWorker(this.this$0, p, false);
                    worker.start();
                    this.this$0.servers.add(worker);
                }
                for (int p : this.this$0.ssl_ports) {
                    worker = new ServerWorker(this.this$0, p, true);
                    worker.start();
                    this.this$0.servers.add(worker);
                }
                while (this.active) {
                    JF.sleep(1000);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class ServerWorker
    extends Thread {
        private ServerSocket ss;
        private int port;
        private boolean secure;
        private boolean worker_active;
        final /* synthetic */ POP3Server this$0;

        public ServerWorker(POP3Server this$0, int port, boolean secure) {
            POP3Server pOP3Server = this$0;
            Objects.requireNonNull(pOP3Server);
            this.this$0 = pOP3Server;
            this.port = port;
            this.secure = secure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object keys;
                if (this.secure) {
                    JFLog.log("CreateServerSocketSSL");
                    keys = new KeyMgmt();
                    if (new File(POP3Server.getKeyFile()).exists()) {
                        FileInputStream fis = new FileInputStream(POP3Server.getKeyFile());
                        ((KeyMgmt)keys).open(fis, "password");
                        fis.close();
                    } else {
                        JFLog.log("Warning:Server SSL Keys not generated!");
                    }
                    this.ss = JF.createServerSocketSSL((KeyMgmt)keys);
                } else {
                    this.ss = new ServerSocket();
                }
                keys = this.this$0.bind;
                synchronized (keys) {
                    this.this$0.bind.port = this.port;
                    this.ss.bind(this.this$0.bind.toInetSocketAddress());
                }
                this.worker_active = true;
                while (this.worker_active) {
                    Socket s = this.ss.accept();
                    InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                    String src_ip = sa.getAddress().getHostAddress();
                    if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                        src_ip = "127.0.0.1";
                    }
                    if (!this.this$0.ip_src_allowed(src_ip)) {
                        JFLog.log("POP3:Source IP blocked:" + src_ip);
                        s.close();
                        continue;
                    }
                    ClientWorker sess = new ClientWorker(this.this$0, s, this.secure);
                    this.this$0.addSession(sess);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    public class ClientWorker
    extends Thread {
        private Socket c;
        private boolean secure;
        private InputStream cis;
        private OutputStream cos;
        private byte[] req;
        private int reqSize;
        private byte[] buffer;
        private int bufferSize;
        private String mailbox;
        private File[] files;
        private String user;
        private boolean admin;
        private static final int bufsiz = 1460;
        final /* synthetic */ POP3Server this$0;

        public ClientWorker(POP3Server this$0, Socket s, boolean secure) {
            POP3Server pOP3Server = this$0;
            Objects.requireNonNull(pOP3Server);
            this.this$0 = pOP3Server;
            this.cis = null;
            this.cos = null;
            this.req = new byte[1500];
            this.reqSize = 0;
            this.buffer = new byte[1500];
            this.bufferSize = 0;
            this.c = s;
            this.secure = secure;
        }

        public void close() {
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String readln() {
            if (this.bufferSize > 0) {
                System.arraycopy(this.buffer, 0, this.req, 0, this.bufferSize);
                this.reqSize = this.bufferSize;
                this.bufferSize = 0;
            } else {
                this.reqSize = 0;
            }
            try {
                while (this.c != null && this.c.isConnected()) {
                    int read;
                    if (this.reqSize >= 2) {
                        for (int idx = 2; idx <= this.reqSize; ++idx) {
                            if (this.req[idx - 2] != 13 || this.req[idx - 1] != 10) continue;
                            int left = this.reqSize - idx;
                            if (left > 0) {
                                System.arraycopy(this.req, idx, this.buffer, 0, left);
                                this.bufferSize = left;
                            }
                            return new String(this.req, 0, idx - 2).trim();
                        }
                    }
                    if (this.reqSize == this.req.length) {
                        if (this.req.length >= 12000) {
                            throw new Exception("data too large");
                        }
                        int newSize = this.req.length << 1;
                        byte[] new_req = new byte[newSize];
                        this.buffer = new byte[newSize];
                        System.arraycopy(this.req, 0, new_req, 0, this.req.length);
                        this.req = new_req;
                    }
                    if ((read = this.cis.read(this.req, this.reqSize, this.req.length - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            return null;
        }

        @Override
        public void run() {
            block4: {
                try {
                    String cmd;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.cos.write(("+OK jfPOP3 Server/" + JF.getVersion() + "\r\n").getBytes());
                    this.cos.flush();
                    while (this.c.isConnected() && (cmd = this.readln()) != null) {
                        if (cmd.equalsIgnoreCase("QUIT")) {
                            this.cos.write("+OK Goodbye\r\n".getBytes());
                            break;
                        }
                        this.doCommand(cmd);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block4;
                    JFLog.log(e);
                }
            }
            this.close();
            this.this$0.removeSession(this);
        }

        public boolean login(String user, String pass, boolean _md5) {
            for (EMail acct : this.this$0.users) {
                if (!acct.user.equals(user)) continue;
                boolean bl = this.admin = (acct.flags & 1) != 0;
                if (_md5) {
                    MD5 md5 = new MD5();
                    md5.add(acct.pass);
                    return md5.toString().equals(pass);
                }
                return acct.pass.equals(pass);
            }
            if (this.this$0.ldap_server != null && this.this$0.ldap_domain != null) {
                LDAP ldap = new LDAP();
                return ldap.login(this.this$0.ldap_server, this.this$0.ldap_domain, user, pass);
            }
            return false;
        }

        private void doCommand(String cmd) throws Exception {
            if (debug) {
                JFLog.log("Request=" + cmd);
            }
            String[] p = cmd.split(" ", 2);
            switch (p[0].toUpperCase()) {
                case "APOP": {
                    String[] c_u_p = cmd.split(" ", 3);
                    this.user = c_u_p[1];
                    String pass = c_u_p[2];
                    if (!this.login(this.user, pass, true)) {
                        JF.sleep(1000);
                        this.cos.write("-ERR Login failed\r\n".getBytes());
                        this.close();
                        return;
                    }
                    this.cos.write("+OK Login successful\r\n".getBytes());
                    this.setupMailbox();
                    break;
                }
                case "USER": {
                    this.user = p[1];
                    this.cos.write("+OK User Accepted\r\n".getBytes());
                    break;
                }
                case "PASS": {
                    if (this.user == null) {
                        this.cos.write("-ERR Login failed\r\n".getBytes());
                        this.close();
                        return;
                    }
                    String pass = p[1];
                    if (!this.login(this.user, pass, false)) {
                        JF.sleep(1000);
                        this.cos.write("-ERR Login failed\r\n".getBytes());
                        this.close();
                        return;
                    }
                    this.cos.write("+OK Login successful\r\n".getBytes());
                    this.setupMailbox();
                    break;
                }
                case "STARTTLS": {
                    if (this.secure) {
                        this.cos.write("-ERR Already secure\r\n".getBytes());
                        break;
                    }
                    this.cos.write("+OK Switching to TLS\r\n".getBytes());
                    this.c = JF.connectSSL(this.c, KeyMgmt.getDefaultClient());
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.secure = true;
                    break;
                }
                case "STAT": {
                    this.cos.write(this.stat().getBytes());
                    break;
                }
                case "LIST": {
                    this.cos.write(this.list().getBytes());
                    break;
                }
                case "RETR": {
                    if (this.mailbox == null) {
                        this.cos.write("-ERR mailbox not ready\r\n".getBytes());
                        break;
                    }
                    int idx = this.getIndex(p[1]);
                    if (--idx < 0 || idx >= this.files.length || this.files[idx] == null) {
                        this.cos.write("-ERR message not found\r\n".getBytes());
                        break;
                    }
                    try {
                        int read;
                        File file = this.files[idx];
                        String realfile = POP3Server.getMailboxFolder(null) + "/" + file.getName();
                        FileInputStream fis = new FileInputStream(realfile);
                        long size = file.length();
                        this.cos.write(("+OK " + size + " octets\r\n").getBytes());
                        byte[] buf = new byte[1460];
                        for (long sent = 0L; sent < size && (read = fis.read(buf)) != -1; sent += (long)read) {
                            this.cos.write(buf, 0, read);
                        }
                        fis.close();
                        this.cos.write(".\r\n".getBytes());
                    }
                    catch (Exception e) {
                        this.cos.write("-ERR error\r\n".getBytes());
                        JFLog.log(e);
                    }
                    break;
                }
                case "DELE": {
                    if (this.mailbox == null) {
                        this.cos.write("-ERR mailbox not ready\r\n".getBytes());
                        break;
                    }
                    int idx = this.getIndex(p[1]);
                    if (--idx < 0 || idx >= this.files.length || this.files[idx] == null) {
                        this.cos.write("-ERR message not found\r\n".getBytes());
                        break;
                    }
                    try {
                        this.deleteMsg(this.files[idx]);
                        this.files[idx] = null;
                        this.cos.write(("+OK message " + (idx + 1) + " deleted\r\n").getBytes());
                    }
                    catch (Exception e) {
                        this.cos.write("-ERR error\r\n".getBytes());
                        JFLog.log(e);
                    }
                    break;
                }
                case "UIDL": {
                    String start = "1";
                    if (p.length > 1) {
                        start = p[1];
                    }
                    this.cos.write(this.uidl(start).getBytes());
                    break;
                }
                case "NOOP": {
                    this.cos.write("+OK no operation\r\n".getBytes());
                    break;
                }
                default: {
                    this.cos.write("-ERR Unknown command\r\n".getBytes());
                }
            }
        }

        private int getIndex(String arg) {
            int idx;
            if (arg.startsWith("T-")) {
                String find = arg.substring(2) + ".msg";
                idx = 0;
                int offset = 1;
                for (File file : this.files) {
                    if (file.getName().equals(find)) {
                        idx = offset;
                        break;
                    }
                    ++offset;
                }
            } else {
                idx = Integer.valueOf(arg);
            }
            return idx;
        }

        private void reset() {
            this.mailbox = null;
            this.files = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteMsg(File file) {
            Object object = this.this$0.lock;
            synchronized (object) {
                try {
                    String[] lns;
                    if (this.admin) {
                        file.delete();
                        return;
                    }
                    String filename = file.getName();
                    FileInputStream fis = new FileInputStream(file);
                    byte[] data = fis.readAllBytes();
                    fis.close();
                    file.delete();
                    for (String ln : lns = new String(data).split("\r\n")) {
                        String to_user;
                        String usermailbox;
                        if (!ln.startsWith("to:") || !new File((usermailbox = POP3Server.getMailboxFolder(to_user = ln.substring(3))) + "/" + filename).exists()) continue;
                        return;
                    }
                    String mailbox = POP3Server.getMailboxFolder(null);
                    String msgfile = mailbox + "/" + filename;
                    new File(msgfile).delete();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }

        private void setupMailbox() {
            this.mailbox = this.admin ? POP3Server.getMailboxFolder(null) : POP3Server.getMailboxFolder(this.user);
            this.listFiles();
        }

        private void listFiles() {
            this.files = new File(this.mailbox).listFiles(new FilenameFilter(this){
                {
                    Objects.requireNonNull(this$1);
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".msg");
                }
            });
        }

        private String stat() {
            if (this.mailbox == null) {
                return "-ERR Mailbox not ready\r\n";
            }
            int cnt = 0;
            int size = 0;
            this.listFiles();
            for (File file : this.files) {
                ++cnt;
                size = (int)((long)size + file.length());
            }
            StringBuilder reply = new StringBuilder();
            reply.append("+OK ");
            reply.append(cnt);
            reply.append(" ");
            reply.append(size);
            reply.append("\r\n");
            return reply.toString();
        }

        private String list() {
            if (this.mailbox == null) {
                return "-ERR Mailbox not ready\r\n";
            }
            int cnt = 0;
            int size = 0;
            StringBuilder list = new StringBuilder();
            int idx = 1;
            this.listFiles();
            for (File file : this.files) {
                ++cnt;
                long msgsize = file.length();
                size = (int)((long)size + msgsize);
                list.append(idx++);
                list.append(" ");
                list.append(msgsize);
                list.append("\r\n");
            }
            StringBuilder reply = new StringBuilder();
            reply.append("+OK ");
            reply.append(cnt);
            reply.append(" ");
            reply.append(size);
            reply.append("\r\n");
            reply.append((CharSequence)list);
            reply.append(".\r\n");
            return reply.toString();
        }

        private String uidl(String start) {
            if (this.mailbox == null) {
                return "-ERR Mailbox not ready\r\n";
            }
            int sidx = 1;
            if (start.length() > 0) {
                sidx = JF.atoi(start);
            }
            StringBuilder list = new StringBuilder();
            int idx = 0;
            this.listFiles();
            for (File file : this.files) {
                String filename = file.getName();
                int ext = filename.indexOf(46);
                filename = filename.substring(0, ext);
                if (++idx < sidx) continue;
                list.append(idx);
                list.append(" T-");
                list.append(filename);
                list.append("\r\n");
            }
            StringBuilder reply = new StringBuilder();
            reply.append("+OK unique ID list follows...\r\n");
            reply.append((CharSequence)list);
            reply.append(".\r\n");
            return reply.toString();
        }
    }

    static enum Section {
        None,
        Global;

    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = POP3Server.pop3.busClient;
            JBusClient cfr_ignored_1 = POP3Server.pop3.busClient;
            POP3Server.pop3.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(POP3Server.pop3.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(POP3Server.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            pop3.stop();
            pop3 = new POP3Server();
            pop3.start();
        }

        public void genKeys(String pack) {
            if (POP3Server.createKeys()) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = POP3Server.pop3.busClient;
                POP3Server.pop3.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = POP3Server.pop3.busClient;
                POP3Server.pop3.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }
}

