/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Vector;
import javaforce.FTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ProxyServer {
    public static final String busPack = "net.sf.jfproxy";
    private Server server;
    private ServerSocket ss;
    private Vector<Session> list = new Vector();
    private ArrayList<String> blockedDomain = new ArrayList();
    private ArrayList<String> blockedURL = new ArrayList();
    private ArrayList<URLChange> urlChanges = new ArrayList();
    private ArrayList<Integer> allow_net = new ArrayList();
    private ArrayList<Integer> allow_mask = new ArrayList();
    private int port = 3128;
    private int nextSSLport = 8081;
    private boolean filtersecure = false;
    private HashMap<String, SecureSite> secureSites = new HashMap();
    private String keyPath;
    private SSLSocketFactory sslSocketFactory;
    private static final String defaultConfig = "[global]\nport=3128\nallow=0.0.0.0/0 #allow all\n#allow=192.168.0.0/24 #allow subnet\n#allow=10.1.2.3/32 #allow single ip\n\n[blockdomain]\n.*youtube[.]com\n\n[urlchange]\n#www.example.com/test = www.google.com\n";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;
    private static ProxyServer proxy;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfproxy.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfproxy.log";
    }

    public void start() {
        this.stop();
        this.server = new Server(this);
        this.server.start();
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.busClient.close();
        while (this.list.size() > 0) {
            Session sess = this.list.get(0);
            sess.close();
        }
        if (this.filtersecure) {
            SecureSite[] ssList = this.secureSites.values().toArray(new SecureSite[0]);
            for (int a = 0; a < ssList.length; ++a) {
                ssList[a].close();
            }
            this.secureSites.clear();
            this.deleteKeys();
        }
        this.server = null;
    }

    public void deleteKeys() {
        File[] files = new File(this.keyPath).listFiles();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                if (files[a].getName().startsWith("localhost.")) continue;
                files[a].delete();
            }
        }
    }

    public boolean keytool(String[] args) {
        ArrayList<Object> cmd = new ArrayList<Object>();
        try {
            if (JF.isWindows()) {
                cmd.add(System.getProperty("java.home") + "\\bin\\keytool.exe");
            } else {
                cmd.add(System.getProperty("java.home") + "/bin/keytool");
            }
            for (int a = 0; a < args.length; ++a) {
                cmd.add(args[a]);
            }
            Process p = Runtime.getRuntime().exec(cmd.toArray(JF.StringArrayType), null, new File(this.keyPath));
            p.waitFor();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private void loadConfig() {
        this.filtersecure = false;
        Section section = Section.None;
        try {
            String ln;
            StringBuilder cfg = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(ProxyServer.getConfigFile()));
            while ((ln = br.readLine()) != null) {
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim().toLowerCase();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                if (ln.equals("[blockdomain]")) {
                    section = Section.BlockDomain;
                    continue;
                }
                if (ln.equals("[urlchange]")) {
                    section = Section.URLChange;
                    continue;
                }
                if (ln.equals("[blockurl]")) {
                    section = Section.BlockURL;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx).toLowerCase().trim();
                String value = ln.substring(idx + 1).trim();
                block2 : switch (section.ordinal()) {
                    case 1: {
                        switch (key) {
                            case "port": {
                                this.port = JF.atoi(value);
                                break block2;
                            }
                            case "filtersecure": {
                                this.filtersecure = value.equals("true");
                                break block2;
                            }
                            case "allow": {
                                String net_mask = value;
                                idx = net_mask.indexOf("/");
                                String net = net_mask.substring(0, idx);
                                int addr = ProxyServer.getIP(net);
                                this.allow_net.add(addr);
                                String mask = net_mask.substring(idx + 1);
                                int maskBits = this.getMask(mask);
                                this.allow_mask.add(maskBits);
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.blockedDomain.add(ln);
                        break;
                    }
                    case 3: {
                        int eq = ln.indexOf(" = ");
                        if (eq == -1) {
                            JFLog.log("Bad URLChange:" + ln);
                            break;
                        }
                        URLChange uc = new URLChange();
                        uc.url = ln.substring(0, eq);
                        uc.newurl = ln.substring(eq + 3);
                        this.urlChanges.add(uc);
                        break;
                    }
                    case 4: {
                        this.blockedURL.add(ln);
                    }
                }
            }
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            try {
                FileOutputStream fos = new FileOutputStream(ProxyServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static int ba2int(byte[] ba) {
        int ret = 0;
        for (int a = 0; a < 4; ++a) {
            ret <<= 8;
            ret += ba[a] & 0xFF;
        }
        return ret;
    }

    private static int getIP(String ip) {
        String[] p = ip.split("[.]");
        byte[] o = new byte[4];
        for (int a = 0; a < 4; ++a) {
            o[a] = (byte)JF.atoi(p[a]);
        }
        return ProxyServer.ba2int(o);
    }

    private int getMask(String mask) {
        int bits = JF.atoi(mask);
        if (bits == 0) {
            return 0;
        }
        int ret = Integer.MIN_VALUE;
        --bits;
        while (bits > 0) {
            ret >>= 1;
            --bits;
        }
        return ret;
    }

    private void initSSL() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext gsc = SSLContext.getInstance("SSL");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(this.keyPath + "/localhost.key"), "password".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, "password".toCharArray());
            gsc.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
            this.sslSocketFactory = gsc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSSLPort(String host) {
        SecureSite secureSite;
        if (host.equals("localhost")) {
            return -1;
        }
        if (host.equals("127.0.0.1")) {
            return -1;
        }
        Object object = this.secureSites;
        synchronized (object) {
            secureSite = this.secureSites.get(host);
            if (secureSite != null) {
                return secureSite.port;
            }
            JFLog.log("Creating new SSL site:" + host);
            secureSite = new SecureSite(this, host, this.nextSSLport++);
            this.secureSites.put(host, secureSite);
        }
        object = secureSite.lock;
        synchronized (object) {
            secureSite.start();
            try {
                secureSite.lock.wait();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
        return secureSite.port;
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33003;
        }
        return 777;
    }

    public static void main(String[] args) {
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(ProxyServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        proxy = new ProxyServer();
        proxy.start();
    }

    public static void serviceStop() {
        JFLog.log("Proxy : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        proxy.stop();
    }

    private class Server
    extends Thread {
        public boolean active;
        final /* synthetic */ ProxyServer this$0;

        private Server(ProxyServer proxyServer) {
            ProxyServer proxyServer2 = proxyServer;
            Objects.requireNonNull(proxyServer2);
            this.this$0 = proxyServer2;
        }

        @Override
        public void run() {
            JFLog.append(ProxyServer.getLogFile(), true);
            JFLog.setRetention(30);
            JFLog.log("Proxy : Starting service");
            this.this$0.loadConfig();
            this.this$0.busClient = new JBusClient(ProxyServer.busPack, new JBusMethods());
            this.this$0.busClient.setPort(ProxyServer.getBusPort());
            this.this$0.busClient.start();
            if (this.this$0.filtersecure) {
                JFLog.log("Setting up secure server...");
                this.this$0.keyPath = JF.getConfigPath() + "/jfproxy";
                new File(this.this$0.keyPath).mkdir();
                this.this$0.deleteKeys();
                if (!new File(this.this$0.keyPath + "/localhost.key").exists()) {
                    this.this$0.keytool(new String[]{"-genkeypair", "-alias", "localhost", "-keystore", "localhost.key", "-storepass", "password", "-keypass", "password", "-keyalg", "RSA", "-dname", "CN=localhost, OU=JavaForce, O=JavaForce, C=CA", "-validity", "3650", "-ext", "KeyUsage=digitalSignature,keyEncipherment,keyCertSign,codeSigning", "-ext", "ExtendedKeyUsage=serverAuth,clientAuth", "-ext", "BasicConstraints=ca:true,pathlen:3"});
                    this.this$0.keytool(new String[]{"-exportcert", "-alias", "localhost", "-keystore", "localhost.key", "-storepass", "password", "-file", "localhost.crt"});
                }
                this.this$0.initSSL();
            }
            for (int a = 0; a < 5; ++a) {
                try {
                    this.this$0.ss = new ServerSocket(this.this$0.port);
                    break;
                }
                catch (Exception e) {
                    if (a == 4) {
                        return;
                    }
                    JF.sleep(1000);
                    continue;
                }
            }
            try {
                JFLog.log("Starting proxy on port " + this.this$0.port);
                while (this.active) {
                    Socket s = this.this$0.ss.accept();
                    Session sess = new Session(this.this$0, s, false);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private class Session
    extends Thread {
        private Socket p;
        private Socket i;
        private InputStream pis;
        private InputStream iis;
        private OutputStream pos;
        private OutputStream ios;
        private boolean disconn;
        private int client_port;
        private String client_ip;
        private boolean secure;
        final /* synthetic */ ProxyServer this$0;

        public synchronized void close() {
            try {
                if (this.p != null && this.p.isConnected()) {
                    this.p.close();
                }
                this.p = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.i != null && this.i.isConnected()) {
                    this.i.close();
                }
                this.i = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.this$0.list.remove(this);
        }

        public Session(ProxyServer proxyServer, Socket s, boolean secure) {
            ProxyServer proxyServer2 = proxyServer;
            Objects.requireNonNull(proxyServer2);
            this.this$0 = proxyServer2;
            this.disconn = false;
            this.p = s;
            this.secure = secure;
        }

        public String toString(int ip) {
            long ip64 = (long)ip & 0xFFFFFFFFL;
            return Long.toString(ip64, 16);
        }

        private void log(String s) {
            JFLog.log(this.client_ip + ":" + this.client_port + ":" + s);
        }

        private void log(Exception e) {
            Object s = e.toString();
            StackTraceElement[] stack = e.getStackTrace();
            for (int a = 0; a < stack.length; ++a) {
                s = (String)s + "\r\n" + stack[a].toString();
            }
            this.log((String)s);
        }

        @Override
        public void run() {
            block6: {
                Object req = "";
                this.this$0.list.add(this);
                this.client_port = this.p.getPort();
                this.client_ip = this.p.getInetAddress().getHostAddress();
                this.log("Session Start");
                try {
                    boolean allowed = false;
                    for (int a = 0; a < this.this$0.allow_net.size(); ++a) {
                        int host;
                        int mask;
                        int net = this.this$0.allow_net.get(a);
                        if ((net & (mask = this.this$0.allow_mask.get(a).intValue())) != ((host = this.getIP(this.p)) & mask)) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) {
                        throw new Exception("client not allowed");
                    }
                    this.pis = this.p.getInputStream();
                    this.pos = this.p.getOutputStream();
                    do {
                        int ch;
                        req = "";
                        this.log("reading request");
                        do {
                            if ((ch = this.pis.read()) != -1) continue;
                            throw new Exception("read error");
                        } while (!((String)(req = (String)req + (char)ch)).endsWith("\r\n\r\n"));
                        this.proxy((String)req);
                    } while (!this.disconn);
                    this.log("disconn");
                    this.p.close();
                }
                catch (Exception e) {
                    if (((String)req).length() <= 0) break block6;
                    this.log(e);
                }
            }
            this.close();
            this.log("Session Stop");
        }

        private int getIP(Socket s) {
            if (s.getInetAddress().isLoopbackAddress()) {
                return 2130706433;
            }
            byte[] o = s.getInetAddress().getAddress();
            return ProxyServer.ba2int(o);
        }

        private void proxy(String req) throws Exception {
            String[] ln = req.split("\r\n");
            this.log("Proxy:" + ln[0]);
            int hostidx = -1;
            if (ln[0].endsWith("1.0")) {
                this.disconn = true;
            }
            for (int a = 0; a < ln.length; ++a) {
                if (!ln[a].regionMatches(true, 0, "Host: ", 0, 6)) continue;
                hostidx = a;
            }
            if (hostidx == -1) {
                this.log("ERROR : No host specified : " + req);
                this.replyError(505, "No host specified");
                return;
            }
            String hostln = ln[hostidx].substring(6);
            try {
                int a;
                String host;
                int port;
                String method = null;
                String proto = null;
                String url = null;
                String http = null;
                String[] f = ln[0].split(" ");
                method = f[0];
                url = f[1];
                http = f[2];
                if (url.startsWith("http://")) {
                    proto = "http://";
                    url = url.substring(7);
                    port = 80;
                } else if (url.startsWith("ftp://")) {
                    proto = "ftp://";
                    url = url.substring(6);
                    port = 21;
                } else {
                    proto = "http://";
                    port = this.secure ? 443 : 80;
                }
                int portidx = hostln.indexOf(58);
                if (portidx != -1) {
                    host = hostln.substring(0, portidx);
                    port = Integer.valueOf(hostln.substring(portidx + 1));
                } else {
                    host = hostln;
                }
                host = host.trim().toLowerCase();
                for (a = 0; a < this.this$0.blockedDomain.size(); ++a) {
                    if (!host.matches(this.this$0.blockedDomain.get(a))) continue;
                    this.replyError(505, "Access Denied");
                    return;
                }
                for (a = 0; a < this.this$0.blockedURL.size(); ++a) {
                    if (!(host + "/" + url).matches(this.this$0.blockedURL.get(a))) continue;
                    this.replyError(505, "Access Denied");
                    return;
                }
                if (method.equals("CONNECT")) {
                    this.connectCommand(host, ln[0]);
                    return;
                }
                for (a = 0; a < this.this$0.urlChanges.size(); ++a) {
                    URLChange uc = this.this$0.urlChanges.get(a);
                    if (!url.matches(uc.url)) continue;
                    url = uc.newurl;
                    ln[0] = method + " " + proto + url + " " + http;
                    int iport = url.indexOf(":");
                    int iurl = url.indexOf("/");
                    if (iurl == -1) {
                        iurl = url.length();
                    }
                    if (iport == -1) {
                        port = 80;
                        host = url.substring(0, iurl);
                        ln[hostidx] = "Host: " + host;
                        break;
                    }
                    port = JF.atoi(url.substring(iport + 1, iurl));
                    host = url.substring(0, iport);
                    ln[hostidx] = "Host: " + host + ":" + port;
                    break;
                }
                if (proto.equals("http://")) {
                    this.connect(host, port);
                    this.sendRequest(ln);
                    if (method.equals("POST")) {
                        this.sendPost(ln);
                    }
                    this.relayReply(proto + url);
                } else {
                    this.ftp(host, port, url);
                }
                return;
            }
            catch (UnknownHostException uhe) {
                this.replyError(404, "Domain not found");
                this.log(uhe);
            }
            catch (IOException ioe) {
                this.log(ioe);
            }
            catch (Exception e) {
                this.replyError(505, "Exception:" + String.valueOf(e));
                this.log(e);
            }
        }

        private void connect(String host, int port) throws UnknownHostException, IOException {
            this.log("connect:" + host + ":" + port);
            this.i = !this.secure ? new Socket(host, port) : this.this$0.sslSocketFactory.createSocket(host, port);
            this.iis = this.i.getInputStream();
            this.ios = this.i.getOutputStream();
        }

        private void ftp(String host, int port, String url) throws Exception {
            int idx = url.indexOf(47);
            url = url.substring(idx);
            FTP ftp = new FTP();
            this.log("ftp:" + url);
            try {
                ftp.connect(host, port);
                ftp.login("anonymous", "nobody@jfproxy.sf.net");
                if (url.endsWith("/")) {
                    String ls = ftp.ls(url);
                    String[] lns = ls.replaceAll("\r", "").split("\n");
                    StringBuffer content = new StringBuffer();
                    content.append("<html><head>");
                    content.append("<style type=\"text/css\">\r\n");
                    content.append(".file\r\n {\r\nbackground :\r\n url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAABnRSTlMAAAAAAABupgeRAAABHUlEQVR42o2RMW7DIBiF3498iHRJD5JKHurL+CRVBp+i2T16tTynF2gO0KSb5ZrBBl4HHDBuK/WXACH4eO9/CAAAbdvijzLGNE1TVZXfZuHg6XCAQESAZXbOKaXO57eiKG6ft9PrKQIkCQqFoIiQFBGlFIB5nvM8t9aOX2Nd18oDzjnPgCDpn/BH4zh2XZdlWVmWiUK4IgCBoFMUz9eP6zRN75cLgEQhcmTQIbl72O0f9865qLAAsURAAgKBJKEtgLXWvyjLuFsThCSstb8rBCaAQhDYWgIZ7myM+TUBjDHrHlZcbMYYk34cN0YSLcgS+wL0fe9TXDMbY33fR2AYBvyQ8L0Gk8MwREBrTfKe4TpTzwhArXWi8HI84h/1DfwI5mhxJamFAAAAAElFTkSuQmCC') left top no-repeat;\r\npadding-left : 24px;\r\n}\r\n");
                    content.append(".folder\r\n {\r\nbackground :\r\n url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAd5JREFUeNqMU79rFUEQ/vbuodFEEkzAImBpkUabFP4ldpaJhZXYm/RiZWsv/hkWFglBUyTIgyAIIfgIRjHv3r39MePM7N3LcbxAFvZ2b2bn22/mm3XMjF+HL3YW7q28YSIw8mBKoBihhhgCsoORot9d3/ywg3YowMXwNde/PzGnk2vn6PitrT+/PGeNaecg4+qNY3D43vy16A5wDDd4Aqg/ngmrjl/GoN0U5V1QquHQG3q+TPDVhVwyBffcmQGJmSVfyZk7R3SngI4JKfwDJ2+05zIg8gbiereTZRHhJ5KCMOwDFLjhoBTn2g0ghagfKeIYJDPFyibJVBtTREwq60SpYvh5++PpwatHsxSm9QRLSQpEVSd7/TYJUb49TX7gztpjjEffnoVw66+Ytovs14Yp7HaKmUXeX9rKUoMoLNW3srqI5fWn8JejrVkK0QcrkFLOgS39yoKUQe292WJ1guUHG8K2o8K00oO1BTvXoW4yasclUTgZYJY9aFNfAThX5CZRmczAV52oAPoupHhWRIUUAOoyUIlYVaAa/VbLbyiZUiyFbjQFNwiZQSGl4IDy9sO5Wrty0QLKhdZPxmgGcDo8ejn+c/6eiK9poz15Kw7Dr/vN/z6W7q++091/AQYA5mZ8GYJ9K0AAAAAASUVORK5CYII=') left top no-repeat;\r\npadding-left : 24px;\r\n}\r\n");
                    content.append(".up\r\n {\r\nbackground :\r\n url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAmlJREFUeNpsU0toU0EUPfPysx/tTxuDH9SCWhUDooIbd7oRUUTMouqi2iIoCO6lceHWhegy4EJFinWjrlQUpVm0IIoFpVDEIthm0dpikpf3ZuZ6Z94nrXhhMjM3c8895977BBHB2PznK8WPtDgyWH5q77cPH8PpdXuhpQT4ifR9u5sfJb1bmw6VivahATDrxcRZ2njfoaMv+2j7mLDn93MPiNRMvGbL18L9IpF8h9/TN+EYkMffSiOXJ5+hkD+PdqcLpICWHOHc2CC+LEyA/K+cKQMnlQHJX8wqYG3MAJy88Wa4OLDvEqAEOpJd0LxHIMdHBziowSwVlF8D6QaicK01krw/JynwcKoEwZczewroTvZirlKJs5CqQ5CG8pb57FnJUA0LYCXMX5fibd+p8LWDDemcPZbzQyjvH+Ki1TlIciElA7ghwLKV4kRZstt2sANWRjYTAGzuP2hXZFpJ/GsxgGJ0ox1aoFWsDXyyxqCs26+ydmagFN/rRjymJ1898bzGzmQE0HCZpmk5A0RFIv8Pn0WYPsiu6t/Rsj6PauVTwffTSzGAGZhUG2F06hEc9ibS7OPMNp6ErYFlKavo7MkhmTqCxZ/jwzGA9Hx82H2BZSw1NTN9Gx8ycHkajU/7M+jInsDC7DiaEmo1bNl1AMr9ASFgqVu9MCTIzoGUimXVAnnaN0PdBBDCCYbEtMk6wkpQwIG0sn0PQIUF4GsTwLSIFKNqF6DVrQq+IWVrQDxAYQC/1SsYOI4pOxKZrfifiUSbDUisif7XlpGIPufXd/uvdvZm760M0no1FZcnrzUdjw7au3vu/BVgAFLXeuTxhTXVAAAAAElFTkSuQmCC') left top no-repeat;\r\npadding-left : 24px;\r\n}\r\n");
                    content.append("</style>\r\n");
                    content.append("</head><body>");
                    if (!url.equals("/")) {
                        int upidx = url.substring(0, url.length() - 1).lastIndexOf("/");
                        String up = url.substring(0, upidx + 1);
                        content.append("<a class='up' href='" + up + "'>[parent folder]</a><br>\r\n");
                    }
                    for (int a = 0; a < lns.length; ++a) {
                        String[] f = lns[a].split(" ", -1);
                        int last = f.length - 1;
                        if (f[0].charAt(0) == 'd') {
                            content.append("<a class='folder' href='" + f[last] + "/'>[" + f[last] + "]</a><br>\r\n");
                            continue;
                        }
                        content.append("<a class='file' href='" + f[last] + "'>" + f[last] + "</a><br>\r\n");
                    }
                    content.append("</body></html>");
                    int code = 200;
                    String msg = "OK";
                    String headers = "HTTP/1.1 " + code + " " + msg + "\r\nContent-Type: text/html\r\nContent-Length: " + content.length() + "\r\n\r\n";
                    this.pos.write(headers.getBytes());
                    this.pos.write(content.toString().getBytes());
                    this.pos.flush();
                } else {
                    int code = 200;
                    String msg = "OK";
                    String headers = "HTTP/1.0 " + code + " " + msg + "\r\n\r\n";
                    this.disconn = true;
                    this.pos.write(headers.getBytes());
                    ftp.get(url, this.pos);
                    this.pos.flush();
                }
            }
            catch (Exception e) {
                this.replyError(505, "Exception:" + String.valueOf(e));
                this.log(e);
            }
        }

        private void replyError(int code, String msg) throws Exception {
            this.log("Error:" + code);
            String content = "<h1>Error : " + code + " : " + msg + "</h1>";
            String headers = "HTTP/1.1 " + code + " " + msg + "\r\nContent-Length: " + content.length() + "\r\n\r\n";
            this.pos.write(headers.getBytes());
            this.pos.write(content.getBytes());
            this.pos.flush();
        }

        private void sendRequest(String[] ln) throws Exception {
            Object req = "";
            for (int a = 0; a < ln.length; ++a) {
                if (a == 0) {
                    ln[a] = this.removeHost(ln[a]);
                }
                req = (String)req + ln[a];
                req = (String)req + "\r\n";
            }
            req = (String)req + "\r\n";
            this.ios.write(((String)req).getBytes());
            this.ios.flush();
        }

        private void sendPost(String[] ln) throws Exception {
            int length = -1;
            for (int a = 0; a < ln.length; ++a) {
                if (!ln[a].regionMatches(true, 0, "Content-Length: ", 0, 16)) continue;
                length = Integer.valueOf(ln[a].substring(16, ln[a].length()));
            }
            if (length == -1) {
                throw new Exception("unknown post size");
            }
            this.log("sendPost data len=" + length);
            byte[] post = JF.readAll(this.pis, length);
            this.ios.write(post);
            this.ios.flush();
        }

        private void relayReply(String fn) throws Exception {
            int ch;
            this.log("relayReply:" + fn);
            Object line = "";
            Object headers = "";
            int length = -1;
            int contentLength = -1;
            boolean first = true;
            String encoding = "";
            while (true) {
                if ((ch = this.iis.read()) == -1) {
                    throw new Exception("read error");
                }
                if (!((String)(line = (String)line + (char)ch)).endsWith("\r\n")) continue;
                if (((String)line).regionMatches(true, 0, "Content-Length: ", 0, 16)) {
                    contentLength = length = Integer.valueOf(((String)line).substring(16, ((String)line).length() - 2)).intValue();
                }
                if (((String)line).regionMatches(true, 0, "Connection: Close", 0, 17)) {
                    this.disconn = true;
                }
                if (((String)line).regionMatches(true, 0, "Transfer-Encoding:", 0, 18)) {
                    encoding = ((String)line).substring(18).trim().toLowerCase();
                }
                if (first) {
                    if (((String)line).startsWith("HTTP/1.0")) {
                        this.disconn = true;
                    }
                    String[] tmp = ((String)line).split(" ");
                    int code = Integer.valueOf(tmp[1]);
                    this.log("reply=" + code + ":" + (String)line);
                    first = false;
                }
                headers = (String)headers + (String)line;
                if (((String)line).length() == 2) break;
                line = "";
            }
            this.pos.write(((String)headers).getBytes());
            this.pos.flush();
            if (length == 0) {
                this.log("reply:done:content.length=0:headers.length=" + ((String)headers).length());
                return;
            }
            if (length == -1) {
                if (encoding.equals("chunked")) {
                    boolean zero;
                    contentLength = 0;
                    do {
                        Object chunkSize = "";
                        do {
                            if ((ch = this.iis.read()) != -1) continue;
                            throw new Exception("read error");
                        } while (!((String)(chunkSize = (String)chunkSize + (char)ch)).endsWith("\r\n"));
                        contentLength += ((String)chunkSize).length();
                        int idx = ((String)chunkSize).indexOf(";");
                        if (idx == -1) {
                            idx = ((String)chunkSize).length() - 2;
                        }
                        int chunkLength = Integer.valueOf(((String)chunkSize).substring(0, idx), 16);
                        this.pos.write(((String)chunkSize).getBytes());
                        zero = chunkLength == 0;
                        contentLength += (chunkLength += 2);
                        int bufsiz = chunkLength;
                        if (bufsiz > 4096) {
                            bufsiz = 4096;
                        }
                        byte[] buf = new byte[bufsiz];
                        while (chunkLength != 0) {
                            int read = this.iis.read(buf, 0, chunkLength <= 4096 ? chunkLength : bufsiz);
                            if (read == -1) {
                                throw new Exception("read error");
                            }
                            if (read <= 0) continue;
                            chunkLength -= read;
                            this.pos.write(buf, 0, read);
                        }
                        this.pos.flush();
                    } while (!zero);
                } else {
                    int read;
                    contentLength = 0;
                    byte[] buf = new byte[65536];
                    while ((read = this.iis.read(buf, 0, 65536)) != -1) {
                        if (read <= 0) continue;
                        contentLength += read;
                        this.pos.write(buf, 0, read);
                        this.pos.flush();
                    }
                }
            } else {
                int read;
                int off = 0;
                byte[] buf = new byte[length];
                while (length != 0 && (read = this.iis.read(buf, off, length)) != -1) {
                    if (read <= 0) continue;
                    length -= read;
                    off += read;
                }
                this.pos.write(buf);
                this.pos.flush();
            }
            this.log("reply:done:content.length=" + contentLength + ":headers.length=" + ((String)headers).length());
        }

        private void connectCommand(String host, String req) throws Exception {
            int port;
            String[] ln = req.split(" ");
            if (ln.length != 3) {
                this.replyError(505, "Bad CONNECT syntax");
                return;
            }
            int portidx = ln[1].indexOf(58);
            if (portidx != -1 && (port = Integer.valueOf(ln[1].substring(portidx + 1)).intValue()) != 443) {
                this.replyError(505, "CONNECT is for port 443 only");
                return;
            }
            if (this.this$0.filtersecure) {
                this.connect("localhost", this.this$0.getSSLPort(host));
            } else {
                this.connect(host, 443);
            }
            this.pos.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
            this.pos.flush();
            ConnectRelay i2p = new ConnectRelay(this, this.iis, this.pos);
            ConnectRelay p2i = new ConnectRelay(this, this.pis, this.ios);
            i2p.start();
            p2i.start();
            i2p.join();
            p2i.join();
            this.disconn = true;
        }

        private String removeHost(String req) throws Exception {
            String[] p = req.split(" ");
            if (p.length != 3) {
                return req;
            }
            String urlstr = p[1];
            if (!urlstr.startsWith("http:") && !urlstr.startsWith("https:")) {
                return req;
            }
            URL url = new URI(urlstr).toURL();
            return p[0] + " " + url.getFile() + " " + p[2];
        }

        private class ConnectRelay
        extends Thread {
            private InputStream is;
            private OutputStream os;
            private byte[] buf;
            private final int buflen = 4096;

            public ConnectRelay(Session session, InputStream is, OutputStream os) {
                Objects.requireNonNull(session);
                this.buf = new byte[4096];
                this.buflen = 4096;
                this.is = is;
                this.os = os;
            }

            @Override
            public void run() {
                try {
                    int read;
                    while ((read = this.is.read(this.buf, 0, 4096)) != -1) {
                        if (read <= 0) continue;
                        this.os.write(this.buf, 0, read);
                        this.os.flush();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class SecureSite
    extends Thread {
        public String domain;
        public SSLContext sc;
        public SSLServerSocketFactory serverSocketFactory;
        public SSLServerSocket ss;
        public int port;
        public Object lock;
        final /* synthetic */ ProxyServer this$0;

        public SecureSite(ProxyServer this$0, String domain, int port) {
            ProxyServer proxyServer = this$0;
            Objects.requireNonNull(proxyServer);
            this.this$0 = proxyServer;
            this.lock = new Object();
            this.domain = domain;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.this$0.keytool(new String[]{"-genkeypair", "-alias", this.domain, "-keystore", this.domain + ".key", "-storepass", "password", "-keypass", "password", "-keyalg", "RSA", "-dname", "CN=" + this.domain + ", OU=JavaForce, O=JavaForce, C=CA", "-validity", "3650"});
            this.this$0.keytool(new String[]{"-certreq", "-alias", this.domain, "-keystore", this.domain + ".key", "-file", this.domain + ".csr", "-storepass", "password"});
            this.this$0.keytool(new String[]{"-gencert", "-alias", "localhost", "-keystore", "localhost.key", "-storepass", "password", "-keyalg", "RSA", "-infile", this.domain + ".csr", "-outfile", this.domain + ".crt", "-validity", "3650"});
            this.this$0.keytool(new String[]{"-import", "-alias", "root", "-file", "localhost.crt", "-keystore", this.domain + ".key", "-storepass", "password", "-noprompt"});
            this.this$0.keytool(new String[]{"-import", "-alias", this.domain, "-file", this.domain + ".crt", "-keystore", this.domain + ".key", "-storepass", "password"});
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){
                    {
                        Objects.requireNonNull(this$1);
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                this.sc = SSLContext.getInstance("SSL");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(this.this$0.keyPath + "/" + this.domain + ".key"), "password".toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, "password".toCharArray());
                this.sc.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
                this.serverSocketFactory = this.sc.getServerSocketFactory();
                this.ss = (SSLServerSocket)this.serverSocketFactory.createServerSocket(this.port);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                while (!this.ss.isClosed()) {
                    SSLSocket s = (SSLSocket)this.ss.accept();
                    Session sess = new Session(this.this$0, s, true);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                JFLog.log("Closing port:" + this.port);
                this.ss.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private static enum Section {
        None,
        Global,
        BlockDomain,
        URLChange,
        BlockURL;

    }

    private static class URLChange {
        public String url;
        public String newurl;

        private URLChange() {
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = ProxyServer.proxy.busClient;
            JBusClient cfr_ignored_1 = ProxyServer.proxy.busClient;
            ProxyServer.proxy.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(ProxyServer.proxy.config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(ProxyServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            proxy.stop();
            proxy = new ProxyServer();
            proxy.start();
        }
    }
}

