/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Objects;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.POP3;
import javaforce.SMTP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;

public class SMTPRelay {
    private Server server;
    private String pop3_host;
    private int pop3_port;
    private boolean pop3_secure;
    private String pop3_user;
    private String pop3_pass;
    private String smtp_host;
    private int smtp_port;
    private boolean smtp_secure;
    private String smtp_user;
    private String smtp_pass;
    private String smtp_from;
    private ArrayList<String> to_filters = new ArrayList();
    private boolean keepalive = false;
    private long interval = 15L;
    private POP3 pop3;
    private static boolean debug = false;
    public static final String busPack = "net.sf.jfsmtprelay";
    private static final String defaultConfig = "[global]\n#pop3_host=1.2.3.4\n#pop3_port=995\n#pop3_secure=true #(default = false)\n#pop3_user=bob\n#pop3_pass=secret\n#smtp_host=5.6.7.8\n#smtp_port=25\n#smtp_secure=false #(default = false)\n#smtp_user=bob@example.com #optional\n#smtp_pass=secret #optional\n#smtp_from=bob@example.com #override from email address (optional)\n#to_filter=regexp  #regular expression to email must match (multiple supported) (else msg is discarded)\nkeepalive=true #keep pop3 connection alive (default = false)\n#interval=15 #how often to check for messages (minutes) (default=15)\n";
    private static SMTPRelay service;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsmtprelay.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsmtprelay.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33011;
        }
        return 777;
    }

    public void start() {
        this.stop();
        this.server = new Server(this);
        this.server.start();
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        this.server = null;
    }

    private void relay() {
        if (!this.validConfig()) {
            JFLog.log("Please configure!");
            return;
        }
        SMTP smtp = null;
        try {
            POP3.Message[] list;
            if (debug) {
                JFLog.log("Checking messages...");
            }
            if (this.pop3 == null) {
                this.pop3 = new POP3();
                POP3.debug = debug;
                if (debug) {
                    JFLog.log("POP3:connecting...");
                }
                if (this.pop3_secure) {
                    this.pop3.connectSSL(this.pop3_host, this.pop3_port);
                } else {
                    this.pop3.connect(this.pop3_host, this.pop3_port);
                }
                if (debug) {
                    JFLog.log("POP3:auth...");
                }
                if (!this.pop3.auth(this.pop3_user, this.pop3_pass, "APOP")) {
                    throw new Exception("POP3:auth failed!");
                }
            }
            if (debug) {
                JFLog.log("POP3 listing...");
            }
            if ((list = this.pop3.list()) == null || list.length == 0) {
                if (!this.keepalive) {
                    this.pop3.disconnect();
                    this.pop3 = null;
                }
                if (debug) {
                    JFLog.log("No messages found");
                }
                return;
            }
            if (debug || list.length > 0) {
                JFLog.log("Found " + list.length + " messages to relay");
            }
            for (POP3.Message em : list) {
                if (debug) {
                    JFLog.log("Relay message:" + em.idx + ":size=" + em.size);
                }
                byte[] data = this.pop3.get(em.idx);
                if (debug) {
                    JFLog.log("Message size=" + data.length);
                }
                boolean relay = true;
                String msg = new String(data);
                String[] lns = msg.split("\r\n");
                String em_from = null;
                ArrayList<String> em_to = new ArrayList<String>();
                int idx = 0;
                while (!lns[idx].equals("")) {
                    String key;
                    String ln;
                    int sp;
                    if ((sp = (ln = lns[idx++]).indexOf(58)) == -1) continue;
                    switch (key = ln.substring(0, sp).toLowerCase()) {
                        case "from": {
                            em_from = this.getEmail(ln);
                            break;
                        }
                        case "to": {
                            String to = this.getEmail(ln);
                            if (this.to_filters.size() > 0) {
                                boolean matches = false;
                                for (String to_filter : this.to_filters) {
                                    if (!to.toLowerCase().matches(to_filter)) continue;
                                    matches = true;
                                    break;
                                }
                                if (!matches) {
                                    relay = false;
                                }
                            }
                            em_to.add(to);
                        }
                    }
                }
                if (this.smtp_from != null) {
                    em_from = this.smtp_from;
                }
                if (relay) {
                    smtp = new SMTP();
                    SMTP.debug = debug;
                    if (this.smtp_secure) {
                        smtp.connectSSL(this.smtp_host, this.smtp_port);
                    } else {
                        smtp.connect(this.smtp_host, this.smtp_port);
                    }
                    smtp.login();
                    if (this.smtp_user != null && this.smtp_pass != null && !smtp.auth(this.smtp_user, this.smtp_pass, "LOGIN")) {
                        smtp.disconnect();
                        throw new Exception("SMTP auth failed!");
                    }
                    smtp.from(em_from);
                    for (String to : em_to) {
                        smtp.to(to);
                    }
                    smtp.data(msg);
                    smtp.disconnect();
                    smtp = null;
                }
                this.pop3.delete(em.idx);
            }
            if (!this.keepalive) {
                this.pop3.disconnect();
                this.pop3 = null;
            }
        }
        catch (Exception e) {
            if (this.pop3 != null) {
                try {
                    this.pop3.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pop3 = null;
            }
            if (smtp != null) {
                try {
                    smtp.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                smtp = null;
            }
            JFLog.log(e);
        }
    }

    private String getEmail(String ln) {
        int i1 = ln.indexOf(60);
        int i2 = ln.indexOf(62);
        if (i1 == -1 || i2 == -1) {
            return ln;
        }
        return ln.substring(i1 + 1, i2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        Section section = Section.None;
        try {
            BufferedReader br = new BufferedReader(new FileReader(SMTPRelay.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            block42: while (true) {
                int idx;
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                if ((ln = ln.trim()).startsWith("#") || ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if ((idx = ln.indexOf("=")) == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                switch (section.ordinal()) {
                    case 0: 
                    case 1: {
                        switch (key) {
                            case "pop3_host": {
                                this.pop3_host = value;
                                break;
                            }
                            case "pop3_port": {
                                this.pop3_port = Integer.valueOf(value);
                                break;
                            }
                            case "pop3_secure": {
                                this.pop3_secure = value.equals("true");
                                break;
                            }
                            case "pop3_user": {
                                this.pop3_user = value;
                                break;
                            }
                            case "pop3_pass": {
                                this.pop3_pass = value;
                                break;
                            }
                            case "smtp_host": {
                                this.smtp_host = value;
                                break;
                            }
                            case "smtp_port": {
                                this.smtp_port = Integer.valueOf(value);
                                break;
                            }
                            case "smtp_secure": {
                                this.smtp_secure = value.equals("true");
                                break;
                            }
                            case "smtp_user": {
                                this.smtp_user = value;
                                break;
                            }
                            case "smtp_pass": {
                                this.smtp_pass = value;
                                break;
                            }
                            case "smtp_from": {
                                this.smtp_from = value;
                                break;
                            }
                            case "to_filter": {
                                this.to_filters.add(value.toLowerCase());
                                break;
                            }
                            case "keepalive": {
                                this.keepalive = value.equals("true");
                                break;
                            }
                            case "interval": {
                                this.interval = Integer.valueOf(value).intValue();
                                if (this.interval < 1L) {
                                    this.interval = 1L;
                                }
                                if (this.interval <= 1440L) break;
                                this.interval = 1440L;
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                            }
                        }
                        continue block42;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPRelay.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public boolean validConfig() {
        if (this.pop3_host == null) {
            return false;
        }
        if (this.pop3_user == null) {
            return false;
        }
        if (this.pop3_pass == null) {
            return false;
        }
        return this.smtp_host != null;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SMTPRelay.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        service = new SMTPRelay();
        service.start();
    }

    public static void serviceStop() {
        JFLog.log("SMTPRelay : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        service.stop();
    }

    private class Server
    extends Thread {
        public boolean active;
        final /* synthetic */ SMTPRelay this$0;

        private Server(SMTPRelay sMTPRelay) {
            SMTPRelay sMTPRelay2 = sMTPRelay;
            Objects.requireNonNull(sMTPRelay2);
            this.this$0 = sMTPRelay2;
        }

        @Override
        public void run() {
            JFLog.append(JF.getLogPath() + "/jfsmtprelay.log", true);
            JFLog.setRetention(30);
            JFLog.log("SMTPRelay : Starting service");
            try {
                this.this$0.loadConfig();
                this.this$0.busClient = new JBusClient(SMTPRelay.busPack, new JBusMethods());
                this.this$0.busClient.setPort(SMTPRelay.getBusPort());
                this.this$0.busClient.start();
                this.active = true;
                while (this.active) {
                    this.this$0.relay();
                    int a = 0;
                    while ((long)a < this.this$0.interval * 60L && this.active) {
                        JF.sleep(1000);
                        ++a;
                    }
                }
                if (this.this$0.pop3 != null) {
                    this.this$0.pop3.disconnect();
                    this.this$0.pop3 = null;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    static enum Section {
        None,
        Global;

    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SMTPRelay.service.busClient;
            JBusClient cfr_ignored_1 = SMTPRelay.service.busClient;
            SMTPRelay.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SMTPRelay.service.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPRelay.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            service.stop();
            service = new SMTPRelay();
            service.start();
        }
    }
}

