/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.SSHServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SSHApp
extends JFrame {
    private JTextArea config;
    private JButton help;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    public ViewLog viewer;
    public JBusClient busClient;

    public SSHApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/ssh.png"));
        this.setIconImage(img.getImage());
        new Thread(this){
            final /* synthetic */ SSHApp this$0;
            {
                SSHApp sSHApp = this$0;
                Objects.requireNonNull(sSHApp);
                this.this$0 = sSHApp;
            }

            @Override
            public void run() {
                Random r = new Random();
                this.this$0.busClient = new JBusClient("net.sf.jfssh.client" + r.nextInt(), new JBusMethods(this.this$0));
                this.this$0.busClient.setPort(SSHServer.getBusPort());
                this.this$0.busClient.start();
                this.this$0.busClient.call("net.sf.jfssh", "getConfig", "\"" + this.this$0.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfssh", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfssh", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.help = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SSH Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(this){
            final /* synthetic */ SSHApp this$0;
            {
                SSHApp sSHApp = this$0;
                Objects.requireNonNull(sSHApp);
                this.this$0 = sSHApp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("SSH Configuration:");
        this.jButton1.setText("View Log");
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ SSHApp this$0;
            {
                SSHApp sSHApp = this$0;
                Objects.requireNonNull(sSHApp);
                this.this$0 = sSHApp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(this){
            final /* synthetic */ SSHApp this$0;
            {
                SSHApp sSHApp = this$0;
                Objects.requireNonNull(sSHApp);
                this.this$0 = sSHApp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.helpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.jButton1).addComponent(this.help)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void helpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SSHApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(new File(SSHServer.getLogFile()));
            this.viewer.setTitle("SSH Log");
        }
        this.viewer.setVisible(true);
    }

    private void showHelp() {
        JFAWT.openURL("http://jfssh.sf.net/help.html");
    }

    public class JBusMethods {
        final /* synthetic */ SSHApp this$0;

        public JBusMethods(SSHApp this$0) {
            SSHApp sSHApp = this$0;
            Objects.requireNonNull(sSHApp);
            this.this$0 = sSHApp;
        }

        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    JBusMethods jBusMethods = this$1;
                    Objects.requireNonNull(jBusMethods);
                    this.this$1 = jBusMethods;
                }

                @Override
                public void run() {
                    this.this$1.this$0.config.setText(JBusClient.decodeString(_cfg));
                    this.this$1.this$0.config.setEnabled(true);
                    this.this$1.this$0.save.setEnabled(true);
                }
            });
        }
    }
}

