/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests;

import java.util.Random;
import javaforce.Console;
import javaforce.JFLog;
import javaforce.cl.Compute;

public class TestCL {
    public static void main(String[] args) {
        int SIZE;
        System.out.println("TestCL");
        Random rand = new Random();
        Compute compute = null;
        try {
            compute = new Compute();
            if (!compute.init(4)) {
                JFLog.log("Compute init failed");
                System.exit(1);
            }
            System.out.println("Starting tests...");
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
        try {
            SIZE = 16;
            float[] a = new float[SIZE];
            for (int i = 0; i < SIZE; ++i) {
                a[i] = rand.nextFloat();
            }
            float[] b = new float[SIZE];
            compute.array_square(a, b);
            int correct = 0;
            for (int i = 0; i < SIZE; ++i) {
                float res = a[i] * a[i];
                if (b[i] == res) {
                    ++correct;
                    continue;
                }
                JFLog.log("error:b[]=" + b[i] + ",expected=" + res);
            }
            System.out.println("array_square:" + correct + " of " + SIZE + " are correct");
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
        try {
            boolean identity = true;
            SIZE = 3;
            int SIZE_SIZE = SIZE * SIZE;
            float[] a = new float[SIZE_SIZE];
            float[] b = new float[SIZE_SIZE];
            float[] c = new float[SIZE_SIZE];
            int idx = 0;
            for (int row = 0; row < SIZE; ++row) {
                for (int col = 0; col < SIZE; ++col) {
                    a[idx] = rand.nextFloat();
                    b[idx] = identity ? (float)(row == col ? 1 : 0) : rand.nextFloat();
                    ++idx;
                }
            }
            compute.matrix_mult(SIZE, SIZE, SIZE, a, b, c);
            int correct = 0;
            for (int row = 0; row < SIZE; ++row) {
                for (int col = 0; col < SIZE; ++col) {
                    int i = col * SIZE + row;
                    float res = 0.0f;
                    for (int k = 0; k < SIZE; ++k) {
                        res += a[k * SIZE + row] * b[col * SIZE + k];
                    }
                    if (c[i] == res) {
                        ++correct;
                        continue;
                    }
                    JFLog.log("error:c[] = " + c[i] + ":expected=" + res);
                }
            }
            Console.printArray(a);
            Console.printArray(b);
            Console.printArray(c);
            System.out.println("matrix_mult:" + correct + " of " + SIZE_SIZE + " are correct");
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }
}

