/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests;

import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.gl.FragmentShader;
import javaforce.gl.GL;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.Render;
import javaforce.gl.Scene;
import javaforce.gl.UVMap;
import javaforce.gl.Vector3;
import javaforce.gl.VertexShader;
import javaforce.ui.Window;
import javaforce.ui.WindowEvents;

public class TestGL
implements WindowEvents {
    public static Window gl;
    public static GLCode code;

    public static void main(String[] args) {
        Window.init();
        gl = new Window();
        gl.create(7, "Test", 512, 512, null);
        gl.show();
        gl.setWindowListener(new TestGL());
        GL.getInstance();
        code = new GLCode(true);
        code.init();
        while (true) {
            code.render();
            gl.pollEvents();
        }
    }

    public static void swap() {
        gl.swap();
    }

    @Override
    public void windowResize(int x, int y) {
        code.resize(x, y);
    }

    @Override
    public void windowClosing() {
        System.exit(0);
    }

    public static class GLCode {
        Timer glTimer;
        Timer fpsTimer;
        final Object fpsLock = new Object();
        int fpsCounter;
        final int FPS = 65;
        Scene scene = new Scene();
        Render render = new Render();
        Model mod;
        Object3 box;
        boolean[] keys = new boolean[1024];
        final float speedMove = 2.0f;
        final float speedRotate = 5.0f;
        float alpha = 0.5f;
        float alphadir = -0.01f;
        boolean doSwap = false;
        Vector3 viewpoint = new Vector3();
        Vector3 uppoint = new Vector3();
        Vector3 leftpoint = new Vector3();
        Vector3 boxCenter = new Vector3();

        public GLCode(boolean doSwap) {
            this.doSwap = doSwap;
        }

        public void init() {
            this.scene.texturePath = "./";
            System.out.println("GL Version=" + GL.getInstance().glGetString(7938));
            int[] glver = GL.getVersion();
            if (glver[0] < 2) {
                JFAWT.showError("Error", "OpenGL Version < 2.0 : Detected : " + glver[0] + "." + glver[1]);
                System.exit(0);
            }
            this.createWorld();
            this.glTimer = new Timer();
            int delay = 15;
            this.glTimer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ GLCode this$0;
                {
                    GLCode gLCode = this$0;
                    Objects.requireNonNull(gLCode);
                    this.this$0 = gLCode;
                }

                @Override
                public void run() {
                    this.this$0.frame();
                }
            }, delay, (long)delay);
            this.fpsTimer = new Timer();
            this.fpsTimer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ GLCode this$0;
                {
                    GLCode gLCode = this$0;
                    Objects.requireNonNull(gLCode);
                    this.this$0 = gLCode;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int cnt;
                    Object object = this.this$0.fpsLock;
                    synchronized (object) {
                        cnt = this.this$0.fpsCounter;
                        this.this$0.fpsCounter = 0;
                    }
                    JFLog.log("fps=" + cnt);
                }
            }, 1000L, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            Object object = this.fpsLock;
            synchronized (object) {
                ++this.fpsCounter;
            }
            this.processMovement();
            this.render.render();
            if (this.doSwap) {
                TestGL.swap();
            }
        }

        public void resize(int width, int height) {
            this.render.resize(width, height);
        }

        public void frame() {
            this.box.m.addRotate(3.0f, 1.0f, 0.0f, 0.0f);
            this.box.m.addRotate(2.0f, 0.0f, 1.0f, 0.0f);
            this.box.m.addRotate(1.0f, 0.0f, 0.0f, 1.0f);
        }

        public void createWorld() {
            int width = 512;
            int height = 512;
            System.out.println("size=" + width + "," + height);
            this.scene.init(VertexShader.source, FragmentShader.source);
            this.render.init(this.scene, width, height);
            this.resetPosition();
            float x = -0.5f;
            float y = -0.5f;
            float z = -0.5f;
            this.box = new Object3();
            UVMap map = this.box.createUVMap();
            map.textureIndex = 0;
            this.mod = new Model();
            this.mod.addObject(this.box);
            this.mod.addTexture("javaforce.png");
            this.scene.addModel(this.mod);
            this.makeWall(x, y, z, 1, this.box);
            this.makeWall(x, y, z, 2, this.box);
            this.makeWall(x, y, z, 3, this.box);
            this.makeWall(x, y, z, 4, this.box);
            this.makeWall(x, y, z, 5, this.box);
            this.makeWall(x, y, z, 6, this.box);
            if (!this.scene.loadTextures()) {
                JFLog.log("Failed to load all textures");
                System.exit(0);
            }
            this.box.copyBuffers();
        }

        public Object3 makeWall(float x, float y, float z, int side, Object3 obj) {
            float[] vp = new float[]{x * 10.0f, y * 10.0f, z * 10.0f, (x + 1.0f) * 10.0f, y * 10.0f, z * 10.0f, x * 10.0f, (y + 1.0f) * 10.0f, z * 10.0f, (x + 1.0f) * 10.0f, (y + 1.0f) * 10.0f, z * 10.0f, x * 10.0f, y * 10.0f, (z + 1.0f) * 10.0f, (x + 1.0f) * 10.0f, y * 10.0f, (z + 1.0f) * 10.0f, x * 10.0f, (y + 1.0f) * 10.0f, (z + 1.0f) * 10.0f, (x + 1.0f) * 10.0f, (y + 1.0f) * 10.0f, (z + 1.0f) * 10.0f};
            int off = obj.vpl.size() / 3;
            int[] pts = null;
            float[] uv = new float[16];
            switch (side) {
                case 1: {
                    pts = new int[]{2, 6, 7, 3};
                    break;
                }
                case 2: {
                    pts = new int[]{5, 4, 0, 1};
                    break;
                }
                case 3: {
                    pts = new int[]{2, 0, 4, 6};
                    break;
                }
                case 4: {
                    pts = new int[]{7, 5, 1, 3};
                    break;
                }
                case 5: {
                    pts = new int[]{6, 4, 5, 7};
                    break;
                }
                case 6: {
                    pts = new int[]{3, 1, 0, 2};
                }
            }
            float u = 0.0f;
            float v = 0.0f;
            for (int a = 0; a < 4; ++a) {
                uv[pts[a] * 2 + false] = u;
                uv[pts[a] * 2 + 1] = v;
                if (u == 0.0f && v == 0.0f) {
                    v = 1.0f;
                    continue;
                }
                if (u == 0.0f && v == 1.0f) {
                    u = 1.0f;
                    continue;
                }
                if (u != 1.0f || v != 1.0f) continue;
                v = 0.0f;
            }
            obj.addVertex(vp, uv);
            obj.addPoly(new int[]{off + pts[0], off + pts[1], off + pts[2]});
            obj.addPoly(new int[]{off + pts[0], off + pts[2], off + pts[3]});
            return obj;
        }

        public void processMovement() {
            this.viewpoint.set(0.0f, 0.0f, -1.0f);
            this.render.m_camera.mult(this.viewpoint);
            this.uppoint.set(0.0f, 1.0f, 0.0f);
            this.render.m_camera.mult(this.uppoint);
            this.leftpoint.set(-1.0f, 0.0f, 0.0f);
            this.render.m_camera.mult(this.leftpoint);
            if (this.keys[263]) {
                this.rotateLR(-1.0f);
            }
            if (this.keys[262]) {
                this.rotateLR(1.0f);
            }
            if (this.keys[265]) {
                this.rotateUD(1.0f);
            }
            if (this.keys[264]) {
                this.rotateUD(-1.0f);
            }
            if (this.keys[90]) {
                this.spin(1.0f);
            }
            if (this.keys[88]) {
                this.spin(-1.0f);
            }
            if (this.keys[81]) {
                this.resetPosition();
            }
            if (this.keys[290]) {
                this.render.cameraRotate(10.0f, 1.0f, 0.0f, 0.0f);
            }
            if (this.keys[291]) {
                this.render.cameraRotate(10.0f, 0.0f, 1.0f, 0.0f);
            }
            if (this.keys[292]) {
                this.render.cameraRotate(10.0f, 0.0f, 0.0f, 1.0f);
            }
            if (this.keys[294]) {
                this.render.cameraRotate(-10.0f, 1.0f, 0.0f, 0.0f);
            }
            if (this.keys[295]) {
                this.render.cameraRotate(-10.0f, 0.0f, 1.0f, 0.0f);
            }
            if (this.keys[296]) {
                this.render.cameraRotate(-10.0f, 0.0f, 0.0f, 1.0f);
            }
            if (this.keys[57]) {
                this.render.fovy -= 10.0f;
                System.out.println("fovy = " + this.render.fovy);
            }
            if (this.keys[48]) {
                this.render.fovy += 10.0f;
                System.out.println("fovy = " + this.render.fovy);
            }
            if (this.keys[83]) {
                this.move(1.0f);
            }
            if (this.keys[87]) {
                this.move(-1.0f);
            }
            if (this.keys[68]) {
                this.stride(1.0f);
            }
            if (this.keys[65]) {
                this.stride(-1.0f);
            }
            this.alpha += this.alphadir;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
                this.alphadir *= -1.0f;
            } else if (this.alpha > 0.5f) {
                this.alpha = 0.5f;
                this.alphadir *= -1.0f;
            }
            this.box.color[3] = this.alpha;
        }

        public void rotateLR(float dir) {
            this.render.cameraRotate(5.0f * this.uppoint.v[0], dir, 0.0f, 0.0f);
            this.render.cameraRotate(5.0f * this.uppoint.v[1], 0.0f, dir, 0.0f);
            this.render.cameraRotate(5.0f * this.uppoint.v[2], 0.0f, 0.0f, dir);
        }

        public void rotateUD(float dir) {
            this.render.cameraRotate(5.0f * this.leftpoint.v[0], dir, 0.0f, 0.0f);
            this.render.cameraRotate(5.0f * this.leftpoint.v[1], 0.0f, dir, 0.0f);
            this.render.cameraRotate(5.0f * this.leftpoint.v[2], 0.0f, 0.0f, dir);
        }

        public void spin(float dir) {
            this.render.cameraRotate(5.0f * this.viewpoint.v[0], dir, 0.0f, 0.0f);
            this.render.cameraRotate(5.0f * this.viewpoint.v[1], 0.0f, dir, 0.0f);
            this.render.cameraRotate(5.0f * this.viewpoint.v[2], 0.0f, 0.0f, dir);
        }

        public void move(float dir) {
            this.render.modelTranslate(this.viewpoint.v[0] * 2.0f * dir, this.viewpoint.v[1] * 2.0f * dir, this.viewpoint.v[2] * 2.0f * dir);
        }

        public void stride(float dir) {
            this.render.modelTranslate(this.leftpoint.v[0] * 2.0f * dir, this.leftpoint.v[1] * 2.0f * dir, this.leftpoint.v[2] * 2.0f * dir);
        }

        public void resetPosition() {
            this.render.cameraReset();
            this.render.modelReset();
            this.render.modelTranslate(0.0f, 0.0f, -20.0f);
        }
    }
}

