/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests;

import javaforce.controls.ni.DAQmx;

public class TestNI {
    public static void main(String[] args) {
        int a;
        int read;
        long task;
        double[] f = new double[20];
        int[] i = new int[20];
        int[] b = new int[160];
        DAQmx ni = DAQmx.getInstance();
        if (ni == null) {
            System.out.println("DAQmx not loaded");
            return;
        }
        try {
            task = ni.createTask();
            if (task == 0L) {
                throw new Exception("createTask failed");
            }
            if (!ni.createChannelAnalog(task, "cDAQ9188-189E9F4Mod7/ai0", 20.0, 20L, -10.0, 10.0)) {
                throw new Exception("createChannel failed");
            }
            if (!ni.startTask(task)) {
                throw new Exception("startTask failed");
            }
            read = ni.readTaskAnalog(task, 1, f);
            if (read == 0) {
                throw new Exception("no data");
            }
            System.out.println("read=" + read);
            for (a = 0; a < read; ++a) {
                System.out.println("A[" + a + "]=" + f[a]);
            }
            if (!ni.stopTask(task)) {
                throw new Exception("stopTask failed");
            }
            if (!ni.clearTask(task)) {
                throw new Exception("clearTask failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ni.niPrintError();
            System.exit(0);
        }
        try {
            task = ni.createTask();
            if (task == 0L) {
                throw new Exception("createTask failed");
            }
            if (!ni.createChannelDigital(task, "cDAQ9188-189E9F4Mod8/port0/line0:7", 20.0, 20L)) {
                throw new Exception("createChannel failed");
            }
            if (!ni.startTask(task)) {
                throw new Exception("startTask failed");
            }
            read = ni.readTaskDigital(task, 8, b);
            if (read == 0) {
                throw new Exception("no data");
            }
            System.out.println("read=" + read);
            read *= 8;
            for (a = 0; a < read; ++a) {
                System.out.println("D[" + a + "]=" + b[a]);
            }
            if (!ni.stopTask(task)) {
                throw new Exception("stopTask failed");
            }
            if (!ni.clearTask(task)) {
                throw new Exception("clearTask failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ni.niPrintError();
            System.exit(0);
        }
        try {
            long task2 = ni.createTask();
            if (task2 == 0L) {
                throw new Exception("createTask failed");
            }
            if (!ni.createChannelCounter(task2, "cDAQ9188-189E9F4Mod1/ctr0", 2.0E7, 20L, 1.0, 1000.0, "/cDAQ9188-189E9F4Mod1/pfi0", 0.05, 1)) {
                throw new Exception("createChannel failed");
            }
            if (!ni.startTask(task2)) {
                throw new Exception("startTask failed");
            }
            read = ni.readTaskCounter(task2, 1, f);
            if (read == 0) {
                throw new Exception("no data");
            }
            for (a = 0; a < read; ++a) {
                System.out.println("C[" + a + "]=" + f[a]);
            }
            if (!ni.stopTask(task2)) {
                throw new Exception("stopTask failed");
            }
            if (!ni.clearTask(task2)) {
                throw new Exception("clearTask failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ni.niPrintError();
            System.exit(0);
        }
    }
}

