/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.util.Objects;
import javaforce.ui.ActionListener;
import javaforce.ui.Button;
import javaforce.ui.ChangeListener;
import javaforce.ui.Color;
import javaforce.ui.Component;
import javaforce.ui.Container;
import javaforce.ui.Dimension;
import javaforce.ui.Icons;
import javaforce.ui.LayoutMetrics;
import javaforce.ui.ListBox;
import javaforce.ui.ScrollBox;
import javaforce.ui.TextField;

public class ComboBox
extends Container {
    private TextField text;
    private Button button;
    private ListBox list;
    private ScrollBox scroll;
    private ChangeListener change;
    private int rows = 3;

    public ComboBox(String txt) {
        this.text = new TextField(txt);
        super.add(this.text);
        this.button = new Button(Icons.getArrowDown());
        this.button.setFocusable(false);
        super.add(this.button);
        this.list = new ListBox();
        this.list.setLayer(1);
        this.scroll = new ScrollBox(this.list, 2);
        this.scroll.setLayer(1);
        this.scroll.setVisible(false);
        super.add(this.scroll);
        this.button.setActionListner(new ActionListener(this){
            final /* synthetic */ ComboBox this$0;
            {
                ComboBox comboBox = this$0;
                Objects.requireNonNull(comboBox);
                this.this$0 = comboBox;
            }

            @Override
            public void actionPerformed(Component cmp) {
                this.this$0.list.setSelectedIndex(-1);
                this.this$0.scroll.setVisible(!this.this$0.scroll.isVisible());
                this.this$0.scroll.resetOffset();
            }
        });
        this.list.setChangeListener(new ChangeListener(this){
            final /* synthetic */ ComboBox this$0;
            {
                ComboBox comboBox = this$0;
                Objects.requireNonNull(comboBox);
                this.this$0 = comboBox;
            }

            @Override
            public void changed(Component cmp) {
                String txt = this.this$0.list.getSelectedItem();
                if (txt != null) {
                    this.this$0.text.setText(txt);
                    this.this$0.text.setCursorPosition(0, 0);
                    if (this.this$0.change != null) {
                        this.this$0.change.changed(this.this$0);
                    }
                }
                this.this$0.scroll.setVisible(false);
            }
        });
    }

    @Override
    public Dimension getMinSize() {
        return new Dimension(this.getWidth(), this.text.getMinHeight());
    }

    @Override
    public void layout(LayoutMetrics metrics) {
        int org_width = metrics.size.width;
        int org_height = metrics.size.height;
        int org_x = metrics.pos.x;
        int org_y = metrics.pos.y;
        this.setPosition(metrics.pos);
        metrics.size.height = this.getHeight() + this.rows * this.list.getItemHeight();
        this.setSize(metrics.size);
        metrics.size.height = this.getMinHeight();
        metrics.size.width -= 16;
        this.text.layout(metrics);
        metrics.pos.x += metrics.size.width;
        metrics.size.width = 16;
        this.button.layout(metrics);
        metrics.pos.x = org_x;
        metrics.pos.y += metrics.size.height;
        metrics.size.width = org_width;
        metrics.size.height = this.rows * this.list.getItemHeight();
        this.scroll.layout(metrics);
        metrics.pos.y = org_y;
        metrics.size.height = org_height;
    }

    @Override
    public void add(Component child) {
    }

    public void addItem(String item) {
        this.list.addItem(item);
    }

    public void removeItem(String item) {
        this.list.removeItem(item);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String txt) {
        this.text.setText(txt);
    }

    @Override
    public boolean isEditable() {
        return this.text.isEditable();
    }

    @Override
    public void setEditable(boolean state) {
        this.text.setEditable(state);
    }

    public void setItemsVisible(int items) {
        this.rows = items;
    }

    @Override
    public void setForeColor(Color clr) {
        super.setForeColor(clr);
        if (this.text == null) {
            return;
        }
        this.text.setForeColor(clr);
        this.list.setForeColor(clr);
        this.button.setForeColor(clr);
    }

    @Override
    public void setBackColor(Color clr) {
        super.setBackColor(clr);
        if (this.text == null) {
            return;
        }
        this.text.setBackColor(clr);
        this.list.setBackColor(clr);
        this.button.setBackColor(clr);
    }

    public void setChangeListener(ChangeListener listener) {
        this.change = listener;
    }

    public String toString() {
        return "ComboBox:" + this.getText();
    }
}

