/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.ASCII8;
import javaforce.JFLog;
import javaforce.api.UIAPI;
import javaforce.gl.Texture;
import javaforce.ui.FontMetrics;
import javaforce.ui.Image;
import javaforce.ui.Window;

public class Font {
    public static boolean debug = false;
    private static final int SystemFontSize = 20;
    private int width;
    private int height;
    private int[] fontinfo;
    private int[] coords;
    private int[] glyphinfo;
    private byte[] px;
    private int[] codes;
    private int avg_ascent;
    private int avg_descent;
    private int linegap;
    private int max_ascent;
    private int max_descent;
    private int max_advance;
    private int size = 512;
    private Timer blinkTimer;
    private boolean blink;
    private Texture tex;
    private static Font systemFont;

    public boolean load(byte[] font, int ptSize) {
        boolean loaded;
        this.fontinfo = new int[5];
        this.coords = new int[1024];
        this.glyphinfo = new int[512];
        this.codes = new int[256];
        for (int a = 0; a < 256; ++a) {
            this.codes[a] = ASCII8.convert(a);
        }
        this.width = this.size;
        this.height = this.size;
        this.px = new byte[this.width * this.height];
        boolean bl = loaded = UIAPI.getInstance().uiLoadFont(font, ptSize, this.fontinfo, this.coords, this.glyphinfo, this.codes, this.px, this.width, this.height) == 256;
        if (loaded) {
            this.avg_ascent = this.fontinfo[0];
            this.avg_descent = this.fontinfo[1];
            this.linegap = this.fontinfo[2];
            this.max_ascent = this.fontinfo[3];
            this.max_descent = this.fontinfo[4];
        }
        for (int a = 0; a < 256; ++a) {
            int adv = this.getAdvance(ASCII8.convert(a));
            if (debug) {
                JFLog.log("adv:" + a + "=" + adv);
            }
            if (adv <= this.max_advance) continue;
            this.max_advance = adv;
        }
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer();
            this.blinkTimer.schedule(new TimerTask(this){
                final /* synthetic */ Font this$0;
                {
                    Font font = this$0;
                    Objects.requireNonNull(font);
                    this.this$0 = font;
                }

                @Override
                public void run() {
                    this.this$0.blink = !this.this$0.blink;
                    Window.redrawAll();
                }
            }, 500L, 500L);
        }
        return loaded;
    }

    public boolean load(String name, int ptSize) {
        try {
            FileInputStream fis = new FileInputStream(name);
            byte[] data = fis.readAllBytes();
            fis.close();
            return this.load(data, ptSize);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public Texture getTexture() {
        if (this.tex == null) {
            Image img = new Image(this.size, this.size);
            int pos = 0;
            int rgb = 0xFFFFFF;
            int[] buffer = img.getBuffer();
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    byte a = this.px[pos];
                    buffer[pos] = (a << 24) + rgb;
                    ++pos;
                }
            }
            if (debug) {
                for (int cp = 0; cp < 256; ++cp) {
                    int y2;
                    int x2;
                    int y1;
                    int x1 = this.coords[cp * 4 + 0];
                    if (x1 < 0 || (y1 = this.coords[cp * 4 + 1]) < 0 || (x2 = this.coords[cp * 4 + 2]) < 0 || (y2 = this.coords[cp * 4 + 3]) < 0) continue;
                    img.putPixel(x1, y1, 0xFF0000);
                    img.putPixel(x1, y2, 0x770000);
                    img.putPixel(x2, y1, 255);
                    img.putPixel(x2, y2, 119);
                    int baseline = this.glyphinfo[cp * 2 + 0];
                    int advance = this.glyphinfo[cp * 2 + 1];
                    if (y1 + baseline < 0 || y1 + baseline >= this.size) continue;
                    img.putPixel(x1, y1 - baseline, 65280);
                    img.putPixel(x2, y1 - baseline, 65280);
                }
                img.savePNG("font.png");
            }
            this.tex = new Texture(0);
            this.tex.setImage(img);
            this.tex.load();
        }
        return this.tex;
    }

    public Image getImage() {
        return this.getTexture().getImage();
    }

    public void bind() {
        this.getTexture().bind();
    }

    public static Font getSystemFont() {
        if (systemFont == null) {
            systemFont = new Font();
            try {
                InputStream is = systemFont.getClass().getResourceAsStream("/javaforce/ui/system.ttf");
                if (is == null) {
                    throw new Exception("Resource not found:/javaforce/ui/system.ttf");
                }
                systemFont.load(is.readAllBytes(), 20);
                is.close();
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        return systemFont;
    }

    public int getMaxAscent() {
        return this.max_ascent;
    }

    public int getMaxDescent() {
        return this.max_descent;
    }

    public int getMaxAdvance() {
        return this.max_advance;
    }

    public int getMaxHeight() {
        return -this.max_ascent + this.max_descent;
    }

    public int getLineGap() {
        return this.linegap;
    }

    public int getAdvance(char ch) {
        char cp = ASCII8.convertUTF16(ch);
        if (cp >= '\u0100') {
            return 0;
        }
        return this.glyphinfo[cp * 2 + 1];
    }

    public int getAscent(char ch) {
        char cp = ASCII8.convertUTF16(ch);
        if (cp >= '\u0100') {
            return 0;
        }
        return this.glyphinfo[cp * 2 + 0];
    }

    public boolean showCursor() {
        return this.blink;
    }

    public void drawChar(int x, int y, char ch, Image image, int clr) {
        char cp = ASCII8.convert(ch);
        if (cp >= '\u0100') {
            return;
        }
        int ascent = this.getAscent(ch);
        y += ascent;
        int x1 = this.coords[cp * 4 + 0];
        int y1 = this.coords[cp * 4 + 1];
        int x2 = this.coords[cp * 4 + 2];
        int y2 = this.coords[cp * 4 + 3];
        int w = x2 - x1 + 1;
        int h = y2 - y1 + 1;
        if (debug) {
            JFLog.log("drawChar:" + x + "," + y + ":" + ch + "@" + x1 + "," + y1 + ":" + x2 + "," + y2 + ":" + ascent);
        }
        Image fontImage = this.getImage();
        int fontWidth = fontImage.getWidth();
        image.putPixelsStencil(fontImage.getBuffer(), x, y, w, h, y1 * fontWidth + x1, fontWidth, true, clr);
    }

    public void drawText(int x, int y, String txt, Image image, int clr) {
        char[] ca;
        for (char ch : ca = txt.toCharArray()) {
            this.drawChar(x, y, ch, image, clr);
            x += this.getAdvance(ch);
        }
    }

    public FontMetrics getMetrics(String txt) {
        FontMetrics m = new FontMetrics();
        char[] ca = txt.toCharArray();
        m.ascent = this.max_ascent;
        m.descent = this.max_descent;
        for (int pos = 0; pos < ca.length; ++pos) {
            int code;
            char ch = ca[pos];
            boolean found = false;
            for (code = 0; code < this.codes.length; ++code) {
                if (this.codes[code] != ch) continue;
                m.advance += this.glyphinfo[code * 2 + 1];
                found = true;
                break;
            }
            if (found) continue;
            ch = '\u0000';
            code = 0;
            m.advance += this.glyphinfo[code * 2 + 1];
        }
        return m;
    }
}

