/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.gl.FragmentShader;
import javaforce.gl.GL;
import javaforce.gl.Matrix;
import javaforce.gl.Scene;
import javaforce.gl.VertexShader;
import javaforce.ui.Canvas;
import javaforce.ui.Window;

public class UIRender {
    private Scene scene;
    public Matrix m_ortho;
    public Matrix m_view;
    public Matrix m_model;
    public float s = 1.0f;

    public void setContext() {
        GL gl = GL.getInstance();
        gl.glUseProgram(this.scene.program);
        gl.glUniformMatrix4fv(this.scene.mpu, 1, 0, this.m_ortho.m);
        gl.glUniformMatrix4fv(this.scene.mvu, 1, 0, this.m_view.m);
        gl.glUniformMatrix4fv(this.scene.mmu, 1, 0, this.m_model.m);
    }

    public void run() {
        this.run(-1);
    }

    public void run(int wait) {
        GL gl = GL.getInstance();
        this.scene = new Scene();
        this.m_ortho = new Matrix();
        this.m_ortho.ortho(0.0f, 1.0f, 0.0f, 1.0f, 0.1f, 10.0f);
        this.m_view = new Matrix();
        this.m_model = new Matrix();
        this.scene.init(VertexShader.source, FragmentShader.source);
        while (true) {
            this.setContext();
            Window[] windowList = Window.getWindows();
            if (windowList.length == 0) break;
            for (Window window : windowList) {
                Canvas[] canvasList;
                try {
                    window.render(this.scene);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (Canvas c : canvasList = window.getCanvasList()) {
                    gl.glViewport(c.pos.x, c.pos.y, c.size.width, c.size.height);
                    try {
                        c.render();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.setContext();
                }
            }
            Window.pollEvents(wait);
        }
    }
}

