/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.awt.JFAWT;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class FileDialog
extends JFrame {
    private JButton cancel;
    private JProgressBar progress;
    private JLabel txt1;
    private JLabel txt2;
    private String[] cmd;
    private Worker worker;
    private Timer timer;
    private boolean done;
    private String msg1;
    private String msg2;
    private boolean hidetxt2;
    private long amtComplete;
    private long amtTodo;

    public FileDialog() {
        this.initComponents();
        JFAWT.centerWindow(this);
    }

    private void initComponents() {
        this.txt1 = new JLabel();
        this.progress = new JProgressBar();
        this.cancel = new JButton();
        this.txt2 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FileDialog this$0;
            {
                FileDialog fileDialog = this$0;
                Objects.requireNonNull(fileDialog);
                this.this$0 = fileDialog;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.txt1.setText("Status : ...");
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(this){
            final /* synthetic */ FileDialog this$0;
            {
                FileDialog fileDialog = this$0;
                Objects.requireNonNull(fileDialog);
                this.this$0 = fileDialog;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.cancelActionPerformed(evt);
            }
        });
        this.txt2.setText("To : ...");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txt1, -1, -1, Short.MAX_VALUE).addComponent(this.progress, -1, 353, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cancel)).addComponent(this.txt2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.txt1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txt2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.progress, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel).addContainerGap()));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.abort = true;
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.worker != null) {
            if (this.worker.abort) {
                System.exit(0);
            }
            this.worker.abort = true;
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage:jcp src(s) dest");
            System.out.println("Usage:jmv src(s) dest");
            System.out.println("Usage:jrm file(s)");
            return;
        }
        final String[] _args = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileDialog fop = new FileDialog();
                fop.setVisible(true);
                fop.start(_args);
            }
        });
    }

    public void start(String[] cmd) {
        this.cmd = cmd;
        this.worker = new Worker(this);
        this.worker.start();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(this){
            final /* synthetic */ FileDialog this$0;
            {
                FileDialog fileDialog = this$0;
                Objects.requireNonNull(fileDialog);
                this.this$0 = fileDialog;
            }

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        4 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.update();
                    }
                });
            }
        }, 500L, 500L);
    }

    private String fit(String in) {
        if (in.length() < 25) {
            return in;
        }
        int idx = in.indexOf(" ");
        String p1 = in.substring(0, idx + 1);
        return p1 + "..." + in.substring(in.length() - (25 - p1.length()));
    }

    private synchronized void update() {
        if (this.msg1 != null) {
            this.txt1.setText(this.fit(this.msg1));
        }
        if (this.msg2 != null) {
            this.txt2.setText(this.fit(this.msg2));
        }
        if (this.hidetxt2) {
            this.hidetxt2 = false;
            this.txt2.setVisible(false);
        }
        if (this.amtTodo == 0L) {
            return;
        }
        int percent = this.done ? 100 : (int)(this.amtComplete * 100L / this.amtTodo);
        this.progress.setValue(percent);
    }

    public class Worker
    extends Thread {
        ArrayList<Op> ops;
        boolean abort;
        public static final int bufsiz = 65536;
        public byte[] buf;
        final /* synthetic */ FileDialog this$0;

        public Worker(FileDialog this$0) {
            FileDialog fileDialog = this$0;
            Objects.requireNonNull(fileDialog);
            this.this$0 = fileDialog;
            this.ops = new ArrayList();
            this.buf = new byte[65536];
        }

        @Override
        public void run() {
            try {
                if (this.this$0.cmd[0].equals("cp")) {
                    this.this$0.setTitle("Copying...");
                    this.this$0.msg1 = "Scanning files...";
                    String dest = this.this$0.cmd[this.this$0.cmd.length - 1];
                    for (int a = 1; a < this.this$0.cmd.length - 1; ++a) {
                        this.ops.add(new Op(this.this$0.cmd[a], dest));
                    }
                    this.this$0.amtTodo = this.getFileSize();
                    this.copy();
                } else if (this.this$0.cmd[0].equals("mv")) {
                    this.this$0.setTitle("Moving...");
                    this.this$0.msg1 = "Scanning files...";
                    String dest = this.this$0.cmd[this.this$0.cmd.length - 1];
                    for (int a = 1; a < this.this$0.cmd.length - 1; ++a) {
                        this.ops.add(new Op(this.this$0.cmd[a], dest));
                    }
                    this.this$0.amtTodo = this.getFileCount();
                    this.move();
                } else if (this.this$0.cmd[0].equals("rm")) {
                    this.this$0.setTitle("Deleting...");
                    this.this$0.hidetxt2 = true;
                    this.this$0.amtTodo = this.getFileCount();
                    for (int a = 1; a < this.this$0.cmd.length; ++a) {
                        this.remove(this.this$0.cmd[a]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }

        public long getFileSize() {
            long size = 0L;
            for (int a = 0; a < this.ops.size(); ++a) {
                if (this.abort) {
                    return 0L;
                }
                String src = this.ops.get((int)a).src;
                if (new File(src).isDirectory()) {
                    size += this.getDirectorySize(src);
                    continue;
                }
                size += this.getFileSize(src);
            }
            return size;
        }

        public long getFileSize(String file) {
            return new File(file).length();
        }

        public long getDirectorySize(String dir) {
            long size = 4096L;
            File[] files = new File(dir).listFiles();
            if (files == null) {
                return 0L;
            }
            for (int a = 0; a < files.length; ++a) {
                if (this.abort) {
                    return 0L;
                }
                if (files[a].isDirectory()) {
                    size += this.getDirectorySize(files[a].getAbsolutePath());
                    continue;
                }
                size += this.getFileSize(files[a].getAbsolutePath());
            }
            return size;
        }

        public long getFileCount() {
            long size = 0L;
            for (int a = 0; a < this.ops.size(); ++a) {
                if (this.abort) {
                    return 0L;
                }
                String src = this.ops.get((int)a).src;
                if (new File(src).isDirectory()) {
                    size += this.getDirectoryCount(src);
                    continue;
                }
                size += this.getFileCount(src);
            }
            return size;
        }

        public long getFileCount(String file) {
            return 1L;
        }

        public long getDirectoryCount(String dir) {
            long size = 1L;
            File[] files = new File(dir).listFiles();
            if (files == null) {
                return 0L;
            }
            for (int a = 0; a < files.length; ++a) {
                if (this.abort) {
                    return 0L;
                }
                if (files[a].isDirectory()) {
                    size += this.getDirectorySize(files[a].getAbsolutePath());
                    continue;
                }
                size += this.getFileSize(files[a].getAbsolutePath());
            }
            return size;
        }

        public void copy() {
            while (this.ops.size() > 0) {
                if (this.abort) {
                    return;
                }
                Op op = this.ops.remove(0);
                File srcFile = new File(op.src);
                if (srcFile.isDirectory()) {
                    this.copyDirectory(op.src, op.dest + "/" + srcFile.getName());
                    continue;
                }
                this.copyFile(op.src, op.dest);
            }
        }

        public void copyFile(String src, String destFolder) {
            this.this$0.msg1 = "Copying " + src;
            this.this$0.msg2 = "To " + destFolder;
            long amtBefore = this.this$0.amtComplete;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            File srcFile = new File(src);
            File destFile = new File(destFolder, srcFile.getName());
            long size = srcFile.length();
            try {
                fis = new FileInputStream(srcFile);
                fos = new FileOutputStream(destFile);
                long copied = 0L;
                long left = size;
                while (copied < size) {
                    if (this.abort) {
                        throw new Exception("abort");
                    }
                    int toRead = left > 65536L ? 65536 : (int)left;
                    int read = fis.read(this.buf, 0, toRead);
                    if (read <= 0) {
                        throw new Exception("read error");
                    }
                    fos.write(this.buf, 0, read);
                    copied += (long)read;
                    left -= (long)read;
                }
                fis.close();
                fis = null;
                fos.close();
                fos = null;
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                destFile.delete();
                if (this.abort) {
                    return;
                }
                if (JFAWT.showConfirm("Copy Error", "Failed to copy:" + src + "\nRetry?")) {
                    this.ops.add(new Op(src, destFolder));
                    this.this$0.amtComplete = amtBefore;
                }
                this.this$0.amtComplete = amtBefore + size;
            }
        }

        public void copyDirectory(String src, String dest) {
            this.this$0.msg1 = "Copying " + src;
            this.this$0.msg2 = "To " + dest;
            File srcFolder = new File(src);
            File destFolder = new File(dest);
            while (!destFolder.exists() && !destFolder.mkdir()) {
                if (this.abort) {
                    return;
                }
                if (JFAWT.showConfirm("Copy Error", "Failed to create folder:" + destFolder.getAbsolutePath() + "\nRetry?")) continue;
                return;
            }
            this.this$0.amtComplete += 4096L;
            File[] files = srcFolder.listFiles();
            if (files == null) {
                return;
            }
            for (int a = 0; a < files.length; ++a) {
                if (this.abort) {
                    return;
                }
                boolean isDir = files[a].isDirectory();
                if (isDir) {
                    this.copyDirectory(files[a].getAbsolutePath(), dest + "/" + files[a].getName());
                    continue;
                }
                this.copyFile(files[a].getAbsolutePath(), dest);
            }
        }

        public void move() {
            while (this.ops.size() > 0) {
                if (this.abort) {
                    return;
                }
                Op op = this.ops.remove(0);
                this.move(op.src, op.dest);
            }
        }

        public void move(String src, String dest) {
            this.this$0.msg1 = "Moving " + src;
            this.this$0.msg2 = "To " + dest;
            File srcFile = new File(src);
            File destFile = new File(dest, srcFile.getName());
            while (!srcFile.renameTo(destFile)) {
                if (JFAWT.showConfirm("Move Error", "Failed to move:" + src + "\nRetry?")) continue;
                return;
            }
            ++this.this$0.amtComplete;
        }

        public void remove(String name) {
            if (this.abort) {
                return;
            }
            this.this$0.msg1 = "Deleting " + name;
            File file = new File(name);
            if (file.isDirectory()) {
                this.removeDirectory(name);
            } else {
                while (!file.delete()) {
                    if (JFAWT.showConfirm("Delete Error", "Failed to delete:" + name + "\nRetry?")) continue;
                    return;
                }
                ++this.this$0.amtComplete;
            }
        }

        public void removeDirectory(String name) {
            File[] files = new File(name).listFiles();
            this.this$0.msg1 = "Deleting " + name;
            if (files != null) {
                for (int a = 0; a < files.length; ++a) {
                    if (this.abort) {
                        return;
                    }
                    this.remove(files[a].getAbsolutePath());
                }
            }
            File dir = new File(name);
            while (!dir.delete()) {
                if (JFAWT.showConfirm("Delete Error", "Failed to delete:" + name + "\nRetry?")) continue;
                return;
            }
            ++this.this$0.amtComplete;
        }
    }

    public static class Op {
        public String src;
        public String dest;

        public Op(String s, String d) {
            this.src = s;
            this.dest = d;
        }
    }
}

