/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LE;
import javaforce.MD5;
import javaforce.service.FileSyncServer;
import javaforce.webui.tasks.Status;

public class FileSync {
    public static boolean debug = false;
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_RECURSIVE = 1;
    public static final int FLAG_MIRROR = 2;
    private static final int FLAG_SUB_FOLDER = 32768;
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private Status status;
    private long file_date;
    private long file_size;
    private byte[] req = new byte[0x100050];
    private int req_len = 0;
    private long s_file_date;
    private long s_file_size;
    private byte[] reply = new byte[0x100050];
    private int reply_len = 0;
    private int reply_offset = 0;
    private MD5 md5 = new MD5();
    private Random random = new Random();
    private byte[] seed = new byte[16];
    private byte[] file_data = new byte[0x100040];
    private long file_offset;
    private byte[] buf = new byte[8];

    public boolean connect(String server) {
        return this.connect(server, KeyMgmt.getDefaultClient());
    }

    public boolean connect(String server, KeyMgmt keys) {
        try {
            this.s = new Socket(server, 33203);
            this.s = JF.connectSSL(this.s, keys);
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            this.s = null;
            this.is = null;
            this.os = null;
            return false;
        }
    }

    public boolean disconnect() {
        if (this.s == null) {
            return true;
        }
        try {
            this.s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.s = null;
        this.is = null;
        this.os = null;
        return true;
    }

    public boolean login(String passwd) {
        int strlen = passwd.length();
        int len = 8 + strlen;
        this.reset();
        this.write((byte)1);
        this.write(len);
        this.write(1);
        this.write(1);
        this.write(passwd.getBytes(), 0, strlen);
        try {
            if (debug) {
                JFLog.log(String.format("c.cmd=%x len=%d (login)", this.req[0], this.req_len - 5));
            }
            this.os.write(this.req, 0, this.req_len);
            return this.read_reply() == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean sync(String src_folder, String dest_folder, int flags) {
        return this.sync(src_folder, null, dest_folder, flags);
    }

    public boolean sync(String src_folder, String[] src_files, String dest_folder, int flags) {
        if ((flags & 2) != 0) {
            JFLog.log("FileSync : mirror not supported");
            return false;
        }
        boolean recursive = (flags & 1) != 0;
        boolean sub_folder = (flags & 0x8000) != 0;
        this.random.setSeed(System.currentTimeMillis());
        this.random.nextBytes(this.seed);
        File src_folder_file = new File(src_folder);
        if (src_files == null) {
            src_files = src_folder_file.list();
        }
        if (!this.folder_open(dest_folder) && !this.folder_create(dest_folder)) {
            JFLog.log("FileSync : unable to create folder:" + dest_folder);
            return false;
        }
        int todo = src_files.length;
        int done = 0;
        for (String filename : src_files) {
            ++done;
            if (debug) {
                JFLog.log("file_sync:" + filename);
            }
            if (filename.startsWith(".")) continue;
            File file = new File(src_folder + "/" + filename);
            if (!file.exists()) {
                if (!debug) continue;
                JFLog.log("File not found:" + filename);
                continue;
            }
            if (file.isDirectory()) {
                if (!recursive) continue;
                if (!this.sync(src_folder + "/" + filename, null, dest_folder + "/" + filename, flags | 0x8000)) {
                    return false;
                }
                if (!this.folder_open(dest_folder)) {
                    return false;
                }
            } else if (!this.file_sync(src_folder, filename, file)) {
                return false;
            }
            if (this.status == null || sub_folder) continue;
            this.status.setPercent(done * 100 / todo);
        }
        return true;
    }

    private void reset() {
        this.req_len = 0;
    }

    private boolean write(byte b) {
        this.req[this.req_len++] = b;
        return true;
    }

    private boolean write(int len) {
        LE.setuint32(this.buf, 0, len);
        return this.write(this.buf, 0, 4);
    }

    private boolean write(long len) {
        LE.setuint64(this.buf, 0, len);
        return this.write(this.buf, 0, 8);
    }

    private boolean write(byte[] buf, int offset, int length) {
        if (this.req_len + length > 0x100040) {
            return false;
        }
        System.arraycopy(buf, offset, this.req, this.req_len, length);
        this.req_len += length;
        return true;
    }

    private byte readByte() {
        if (this.reply_offset + 1 > this.reply_len) {
            return -1;
        }
        return this.reply[this.reply_offset++];
    }

    private short readShort() {
        if (this.reply_offset + 2 > this.reply_len) {
            return -1;
        }
        short value = (short)LE.getuint16(this.reply, this.reply_offset);
        this.reply_offset += 2;
        return value;
    }

    private int readInt() {
        if (this.reply_offset + 4 > this.reply_len) {
            return -1;
        }
        int value = LE.getuint32(this.reply, this.reply_offset);
        this.reply_offset += 4;
        return value;
    }

    private long readLong() {
        if (this.reply_offset + 8 > this.reply_len) {
            return -1L;
        }
        long value = LE.getuint64(this.reply, this.reply_offset);
        this.reply_offset += 8;
        return value;
    }

    private boolean readBytes(byte[] out, int off, int len) {
        if (this.reply_offset + len > this.reply_len) {
            return false;
        }
        System.arraycopy(this.reply, this.reply_offset, out, off, len);
        this.reply_offset += len;
        return true;
    }

    private int read_reply() throws Exception {
        int cmd = this.is.read();
        if (cmd == -1) {
            throw new Exception("read error");
        }
        if (this.is.readNBytes(this.reply, 0, 4) != 4) {
            throw new Exception("read error");
        }
        this.reply_len = LE.getuint32(this.reply, 0);
        if (debug) {
            JFLog.log(String.format("s.cmd=%x len=%d", cmd, this.reply_len));
        }
        if (this.reply_len > 0 && this.is.readNBytes(this.reply, 0, this.reply_len) != this.reply_len) {
            throw new Exception("read error");
        }
        this.reply_offset = 0;
        return cmd;
    }

    private boolean file_sync(String folder, String filename, File file) {
        this.file_date = file.lastModified();
        this.file_size = file.length();
        return this.file_open(folder, filename);
    }

    private boolean file_open(String folder, String filename) {
        int strlen = filename.length();
        int len = 16 + strlen;
        this.reset();
        this.write((byte)16);
        this.write(len);
        this.write(this.file_date);
        this.write(this.file_size);
        this.write(filename.getBytes(), 0, strlen);
        try {
            if (debug) {
                JFLog.log(String.format("c.cmd=%x len=%d (file_open:%s)", this.req[0], this.req_len - 5, filename));
            }
            this.os.write(this.req, 0, this.req_len);
            int cmd = this.read_reply();
            switch (cmd) {
                case 4: {
                    this.s_file_date = 0L;
                    this.s_file_size = 0L;
                    return this.file_sync_blocks(folder, filename);
                }
                case 2: {
                    if (this.reply_len != 16) {
                        throw new Exception("bad reply");
                    }
                    this.s_file_date = this.readLong();
                    this.s_file_size = this.readLong();
                    return this.file_sync_blocks(folder, filename);
                }
                case 3: {
                    return true;
                }
            }
            throw new Exception(String.format("file_open:unknown reply:%x", cmd));
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean file_sync_blocks(String folder, String filename) {
        try {
            RandomAccessFile file_io = new RandomAccessFile(folder + "/" + filename, "r");
            this.file_offset = 0L;
            while (this.file_offset < this.file_size) {
                int block_size = 0x100000;
                if (this.file_offset + (long)block_size > this.file_size) {
                    block_size = (int)(this.file_size - this.file_offset);
                }
                if (this.file_offset >= this.s_file_size) {
                    file_io.readFully(this.file_data, 0, block_size);
                    if (this.file_block_data(block_size) != 0) {
                        return false;
                    }
                    this.file_offset += (long)block_size;
                    continue;
                }
                if (this.file_offset + (long)block_size > this.s_file_size) {
                    block_size = (int)(this.s_file_size - this.file_offset);
                }
                file_io.readFully(this.file_data, 0, block_size);
                this.md5.init();
                this.md5.add(this.seed, 0, 16);
                this.md5.add(this.file_data, 0, block_size);
                int cmd = this.file_block_hash(block_size, this.md5.done());
                switch (cmd) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        if (this.file_block_data(block_size) == 0) break;
                        return false;
                    }
                    default: {
                        throw new Exception(String.format("unknown return cmd:%x", cmd));
                    }
                }
                this.file_offset += (long)block_size;
            }
            file_io.close();
            return this.s_file_size <= this.file_size || this.file_truncate() == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private int file_block_hash(int block_len, byte[] hash) throws Exception {
        if (debug) {
            FileSyncServer.print_hash(hash);
        }
        this.reset();
        int len = 48;
        this.write((byte)17);
        this.write(len);
        this.write(2);
        this.write(this.file_offset);
        this.write(block_len);
        this.write(hash, 0, 16);
        this.write(this.seed, 0, 16);
        if (debug) {
            JFLog.log(String.format("block_hash:%d %d %d", 2, this.file_offset, block_len));
        }
        if (debug) {
            JFLog.log(String.format("c.cmd=%x len=%d (file_block_hash)", this.req[0], this.req_len - 5));
        }
        this.os.write(this.req, 0, this.req_len);
        int cmd = this.read_reply();
        return cmd;
    }

    private int file_block_data(int block_len) throws Exception {
        this.reset();
        int len = 8 + block_len;
        this.write((byte)18);
        this.write(len);
        this.write(this.file_offset);
        this.write(this.file_data, 0, block_len);
        if (debug) {
            JFLog.log(String.format("c.cmd=%x len=%d (file_block_data)", this.req[0], this.req_len - 5));
        }
        this.os.write(this.req, 0, this.req_len);
        int cmd = this.read_reply();
        if (cmd != 0) {
            JFLog.log(String.format("FileSync : file_block_data() failed : cmd=%x", cmd));
        }
        return cmd;
    }

    private int file_truncate() throws Exception {
        this.reset();
        int len = 8;
        this.write((byte)19);
        this.write(len);
        this.write(this.file_size);
        if (debug) {
            JFLog.log(String.format("c.cmd=%x len=%d (file_trunate)", this.req[0], this.req_len - 5));
        }
        this.os.write(this.req, 0, this.req_len);
        int cmd = this.read_reply();
        return cmd;
    }

    private boolean folder_open(String folder) {
        int strlen = folder.length();
        this.reset();
        int len = strlen;
        this.write((byte)32);
        this.write(len);
        this.write(folder.getBytes(), 0, strlen);
        try {
            if (debug) {
                JFLog.log(String.format("c.cmd=%x len=%d (folder_open:%s)", this.req[0], this.req_len - 5, folder));
            }
            this.os.write(this.req, 0, this.req_len);
            int cmd = this.read_reply();
            if (cmd != 0) {
                JFLog.log("FileSync : unable to open folder:" + folder);
            }
            return cmd == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean folder_create(String folder) {
        int strlen = folder.length();
        this.reset();
        int len = strlen;
        this.write((byte)33);
        this.write(len);
        this.write(folder.getBytes(), 0, strlen);
        try {
            if (debug) {
                JFLog.log(String.format("c.cmd=%x len=%d (folder_create:%s)", this.req[0], this.req_len - 5, folder));
            }
            this.os.write(this.req, 0, this.req_len);
            int cmd = this.read_reply();
            return cmd == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage:jfsync src_folder server password dest_folder [-r]");
            return;
        }
        String src_folder = args[0];
        String server = args[1];
        String password = args[2];
        String dst_folder = args[3];
        int flags = 0;
        for (int i = 4; i < args.length; ++i) {
            String key;
            String arg = args[i];
            int idx = arg.indexOf(61);
            if (idx == -1) {
                key = arg;
                value = "";
            } else {
                key = arg.substring(0, idx);
                value = arg.substring(idx + 1);
            }
            switch (key) {
                case "-r": {
                    flags |= 1;
                }
            }
        }
        FileSync sync = new FileSync();
        if (!sync.connect(server)) {
            JFLog.log("Error:connect failed!");
            return;
        }
        if (!sync.login(password)) {
            JFLog.log("Error:login failed!");
            return;
        }
        if (debug) {
            JFLog.log("Login granted");
        }
        if (!sync.sync(src_folder, dst_folder, flags)) {
            JFLog.log("sync failed!");
            System.exit(1);
        } else {
            JFLog.log("sync complete");
        }
    }
}

