/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.linux.Linux;

public class Package {
    private static String type;

    public static void main(String[] args) {
        if (JF.isWindows()) {
            Package.doWindows();
        } else {
            Package.doLinux();
        }
    }

    private static void doWindows() {
        String[] projects;
        type = "msi";
        for (String project : projects = new File("projects").list()) {
            if (!new File("projects/" + project + "/wix64.xml").exists() || Package.execute("projects/" + project)) continue;
            return;
        }
    }

    private static void doLinux() {
        String[] projects;
        Linux.detectDistro();
        String distro = null;
        String version = null;
        switch (Linux.distro) {
            case Debian: {
                type = "deb";
                distro = "debian";
                version = Linux.getVersionCodeName();
                break;
            }
            case Fedora: {
                type = "rpm";
                distro = "fedora";
                version = Linux.getVersion();
                break;
            }
            case Arch: {
                type = "pac";
                distro = "arch";
                version = "latest";
            }
        }
        if (!Package.clean_repo(distro, version)) {
            JFLog.log("clean repo failed");
            return;
        }
        JF.deletePathEx(".", ".*\\.class$");
        if (!Package.execute(".")) {
            return;
        }
        if (!Package.execute("utils")) {
            return;
        }
        for (String project : projects = new File("projects").list()) {
            if (Package.execute("projects/" + project)) continue;
            return;
        }
        Package.package_libs();
    }

    private static boolean clean_repo(String distro, String version) {
        String cpu = System.getenv("HOSTTYPE");
        if (cpu == null) {
            return false;
        }
        if (distro.equals("debian")) {
            switch (cpu) {
                case "x86_64": {
                    cpu = "amd64";
                    break;
                }
                case "aarch64": {
                    cpu = "arm64";
                }
            }
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb = pb.directory(new File("repo/" + distro + "/" + version + "/" + cpu));
        pb = pb.redirectOutput(new File("output.log"));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/usr/bin/bash");
        cmd.add("clean.sh");
        pb = pb.command(cmd);
        try {
            Process p = pb.start();
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean execute(String folder) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb = pb.directory(new File(folder));
        pb = pb.redirectOutput(new File("output.log"));
        ArrayList<String> cmd = new ArrayList<String>();
        if (JF.isWindows()) {
            cmd.add("ant.bat");
        } else {
            cmd.add("ant");
        }
        cmd.add(type);
        pb = pb.command(cmd);
        try {
            Process p = pb.start();
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void package_libs() {
    }
}

