/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.ArrayList;

public class WixHeat {
    private static StringBuilder out;
    private static String input_folder;
    private static String output_xml;
    private static String base_folder;
    private static String res_name;
    private static ArrayList<String> files;
    private static ArrayList<PathMatcher> matches;
    private static ArrayList<String> wixfolders;
    private static ArrayList<Entry> wixfiles;
    private static String dir;
    private static String cmp;
    private static int baseguid;
    private static int guid;
    private static int fileid;

    private static void usage() {
        System.out.println("Usage:WixHeat input_folder output_xml resource_name base_folder [files...]");
        System.exit(1);
    }

    private static void outHeader() {
        out.append("<Wix xmlns=\"http://wixtoolset.org/schemas/v4/wxs\">\n");
    }

    private static void addFolder(String parent, String path) throws Exception {
        String fullpath;
        File folder;
        File[] files;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((files = (folder = new File(fullpath = input_folder + path)).listFiles()) == null || files.length == 0) {
            return;
        }
        int idx = path.lastIndexOf("/");
        idx = idx == -1 ? 0 : ++idx;
        int cnt = 0;
        for (int a = 0; a < files.length; ++a) {
            String name = files[a].getName();
            if (files[a].isDirectory()) {
                if (files[a].getName().equals("jmods") || files[a].getName().equals("legal")) continue;
                WixHeat.addFolder(path, path + "/" + name);
                continue;
            }
            boolean matched = false;
            for (int m = 0; m < matches.size(); ++m) {
                PathMatcher matcher = matches.get(m);
                if (!matcher.matches(files[a].toPath())) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            Entry e = new Entry();
            e.path = path;
            e.file = name;
            wixfiles.add(e);
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        WixHeat.outFolder(parent, path.substring(idx), path);
        wixfolders.add(path);
    }

    private static void outFolder(String parent, String name, String path) {
        if (name.equals("")) {
            name = base_folder;
        }
        String id = path.replaceAll("/", "_");
        String did = dir + id;
        String pid = parent.replaceAll("/", "_");
        Object dpid = dir + pid;
        if (parent.equals("APPLICATIONROOTDIRECTORY")) {
            dpid = "APPLICATIONROOTDIRECTORY";
        }
        out.append("<Fragment>\n");
        out.append("  <DirectoryRef Id=\"" + (String)dpid + "\">\n");
        out.append("    <Directory Id=\"" + did + "\" Name=\"" + name + "\" FileSource=\"" + (input_folder + path).replaceAll("/", "\\\\") + "\" />\n");
        out.append("  </DirectoryRef>\n");
        out.append("</Fragment>\n");
    }

    private static void outFiles(String path) {
        String id = path.replaceAll("/", "_");
        String did = dir + id;
        String cid = cmp + id;
        out.append("<Fragment>\n");
        out.append("    <DirectoryRef Id=\"" + did + "\">\n");
        out.append("        <Component Id=\"" + cid + "\" Guid=\"{8A8E15CB-3AA6-4D96-AD6D-5241AD" + Integer.toHexString(baseguid) + guid++ + "}\" Bitness=\"always64\">\n");
        int cnt = wixfiles.size();
        for (int a = 0; a < cnt; ++a) {
            Entry e = wixfiles.get(a);
            if (!e.path.equals(path)) continue;
            Object src = e.path.length() == 0 ? e.file : e.path + "/" + e.file;
            Object fid = dir + "_" + fileid++;
            switch (src) {
                case "bin/java.exe": {
                    fid = "java_exe";
                    break;
                }
                case "bin/javaw.exe": {
                    fid = "javaw_exe";
                }
            }
            out.append("<File Id=\"" + (String)fid + "\" Source=\"" + (String)src + "\" />\n");
        }
        out.append("        </Component>\n");
        out.append("    </DirectoryRef>\n");
        out.append("</Fragment>\n");
    }

    private static void outTrailer() {
        out.append("<Fragment>\n");
        out.append("  <ComponentGroup Id=\"" + res_name + "\">\n");
        for (int a = 0; a < wixfolders.size(); ++a) {
            String path = wixfolders.get(a).replaceAll("/", "_");
            out.append("    <ComponentRef Id=\"" + cmp + path + "\" />\n");
        }
        out.append("  </ComponentGroup>\n");
        out.append("</Fragment>\n");
        out.append("</Wix>\n");
    }

    public static void main(String[] args) {
        int a;
        if (args.length < 4) {
            WixHeat.usage();
        }
        out = new StringBuilder();
        input_folder = args[0].replaceAll("\\\\", "/");
        output_xml = args[1].replaceAll("\\\\", "/");
        res_name = args[2];
        base_folder = args[3].replaceAll("\\\\", "/");
        files = new ArrayList();
        matches = new ArrayList();
        wixfolders = new ArrayList();
        wixfiles = new ArrayList();
        baseguid = 0;
        guid = 1000;
        fileid = 0;
        for (int a2 = 4; a2 < args.length; ++a2) {
            files.add(args[a2]);
        }
        if (args.length == 4) {
            files.add("**");
        }
        FileSystem fs = FileSystems.getDefault();
        for (int a3 = 0; a3 < files.size(); ++a3) {
            matches.add(fs.getPathMatcher("glob:" + files.get(a3)));
        }
        char[] ca = res_name.toCharArray();
        for (a = 0; a < ca.length; ++a) {
            baseguid += ca[a];
        }
        if ((baseguid &= 0xFF) < 16) {
            baseguid |= 0x10;
        }
        if (!input_folder.endsWith("/")) {
            input_folder = input_folder + "/";
        }
        cmp = "cmp_" + res_name + "_";
        dir = "dir_" + res_name + "_";
        try {
            System.out.println("WixHeat : input_folder=" + input_folder);
            WixHeat.outHeader();
            WixHeat.addFolder("APPLICATIONROOTDIRECTORY", "");
            for (a = 0; a < wixfolders.size(); ++a) {
                WixHeat.outFiles(wixfolders.get(a));
            }
            WixHeat.outTrailer();
            FileOutputStream fos = new FileOutputStream(output_xml);
            fos.write(out.toString().getBytes());
            fos.close();
            System.out.println("WixHeat : " + output_xml + " created");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Entry {
        public String path;
        public String file;

        private Entry() {
        }
    }
}

