/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.JF;

public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String addr_type;
    public String domain;
    public String bus;
    public String slot;
    public String function;
    public String port;
    public String controller;
    public String target;
    public String unit;

    public Address() {
    }

    public Address(String domain, String bus, String slot, String function) {
        this.setPCIAddress(domain, bus, slot, function);
    }

    public void setPCIAddress(String domain, String bus, String slot, String function) {
        this.addr_type = "pci";
        this.domain = domain;
        this.bus = bus;
        this.slot = slot;
        this.function = function;
    }

    public Address(String bus, String port) {
        this.setUSBAddress(bus, port);
    }

    public void setUSBAddress(String bus, String port) {
        this.addr_type = "usb";
        this.bus = bus;
        this.port = port;
    }

    public void setDriveAddress(String controller, String bus, String target, String unit) {
        this.addr_type = "drive";
        this.controller = controller;
        this.bus = bus;
        this.target = target;
        this.unit = unit;
    }

    public void setAutoAddress() {
        this.addr_type = "auto";
        this.domain = null;
        this.bus = null;
        this.slot = null;
        this.function = null;
        this.port = null;
    }

    public String getType() {
        if (this.addr_type == null) {
            this.addr_type = "auto";
        }
        return this.addr_type;
    }

    public String getDomain() {
        if (this.domain == null) {
            return "0x0000";
        }
        return this.domain;
    }

    public String getBus(boolean pci) {
        if (this.bus == null) {
            if (pci) {
                return "0x00";
            }
            return "0";
        }
        return this.bus;
    }

    public String getSlot() {
        if (this.slot == null) {
            return "0x00";
        }
        return this.slot;
    }

    public String getFunction() {
        if (this.function == null) {
            return "0x0";
        }
        return this.function;
    }

    public String getPort() {
        if (this.port == null) {
            return "0";
        }
        return this.port;
    }

    public static String cleanHex(String str, int max) {
        if (str.startsWith("0x")) {
            str = str.substring(2);
        }
        str = str.toLowerCase();
        if ((str = JF.filter(str, JF.filter_hex)).length() == 0 || Integer.valueOf(str, 16) > max) {
            switch (max) {
                case 15: {
                    return "0x0";
                }
                case 255: {
                    return "0x00";
                }
                case 65535: {
                    return "0x0000";
                }
            }
        }
        return "0x" + str;
    }

    public static String cleanDec(String str, int max) {
        if ((str = JF.filter(str, JF.filter_numeric)).length() == 0 || Integer.valueOf(str) > max) {
            return "0";
        }
        return str;
    }

    public String getAddressXML() {
        if (this.addr_type == null || this.addr_type.equals("auto")) {
            return "";
        }
        StringBuilder xml2 = new StringBuilder();
        switch (this.addr_type) {
            case "pci": {
                xml2.append("<address type='" + this.addr_type + "' domain='" + this.domain + "' bus='" + this.bus + "' slot='" + this.slot + "' function='" + this.function + "'/>");
                break;
            }
            case "usb": {
                xml2.append("<address type='" + this.addr_type + "' bus='" + this.bus + "' slot='" + this.slot + "'/>");
                break;
            }
            case "drive": {
                xml2.append("<address type='" + this.addr_type + "' controller='" + this.controller + "' bus='" + this.bus + "' target='" + this.target + "' unit='" + this.unit + "'/>");
            }
        }
        return xml2.toString();
    }
}

