/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import javaforce.api.VMAPI;
import javaforce.linux.Linux;

public class VMHost {
    private static final long ms_day = 86400000L;

    public static long total_memory() {
        return VMAPI.getInstance().vmTotalMemory();
    }

    public static long free_memory() {
        return VMAPI.getInstance().vmFreeMemory();
    }

    public static long cpu_load() {
        return VMAPI.getInstance().vmCpuLoad();
    }

    public static boolean get_all_stats(int year, int month, int day, int hour, int sample) {
        return VMAPI.getInstance().vmGetAllStats(year, month, day, hour, sample);
    }

    public static void clean_stats(int days) {
        long ts = System.currentTimeMillis() - (long)days * 86400000L;
        File[] folders = new File("/var/jfkvm/stats").listFiles();
        if (folders == null || folders.length == 0) {
            return;
        }
        for (File folder : folders) {
            File[] files = folder.listFiles();
            int deleted = 0;
            for (File file : files) {
                if (file.lastModified() >= ts) continue;
                file.delete();
                ++deleted;
            }
            if (files.length != deleted) continue;
            folder.delete();
        }
    }

    public boolean connect(String remote) {
        return VMAPI.getInstance().vmConnect(remote);
    }

    public static String getHostname() {
        return Linux.getHostname();
    }
}

