/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.api.VMAPI;
import javaforce.utils.FileSync;
import javaforce.vm.Controller;
import javaforce.vm.Device;
import javaforce.vm.Disk;
import javaforce.vm.Hardware;
import javaforce.vm.MAC;
import javaforce.vm.Network;
import javaforce.vm.NetworkBridge;
import javaforce.vm.Size;
import javaforce.vm.Snapshot;
import javaforce.vm.Storage;
import javaforce.vm.VMProvider;
import javaforce.webui.tasks.Status;

public class VirtualMachine
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String pool;
    public String folder;
    public String name;
    private String uuid;
    private int vnc;
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_SUSPEND = 2;
    public static final int STATE_ERROR = 3;
    public static final int STATE_NOT_FOUND = -1;
    public static final int SNAPSHOT_CREATE_DISK_ONLY = 16;
    public static final int SNAPSHOT_CREATE_QUIESCE = 64;
    public static final int SNAPSHOT_CREATE_ATOMIC = 128;
    public static final int SNAPSHOT_CREATE_LIVE = 256;

    private VirtualMachine(String pool, String folder, String name, String uuid, int vnc) {
        if (folder == null) {
            folder = name;
        }
        if (uuid == null) {
            uuid = JF.generateUUID();
        }
        this.pool = pool;
        this.folder = folder;
        this.name = name;
        this.uuid = uuid;
        this.vnc = vnc;
    }

    public VirtualMachine(Hardware hardware) {
        this.pool = hardware.pool;
        this.folder = hardware.folder;
        this.name = hardware.name;
        this.uuid = JF.generateUUID();
        this.vnc = -1;
    }

    public static boolean init() {
        return VMAPI.getInstance().vmInit();
    }

    public String getPool() {
        return this.pool;
    }

    public String getName() {
        return this.name;
    }

    public int getVNC() {
        return this.vnc;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getPath() {
        return "/volumes/" + this.pool + "/" + this.folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getFile() {
        return this.name + ".jfvm";
    }

    public Hardware loadHardware() {
        return Hardware.load(this.getPool(), this.getFolder(), this.getFile());
    }

    public boolean saveHardware(Hardware hardware) {
        return hardware.save();
    }

    public void create_stats_folder() {
        new File("/var/jfkvm/stats/" + this.uuid).mkdir();
    }

    public boolean check_write_access() {
        File file = new File(this.getPath() + "/jfkvm-test.tmp");
        byte[] data = Long.toString(System.currentTimeMillis()).getBytes();
        try {
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
            FileInputStream fis = new FileInputStream(file);
            byte[] verify = fis.readAllBytes();
            fis.close();
            if (verify == null || verify.length != data.length) {
                throw new Exception("check_write_access:failed");
            }
            for (int a = 0; a < data.length; ++a) {
                if (verify[a] == data[a]) continue;
                throw new Exception("check_write_access:failed");
            }
            file.delete();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean start() {
        if (!this.check_write_access()) {
            return false;
        }
        this.create_stats_folder();
        return VMAPI.getInstance().vmStart(this.name);
    }

    public boolean stop() {
        return VMAPI.getInstance().vmStop(this.name);
    }

    public boolean poweroff() {
        return VMAPI.getInstance().vmPowerOff(this.name);
    }

    public boolean restart() {
        return VMAPI.getInstance().vmRestart(this.name);
    }

    public boolean suspend() {
        return VMAPI.getInstance().vmSuspend(this.name);
    }

    public boolean resume() {
        return VMAPI.getInstance().vmResume(this.name);
    }

    public int getState() {
        return VMAPI.getInstance().vmGetState(this.name);
    }

    public String getStateString() {
        int state = this.getState();
        switch (state) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "suspended";
            }
            case 3: {
                return "error";
            }
            case -1: {
                return "not found";
            }
        }
        return Integer.toString(state);
    }

    public static int getState(String state) {
        switch (state) {
            case "on": {
                return 1;
            }
            case "off": {
                return 0;
            }
            case "suspended": {
                return 2;
            }
            case "error": {
                return 3;
            }
        }
        return -1;
    }

    public String[] getStates() {
        return new String[]{this.name, this.getStateString(), this.pool};
    }

    private static VirtualMachine getByDesc(String desc) {
        String[] fs = desc.split(";");
        String pool = null;
        String folder = null;
        String name = null;
        String uuid = null;
        int vnc = 0;
        block14: for (int a = 0; a < fs.length; ++a) {
            String f = fs[a];
            int i = f.indexOf(61);
            if (i == -1) continue;
            String key = f.substring(0, i).trim();
            String value = f.substring(i + 1).trim();
            switch (key) {
                case "pool": {
                    pool = value;
                    continue block14;
                }
                case "folder": {
                    folder = value;
                    continue block14;
                }
                case "name": {
                    name = value;
                    continue block14;
                }
                case "uuid": {
                    uuid = value;
                    continue block14;
                }
                case "vnc": {
                    vnc = Integer.valueOf(value);
                }
            }
        }
        return new VirtualMachine(pool, folder, name, uuid, vnc);
    }

    public static VirtualMachine[] list() {
        String[] list = VMAPI.getInstance().vmList();
        if (list == null) {
            list = new String[]{};
        }
        VirtualMachine[] vms = new VirtualMachine[list.length];
        for (int idx = 0; idx < list.length; ++idx) {
            vms[idx] = VirtualMachine.getByDesc(list[idx]);
        }
        return vms;
    }

    public static VirtualMachine get(String name) {
        String vm = VMAPI.getInstance().vmGet(name);
        if (vm == null) {
            return null;
        }
        return VirtualMachine.getByDesc(vm);
    }

    public static boolean register(VirtualMachine vm, Hardware hardware, VMProvider provider) {
        String xml2 = VirtualMachine.createXML(vm, hardware, provider);
        JFLog.log("VirtualMachine.xml=" + xml2);
        return VMAPI.getInstance().vmRegister(xml2);
    }

    public boolean reregister(Hardware hardware, VMProvider provider) {
        String xml2 = VirtualMachine.createXML(this, hardware, provider);
        JFLog.log("VirtualMachine.xml=" + xml2);
        return VMAPI.getInstance().vmRegister(xml2);
    }

    public boolean unregister() {
        return VMAPI.getInstance().vmUnregister(this.name);
    }

    public boolean migrateCompute(String desthost, boolean live, Status status) {
        return VMAPI.getInstance().vmMigrate(this.name, desthost, live, status);
    }

    public boolean migrateData(Storage dest_pool, Hardware hw, Status status, VMProvider provider) {
        if (status == null) {
            status = Status.null_status;
        }
        String _src_folder = "/volumes/" + this.pool + "/" + this.folder;
        String _dest_folder = "/volumes/" + dest_pool.name + "/" + this.folder;
        File src_folder = new File(_src_folder);
        if (!src_folder.exists()) {
            status.setStatus("Source folder not found");
            status.setResult(false);
            return false;
        }
        File dest_folder = new File(_dest_folder);
        if (dest_folder.exists()) {
            status.setStatus("Dest folder already exists");
            status.setResult(false);
            return false;
        }
        dest_folder.mkdir();
        if (!dest_folder.exists()) {
            status.setStatus("Unable to create Dest folder");
            status.setResult(false);
            return false;
        }
        File[] files = src_folder.listFiles();
        if (files == null || files.length == 0) {
            status.setStatus("No files found");
            status.setResult(false);
            return false;
        }
        int done = 0;
        int todo = files.length;
        status.setPercent(0);
        status.setStatus("Moving files...");
        for (File file : files) {
            String src_name;
            ++done;
            if (file.isDirectory()) continue;
            String dst_name = src_name = file.getName();
            Path src_path = file.toPath();
            Path dest_path = new File(_dest_folder + "/" + dst_name).toPath();
            try {
                Files.move(src_path, dest_path, new CopyOption[0]);
            }
            catch (Exception e) {
                JFLog.log(e);
                status.setStatus("Move failed, see logs.");
                status.setResult(false);
                return false;
            }
            status.setPercent(done * 100 / todo);
        }
        src_folder.delete();
        String src_pool = this.pool;
        this.pool = dest_pool.name;
        hw.pool = dest_pool.name;
        for (Disk disk : hw.disks) {
            if (!disk.pool.equals(src_pool)) continue;
            disk.pool = dest_pool.name;
        }
        if (!this.saveHardware(hw)) {
            status.setStatus("Move failed, see logs.");
            status.setResult(false);
            return false;
        }
        if (!VirtualMachine.register(this, hw, provider)) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        status.setPercent(100);
        status.setStatus("Completed");
        status.setResult(true);
        return true;
    }

    public boolean cloneData(Storage dest_pool, String new_name, Status status, VMProvider provider) {
        if (status == null) {
            status = Status.null_status;
        }
        String _src_folder = "/volumes/" + this.pool + "/" + this.folder;
        String _dest_folder = "/volumes/" + dest_pool.name + "/" + new_name;
        File src_folder = new File(_src_folder);
        if (!src_folder.exists()) {
            status.setStatus("Source folder not found");
            status.setResult(false);
            return false;
        }
        File dest_folder = new File(_dest_folder);
        if (dest_folder.exists()) {
            status.setStatus("Dest folder already exists");
            status.setResult(false);
            return false;
        }
        dest_folder.mkdir();
        if (!dest_folder.exists()) {
            status.setStatus("Unable to create Dest folder");
            status.setResult(false);
            return false;
        }
        File[] files = src_folder.listFiles();
        if (files == null || files.length == 0) {
            status.setStatus("No files found");
            status.setResult(false);
            return false;
        }
        int done = 0;
        int todo = files.length;
        status.setPercent(0);
        status.setStatus("Copying files...");
        for (File file : files) {
            ++done;
            if (file.isDirectory()) continue;
            String src_name = file.getName();
            Object dst_name = src_name;
            if (src_name.equals(this.name + ".jfvm")) {
                dst_name = new_name + ".jfvm";
            }
            Path src_path = file.toPath();
            Path dest_path = new File(_dest_folder + "/" + (String)dst_name).toPath();
            try {
                Files.copy(src_path, dest_path, new CopyOption[0]);
            }
            catch (Exception e) {
                JFLog.log(e);
                status.setStatus("Clone failed, see logs.");
                status.setResult(false);
                return false;
            }
            status.setPercent(done * 100 / todo);
        }
        VirtualMachine clone = new VirtualMachine(dest_pool.name, new_name, new_name, JF.generateUUID(), -1);
        Hardware hw = clone.loadHardware();
        if (hw == null) {
            status.setStatus("Clone failed, see logs.");
            status.setResult(false);
            return false;
        }
        hw.folder = new_name;
        hw.name = new_name;
        if (!this.pool.equals(dest_pool.name)) {
            hw.pool = dest_pool.name;
            for (Disk disk : hw.disks) {
                if (!disk.pool.equals(this.pool)) continue;
                disk.pool = dest_pool.name;
            }
        }
        if (!clone.saveHardware(hw)) {
            status.setStatus("Clone failed (unable to save Hardware), see logs.");
            status.setResult(false);
            return false;
        }
        if (!VirtualMachine.register(clone, hw, provider)) {
            status.setStatus("Clone failed (unable to register VM), see logs.");
            status.setResult(false);
            return false;
        }
        status.setPercent(100);
        status.setStatus("Completed");
        status.setResult(true);
        return true;
    }

    private String[] getFiles() {
        Hardware hw = this.loadHardware();
        if (hw == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.name + ".jfvm");
        String vmx = this.name + ".vmx";
        if (new File(vmx).exists()) {
            list.add(vmx);
        }
        for (Disk disk : hw.disks) {
            list.add(disk.getFile());
        }
        return list.toArray(JF.StringArrayType);
    }

    public boolean backupData(String host, String pool, String folder, String host_token, Status status) {
        JFLog.log("VM:backupData(" + host + "," + pool + "," + folder + ")");
        String[] files = this.getFiles();
        if (files == null) {
            JFLog.log("VM:backupData() failed : unable to load hardware config");
            return false;
        }
        FileSync sync = new FileSync();
        if (!sync.connect(host)) {
            JFLog.log("VM:backupData() failed : unable to connect to host:" + host);
            return false;
        }
        if (!sync.login(host_token)) {
            JFLog.log("VM:backupData() failed : unable to authenticate with host:" + host);
            sync.disconnect();
            return false;
        }
        sync.setStatus(status);
        boolean ret = sync.sync(this.getPath(), this.getFiles(), pool + "/" + folder, 0);
        sync.disconnect();
        if (!ret) {
            JFLog.log("VM:backupData() failed : FileSync.sync() failed!");
        }
        return ret;
    }

    public boolean snapshotCreate(String name, String desc, int flags) {
        String xml2;
        Snapshot[] list;
        if (name == null || name.length() == 0) {
            JFLog.log("Error:VM:snapshot name invalid");
            return false;
        }
        for (Snapshot ss : list = this.snapshotList()) {
            if (!ss.name.equals(name)) continue;
            JFLog.log("Error:VM:snapshot name already exists");
            return false;
        }
        if (desc == null) {
            desc = "";
        }
        if ((xml2 = this.snapshotCreateXML(name, desc)) == null) {
            return false;
        }
        return VMAPI.getInstance().vmSnapshotCreate(this.name, xml2, flags);
    }

    public Snapshot[] snapshotList() {
        String[] list = VMAPI.getInstance().vmSnapshotList(this.name);
        if (list == null) {
            return new Snapshot[0];
        }
        String current = VMAPI.getInstance().vmSnapshotGetCurrent(this.name);
        ArrayList<Snapshot> sslist = new ArrayList<Snapshot>();
        for (String ss_str : list) {
            String[] fs = ss_str.split("\t", -1);
            if (fs.length < 3) {
                JFLog.log("VM:snapshotList:invalid entry:" + ss_str);
                continue;
            }
            Snapshot ss = new Snapshot();
            ss.name = fs[0];
            ss.desc = fs[1];
            ss.parent = fs[2];
            ss.current = current != null && ss.name.equals(current);
            sslist.add(ss);
        }
        int cnt = sslist.size();
        int ic = 0;
        while (ic < cnt) {
            Snapshot child = (Snapshot)sslist.get(ic);
            if (child.parent.length() == 0) {
                ++ic;
                continue;
            }
            boolean moved = false;
            for (int ip = 0; ip < cnt; ++ip) {
                Snapshot parent = (Snapshot)sslist.get(ip);
                if (!child.parent.equals(parent.name)) continue;
                boolean under = false;
                for (int ix = ip + 1; ix < cnt; ++ix) {
                    if (ix == ic) {
                        under = true;
                        break;
                    }
                    Snapshot unsub = (Snapshot)sslist.get(ix);
                    if (!unsub.parent.equals(child.parent)) break;
                }
                if (under) continue;
                sslist.remove(ic);
                if (ic < ip) {
                    --ip;
                }
                sslist.add(ip + 1, child);
                moved = true;
                break;
            }
            if (moved) continue;
            ++ic;
        }
        return sslist.toArray(new Snapshot[sslist.size()]);
    }

    public int snapshotCount() {
        return this.snapshotList().length;
    }

    public Snapshot snapshotGetByName(String snapshot) {
        Snapshot[] sses;
        for (Snapshot ss : sses = this.snapshotList()) {
            if (!ss.name.equals(snapshot)) continue;
            return ss;
        }
        return null;
    }

    public boolean snapshotExists() {
        return VMAPI.getInstance().vmSnapshotExists(this.name);
    }

    public Snapshot snapshotGetCurrent() {
        String ss = VMAPI.getInstance().vmSnapshotGetCurrent(this.name);
        if (ss == null) {
            return null;
        }
        return this.snapshotGetByName(ss);
    }

    public boolean snapshotRestore(String name) {
        Snapshot ss = this.snapshotGetByName(name);
        if (ss == null) {
            JFLog.log("Error:VM:Snapshot not found:" + name);
            return false;
        }
        return VMAPI.getInstance().vmSnapshotRestore(this.name, name);
    }

    public boolean snapshotDelete(String name) {
        return VMAPI.getInstance().vmSnapshotDelete(this.name, name);
    }

    public boolean hasSnapshot() {
        return this.snapshotCount() > 0;
    }

    private String snapshotCreateXML(String name, String desc) {
        Hardware hardware = this.loadHardware();
        if (hardware == null) {
            JFLog.log("Error:VM.snapshotCreateXML():unable to load hardware");
            return null;
        }
        StringBuilder xml2 = new StringBuilder();
        xml2.append("<domainsnapshot>");
        xml2.append("<name>" + name + "</name>");
        xml2.append("<description>" + desc + "</description>");
        xml2.append("<disks>");
        for (Disk disk : hardware.disks) {
            if (disk.type == 2) continue;
            xml2.append("<disk name='" + disk.target_dev + "' snapshot='external'>");
            String ssfile = disk.getSnapshotPath(name);
            xml2.append("<source file='" + ssfile + "'/>");
            xml2.append("</disk>");
        }
        xml2.append("</disks>");
        xml2.append("</domainsnapshot>");
        return xml2.toString();
    }

    private static String createXML(VirtualMachine vm, Hardware hardware, VMProvider provider) {
        vm.vnc = provider.getVNCPort(hardware.name);
        String hostname = provider.getServerHostname();
        StringBuilder xml2 = new StringBuilder();
        xml2.append("<domain type='kvm'>");
        xml2.append("<name>" + hardware.name + "</name>");
        xml2.append("<uuid>" + vm.uuid + "</uuid>");
        xml2.append("<genid>" + hardware.genid + "</genid>");
        xml2.append("<title>" + hardware.name + "</title>");
        xml2.append("<description>");
        xml2.append("pool=" + hardware.pool);
        xml2.append(";folder=" + hardware.folder);
        xml2.append(";name=" + hardware.name);
        xml2.append(";uuid=" + vm.uuid);
        xml2.append(";vnc=" + vm.vnc);
        xml2.append("</description>");
        if (hardware.os == 1) {
            xml2.append("<clock offset='localtime'/>");
        } else {
            xml2.append("<clock offset='utc'/>");
        }
        xml2.append("<os");
        if (hardware.bios_efi) {
            xml2.append(" firmware='efi'");
        }
        xml2.append(">");
        xml2.append("<type arch='x86_64' machine='" + hardware.machine + "'>hvm</type>");
        if (hardware.bios_secure) {
            xml2.append("<loader secure='yes'/>");
        }
        if (hardware.bios_efi) {
            xml2.append("<nvram type='file'>");
            xml2.append("<source file='/volumes/" + hardware.pool + "/" + hardware.folder + "/" + hardware.name + ".nvram'/>");
            xml2.append("</nvram>");
        }
        xml2.append("<bootmenu enable='yes' timeout='3000'/>");
        xml2.append("<smbios mode='emulate'/>");
        xml2.append("</os>");
        xml2.append("<vcpu>" + hardware.cores + "</vcpu>");
        xml2.append("<cpu>");
        xml2.append(" <topology sockets='1' dies='1' clusters='1' cores='" + hardware.cores + "' threads='1'/>");
        xml2.append("</cpu>");
        xml2.append(hardware.memory.toMemoryXML());
        xml2.append("<features>");
        xml2.append("<acpi/>");
        xml2.append("<apic/>");
        xml2.append("<pae/>");
        xml2.append("</features>");
        xml2.append("<devices>");
        if (hardware.tpm != 0) {
            xml2.append("<tpm model='tpm-tis'>");
            xml2.append(" <backend type='emulator' version='" + hardware.getTPMVersion() + "'/>");
            xml2.append("</tpm>");
        }
        for (Controller c : hardware.controllers) {
            xml2.append(c.toXML());
        }
        xml2.append("<input type='keyboard' bus='usb'/>");
        xml2.append("<input type='mouse' bus='usb'/>");
        xml2.append("<audio id='1' type='none'/>");
        xml2.append("<video>");
        xml2.append("<model type='" + hardware.video + "' vram='" + hardware.vram + "' heads='1'>");
        xml2.append("</model>");
        if (hardware.video_3d_accel) {
            xml2.append("<acceleration accel3d='yes'/>");
        }
        xml2.append("</video>");
        if (vm.vnc != -1) {
            xml2.append("<graphics type='vnc' port='" + vm.vnc + "' autoport='no' sharePolicy='allow-exclusive' passwd='" + provider.getVNCPassword() + "'>");
            xml2.append("<listen type='address' address='127.0.0.1'/>");
            xml2.append("</graphics>");
        }
        if (hardware.disks != null) {
            for (Disk drive : hardware.disks) {
                xml2.append(drive.getHardwareXML(hardware.os));
            }
        }
        if (hardware.networks != null) {
            for (Network nic : hardware.networks) {
                int vlan = provider.getVLAN(nic.network);
                NetworkBridge bridge = provider.getBridge(nic.network);
                xml2.append(nic.toXML(bridge, vlan));
            }
        }
        if (hardware.devices != null) {
            for (Device device : hardware.devices) {
                xml2.append(device.toXML());
            }
        }
        xml2.append("</devices>");
        xml2.append("</domain>");
        return xml2.toString();
    }

    public static void main(String[] args) {
        VirtualMachine vm = new VirtualMachine("pool", "example", "example", JF.generateUUID(), 5901);
        Disk disk = new Disk();
        disk.pool = "pool";
        disk.folder = "example";
        disk.name = "disk";
        disk.type = 0;
        disk.target_dev = "sda";
        disk.target_bus = "scsi";
        Network nw = new Network("servers", "vmxnet3", MAC.generate());
        Hardware hw = new Hardware("pool", "example", "example", 1, 4, new Size(4, 3));
        hw.disks.add(disk);
        hw.networks.add(nw);
        System.out.println(VirtualMachine.createXML(vm, hw, new VMProvider(){

            @Override
            public int getVLAN(String name) {
                return 1;
            }

            @Override
            public NetworkBridge getBridge(String name) {
                return new NetworkBridge("virbr0", "os", "eth0");
            }

            @Override
            public int getVNCPort(String name) {
                return 5901;
            }

            @Override
            public String getVNCPassword() {
                return "password";
            }

            @Override
            public String getServerHostname() {
                return "127.0.0.1";
            }

            @Override
            public boolean addsshkey(String host, String key) {
                return false;
            }
        }));
    }
}

