/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.TextComponent;

public class TextField
extends TextComponent {
    public boolean password;

    public TextField(String text) {
        this.text = text;
        this.addEvent("onchange", "onTextChange(event, this);");
        this.addEvent("onkeyup", "onTextChange(event, this);");
        this.setClass("textfield");
    }

    @Override
    public String html() {
        return "<input" + this.getAttrs() + " value='" + this.text + "'>";
    }

    @Override
    public void update() {
        this.sendEvent("setvalue", new String[]{"value=" + this.text});
    }

    public void setPassword(boolean state) {
        if (state) {
            this.addAttr("type", "password");
        } else {
            this.removeAttr("type");
        }
    }

    @Override
    public void onChanged(String[] args) {
        int idx = args[0].indexOf("=");
        this.text = this.destringify(args[0].substring(idx + 1));
        super.onChanged(args);
    }
}

