/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Button;
import javaforce.webui.Icon;
import javaforce.webui.Resource;
import javaforce.webui.tasks.Status;

public class UploadButton
extends Button {
    public UploadButton(String text) {
        super(text);
    }

    public UploadButton(Resource img) {
        super(img);
    }

    public UploadButton(Icon icon) {
        super(icon);
    }

    public UploadButton(Resource img, String text) {
        super(img, text);
    }

    public UploadButton(Icon icon, String text) {
        super(icon, text);
    }

    @Override
    public void init() {
        super.init();
        this.setClass("upload");
    }

    public String getUploadFolder() {
        return this.client.getUploadFolder();
    }

    public void setUploadFolder(String folder) {
        this.client.setUploadFolder(folder);
    }

    public Status getUploadStatus() {
        return this.client.getUploadStatus();
    }

    public void setUploadStatus(Status status) {
        this.client.setUploadStatus(status);
    }

    @Override
    public String html() {
        StringBuilder html = new StringBuilder();
        html.append("<form method='post' id='f" + this.id + "' enctype='multipart/form-data' target='upload'>");
        html.append("<input type='hidden' id='s" + this.id + "' name='size'>");
        html.append("<input type='hidden' name='client' id='c" + this.id + "' value='" + this.client.hash + "'>");
        html.append("<input type='file' name='file' id='i" + this.id + "' style='display: none;' onchange=\"onchangeUpload(event, this, '" + this.id + "');\">");
        html.append("<label for='i" + this.id + "'" + this.getAttrs() + ">");
        if (this.img != null) {
            html.append(this.img.html());
        }
        if (this.icon != null) {
            html.append(this.icon.html());
        }
        if (this.text != null) {
            html.append(this.text);
        }
        html.append("</label>");
        html.append("</form>");
        return html.toString();
    }
}

