/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import javaforce.access.User;
import javaforce.webui.Button;
import javaforce.webui.Color;
import javaforce.webui.Component;
import javaforce.webui.GridLayout;
import javaforce.webui.Label;
import javaforce.webui.PopupPanel;
import javaforce.webui.Row;
import javaforce.webui.TextField;
import javaforce.webui.WebUIClient;

public class ResetPasswordPanel
extends PopupPanel {
    private TextField pass1;
    private TextField pass2;
    private User user;

    public ResetPasswordPanel(String title, WebUIClient client) {
        super(title);
        this.setModal(true);
        GridLayout grid = new GridLayout(2, 0, new int[]{3, 1});
        this.add(grid);
        Component[] componentArray = new Component[2];
        componentArray[0] = new Label("Password");
        this.pass1 = new TextField("");
        componentArray[1] = this.pass1;
        grid.addRow(componentArray);
        Component[] componentArray2 = new Component[2];
        componentArray2[0] = new Label("Confirm Password");
        this.pass2 = new TextField("");
        componentArray2[1] = this.pass2;
        grid.addRow(componentArray2);
        this.pass1.setPassword(true);
        this.pass2.setPassword(true);
        Row row = new Row();
        this.add(row);
        Label msg = new Label("");
        msg.setColor(Color.red);
        row.add(msg);
        row = new Row();
        this.add(row);
        Button accept = new Button("Reset");
        row.add(accept);
        Button cancel = new Button("Cancel");
        row.add(cancel);
        accept.addClickListener((event, cmp) -> {
            String p1 = this.pass1.getText();
            String p2 = this.pass2.getText();
            if (p1.length() < 4) {
                msg.setText("Password too short");
                return;
            }
            if (!p1.equals(p2)) {
                msg.setText("Passwords do not match");
                return;
            }
            client.getAccessControl().setUserPassword(this.user.name, p1);
            this.setVisible(false);
        });
        cancel.addClickListener((event, cmp) -> this.setVisible(false));
    }

    public void set(User user) {
        this.user = user;
        this.pass1.setText("");
        this.pass2.setText("");
    }
}

