/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.SSH;
import javaforce.ansi.client.ANSI;
import javaforce.ansi.client.Screen;
import javaforce.ansi.client.TelnetDecoder;
import javaforce.ansi.client.UTF8;
import javaforce.io.ComPort;
import javaforce.jni.lnx.LnxPty;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.webui.Component;
import javaforce.webui.Panel;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;
import javaforce.webui.event.KeyDown;
import javaforce.webui.event.KeyEvent;
import javaforce.webui.event.MouseDown;
import javaforce.webui.event.MouseEvent;
import javaforce.webui.event.Resized;

public class TerminalPanel
extends Panel
implements Screen,
Resized,
KeyDown,
MouseDown {
    public static boolean debug = false;
    private Term term;
    private String[] cmd;
    private ANSI ansi;
    private TelnetDecoder telnet;
    private UTF8 utf8;
    private InputStream in;
    private OutputStream out;
    private Reader reader;
    private Timer timer;
    private boolean active;
    private static final int bufSize = 256;
    private static final int fontSizeX = 9;
    private static final int fontSizeY = 18;
    byte[] char2byte = new byte[256];
    char[] byte2char = new char[256];
    private boolean requested_size;
    private int codelen;
    private final char IAC = (char)255;
    private final char ESC = (char)27;
    private char[] code = new char[256];
    private int sx = 80;
    private int sy = 25;
    private int fc = 0;
    private int bc = 0xFFFFFF;
    private int cx;
    private int cy;
    private Object cursorLock = new Object();
    private boolean cursorShown;
    private int cursorCounter = 500;
    private int y1 = 0;
    private int y2 = 24;
    private boolean eol;
    private boolean autowrap = true;
    private boolean blinker;
    private boolean reverse;
    private int tabStops = 8;

    public void setup(String[] cmd) {
        int cmdlen = cmd.length;
        this.cmd = new String[cmdlen + 1];
        System.arraycopy(cmd, 0, this.cmd, 0, cmdlen);
        this.setup();
        this.term = new PtyTerm(this);
    }

    public void setup(LnxPty pty) {
        this.setup();
        this.term = new PtyTerm(this, pty);
    }

    public void setup(String host, int port, String user, String pass) {
        this.setup();
        this.term = new SSHTerm(this, host, port, user, pass);
    }

    public void setup(ComPort com) {
        this.setup();
        this.term = new ComTerm(this, com);
    }

    private void setup() {
        this.removeAll();
        for (int i = 0; i < this.sy; ++i) {
            Line line = new Line(this, this.sx, this.fc, this.bc);
            this.add(line);
        }
        if (debug) {
            JFLog.log("Terminal:" + this.sx + "x" + this.sy);
        }
        ANSI.debug = debug;
    }

    public boolean connect() {
        if (this.active) {
            return true;
        }
        this.active = true;
        this.ansi = new ANSI(this, true);
        this.telnet = new TelnetDecoder();
        this.utf8 = new UTF8();
        if (this.term.connect()) {
            this.reader = new Reader(this);
            this.reader.start();
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ TerminalPanel this$0;
                {
                    TerminalPanel terminalPanel = this$0;
                    Objects.requireNonNull(terminalPanel);
                    this.this$0 = terminalPanel;
                }

                @Override
                public void run() {
                    this.this$0.flashCursor();
                }
            }, 100L, 100L);
            return true;
        }
        this.print("connect() failed!".toCharArray());
        return false;
    }

    @Override
    public void init() {
        super.init();
        this.addKeyDownListenerPreventDefault(this);
        this.addMouseDownListener(this);
        this.addResizedListener(this);
        if (!this.hasSize()) {
            this.setMaxWidth();
            this.setMaxHeight();
        }
        this.setFocusable();
    }

    public void disconnect() {
        this.active = false;
        this.clrscr();
        if (this.term != null) {
            this.term.disconnect();
            this.term = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void setDefaultSize() {
        this.setSize(this.sx * 9, this.sy * 18);
    }

    @Override
    public void onResized(Component comp, int width, int height) {
        try {
            if (debug) {
                JFLog.log("onresized:" + width + "x" + height);
            }
            this.sx = width / 9;
            if (this.sx < 1) {
                this.sx = 1;
            }
            this.sy = height / 18;
            if (this.sy < 1) {
                this.sy = 1;
            }
            this.y1 = 0;
            this.y2 = this.sy - 1;
            this.term.setSize();
            this.clampCursor();
            this.setLines();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void clampCursor() {
        if (this.cx >= this.sx) {
            this.cx = this.sx - 1;
        }
        if (this.cy >= this.sy) {
            this.cy = this.sy - 1;
        }
    }

    private void setLines() {
        int cnt = this.count();
        if (cnt > this.sy) {
            while (cnt > this.sy) {
                this.remove(cnt - 1);
                --cnt;
            }
        } else {
            while (cnt < this.sy) {
                this.add(new Line(this, this.sx, this.fc, this.bc));
                ++cnt;
            }
        }
        for (int i = 0; i < cnt; ++i) {
            Line line = (Line)this.get(i);
            line.setlen(this.sx, this.fc, this.bc);
        }
        this.update();
    }

    @Override
    public void onKeyDown(KeyEvent event, Component comp) {
        if (event.keyChar == '\u0000') {
            int code = event.keyCode;
            int mods = 0;
            if (event.altKey) {
                mods |= 0x200;
            }
            if (event.ctrlKey) {
                mods |= 0x80;
            }
            if (event.shiftKey) {
                mods |= 0x40;
            }
            if (debug) {
                JFLog.log("key code=" + code + ",mods=" + mods);
            }
            switch (code) {
                case 8: {
                    break;
                }
                case 10: {
                    code = 13;
                    break;
                }
                case 13: {
                    break;
                }
                case 37: {
                    this.ansi.keyPressed(37, mods, this);
                    return;
                }
                case 39: {
                    this.ansi.keyPressed(39, mods, this);
                    return;
                }
                case 38: {
                    this.ansi.keyPressed(38, mods, this);
                    return;
                }
                case 40: {
                    this.ansi.keyPressed(40, mods, this);
                    return;
                }
                case 27: {
                    break;
                }
                case 9: {
                    break;
                }
                case 36: {
                    this.ansi.keyPressed(36, mods, this);
                    return;
                }
                case 35: {
                    this.ansi.keyPressed(35, mods, this);
                    return;
                }
                case 33: {
                    this.ansi.keyPressed(33, mods, this);
                    return;
                }
                case 34: {
                    this.ansi.keyPressed(34, mods, this);
                    return;
                }
                case 127: {
                    this.ansi.keyPressed(127, mods, this);
                    return;
                }
                case 19: {
                    this.ansi.keyPressed(19, mods, this);
                    return;
                }
                case 112: {
                    this.ansi.keyPressed(112, mods, this);
                    return;
                }
                case 113: {
                    this.ansi.keyPressed(113, mods, this);
                    return;
                }
                case 114: {
                    this.ansi.keyPressed(114, mods, this);
                    return;
                }
                case 115: {
                    this.ansi.keyPressed(115, mods, this);
                    return;
                }
                case 116: {
                    this.ansi.keyPressed(116, mods, this);
                    return;
                }
                case 117: {
                    this.ansi.keyPressed(117, mods, this);
                    return;
                }
                case 118: {
                    this.ansi.keyPressed(118, mods, this);
                    return;
                }
                case 119: {
                    this.ansi.keyPressed(119, mods, this);
                    return;
                }
                case 120: {
                    this.ansi.keyPressed(120, mods, this);
                    return;
                }
                case 121: {
                    this.ansi.keyPressed(121, mods, this);
                    return;
                }
                case 122: {
                    this.ansi.keyPressed(122, mods, this);
                    return;
                }
                case 123: {
                    this.ansi.keyPressed(123, mods, this);
                    return;
                }
                default: {
                    if (debug) {
                        JFLog.log("unknown key code:" + code);
                    }
                    return;
                }
            }
            char[] buf = new char[]{(char)code};
            this.output(buf);
        } else {
            if (debug) {
                JFLog.log("key char=" + event.keyChar);
            }
            char[] buf = new char[]{event.keyChar};
            this.output(buf);
        }
    }

    @Override
    public void onMouseDown(MouseEvent me, Component comp) {
        this.setFocus();
    }

    private byte[] char2byte(char[] buf, int buflen) {
        if (this.char2byte.length != buflen) {
            this.char2byte = new byte[buflen];
        }
        for (int a = 0; a < buflen; ++a) {
            this.char2byte[a] = (byte)buf[a];
        }
        return this.char2byte;
    }

    private char[] byte2char(byte[] buf, int buflen) {
        for (int a = 0; a < buflen; ++a) {
            this.byte2char[a] = (char)(buf[a] & 0xFF);
        }
        return this.byte2char;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashCursor() {
        if (!this.client.isConnected()) {
            this.disconnect();
            return;
        }
        if (!this.requested_size && this.isLoaded()) {
            this.requestSize();
            this.requested_size = true;
        }
        Object object = this.cursorLock;
        synchronized (object) {
            this.cursorCounter -= 100;
            if (this.cursorCounter <= 0) {
                this.cursorShown = !this.cursorShown;
                this.updateCursor();
                this.cursorCounter = 500;
                this.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursor() {
        Object object = this.cursorLock;
        synchronized (object) {
            Line line = this.getLine(this.cy);
            line.dirty = true;
            this.cursorCounter = 500;
        }
    }

    public void input(String msg) {
        this.input(msg.toCharArray(), msg.length());
    }

    public void input(char[] buf, int buflen) {
        if (debug) {
            this.writeArray(" input", buf, 0, buflen);
        }
        char[] newbuf = new char[buflen];
        int newbuflen = 0;
        for (int a = 0; a < buflen; ++a) {
            if (this.codelen == 0) {
                if (buf[a] == '\u00ff' || buf[a] == '\u001b' || this.utf8.isUTF8(buf[a])) {
                    if (newbuflen > 0) {
                        this.print(newbuf, newbuflen);
                        newbuflen = 0;
                    }
                    this.codelen = 1;
                    this.code[0] = buf[a];
                    continue;
                }
                newbuf[newbuflen++] = this.ansi.encodeChar(buf[a]);
                continue;
            }
            if (this.codelen == this.code.length) {
                if (debug) {
                    this.writeArray("  code overflow", this.code, 0, this.code.length);
                }
                this.codelen = 0;
                continue;
            }
            this.code[this.codelen++] = buf[a];
            if (this.codelen == 2 && this.code[0] == '\u001b' && this.code[1] == '\u001b') {
                this.codelen = 1;
            }
            if (this.code[0] == '\u00ff') {
                if (!this.telnet.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (this.code[0] == '\u001b') {
                if (!this.ansi.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (!this.utf8.decode(this.code, this.codelen, this)) continue;
            this.codelen = 0;
            newbuf[newbuflen++] = this.utf8.char16;
        }
        if (newbuflen > 0) {
            this.print(newbuf, newbuflen);
        }
        this.update();
    }

    public void print(char[] buf) {
        this.print(buf, buf.length);
    }

    public void print(char[] buf, int buflen) {
        block6: for (int i = 0; i < buflen; ++i) {
            switch (buf[i]) {
                case '\b': 
                case '\u007f': {
                    this.decPosX();
                    continue block6;
                }
                case '\t': {
                    int ts = (this.getx() - 1) % this.tabStops;
                    for (int t = 0; t < this.tabStops - ts; ++t) {
                        if (this.eol) {
                            this.incPosX();
                        }
                        this.incPosX();
                    }
                    continue block6;
                }
                case '\n': {
                    this.incPosY();
                    continue block6;
                }
                case '\r': {
                    this.gotoPos(1, this.gety());
                    continue block6;
                }
                default: {
                    if (buf[i] < ' ' && buf[i] >= '\u0000') continue block6;
                    if (this.eol) {
                        this.incPosX();
                    }
                    this.setChar(this.cx + 1, this.cy + 1, buf[i]);
                    this.incPosX();
                }
            }
        }
    }

    private void update() {
        int cnt = this.count();
        for (int y = 0; y < cnt; ++y) {
            Line line = (Line)this.get(y);
            if (line == null) continue;
            line.y = y;
            if (!line.dirty) continue;
            line.dirty = false;
            if (line.sendEvent("replace", new String[]{"html=" + line.html()})) continue;
            this.disconnect();
            return;
        }
    }

    private Line getLine(int y) {
        int cnt = this.count();
        int off = cnt - this.sy + y;
        if (off < 0) {
            off = 0;
        }
        if (off >= cnt) {
            off = cnt - 1;
        }
        return (Line)this.get(off);
    }

    private void decPosX() {
        if (this.cx > 0) {
            this.eol = false;
            --this.cx;
        } else {
            this.cx = this.sx - 1;
            this.decPosY();
            this.eol = true;
        }
    }

    private void decPosY() {
        if (this.cy > 0) {
            this.updateCursor();
            --this.cy;
            this.updateCursor();
        }
    }

    private void incPosX() {
        if (this.eol) {
            if (!this.autowrap) {
                return;
            }
            this.cx = 0;
            this.incPosY();
            this.eol = false;
        } else if (this.cx < this.sx - 1) {
            ++this.cx;
        } else {
            this.eol = true;
        }
    }

    private void incPosY() {
        if (this.cy < this.y2) {
            this.updateCursor();
            ++this.cy;
            this.updateCursor();
        } else {
            this.scrollUp(1);
        }
    }

    public void writeArray(byte[] tmp) {
        StringBuilder msg = new StringBuilder();
        msg.append("output:" + tmp.length + ":");
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] < 32) {
                msg.append("{");
                msg.append(Integer.toString(tmp[i] & 0xFF));
                msg.append("}");
                continue;
            }
            msg.append(tmp[i]);
        }
        JFLog.log(msg.toString());
    }

    public void writeArray(String txt, char[] buf, int off, int buflen) {
        StringBuilder msg = new StringBuilder();
        msg.append(txt + ":" + buflen + ":");
        for (int i = 0; i < buflen; ++i) {
            if (buf[i] < ' ') {
                msg.append("{");
                msg.append(Integer.toString(buf[i]));
                msg.append("}");
                continue;
            }
            msg.append(buf[i]);
        }
        JFLog.log(msg.toString());
    }

    @Override
    public void output(char[] buf) {
        byte[] tmp = this.char2byte(buf, buf.length);
        if (debug) {
            this.writeArray(tmp);
        }
        if (!this.active) {
            return;
        }
        try {
            this.out.write(tmp);
            this.out.flush();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public int getForeColor() {
        return this.fc;
    }

    @Override
    public int getBackColor() {
        return this.bc;
    }

    @Override
    public int getsx() {
        return this.sx;
    }

    @Override
    public int getsy() {
        return this.sy;
    }

    @Override
    public int getx() {
        return this.cx + 1;
    }

    @Override
    public int gety() {
        return this.cy + 1;
    }

    @Override
    public int gety1() {
        return this.y1 + 1;
    }

    @Override
    public int gety2() {
        return this.y2 + 1;
    }

    @Override
    public void sety1(int v) {
        this.y1 = v - 1;
    }

    @Override
    public void sety2(int v) {
        this.y2 = v - 1;
    }

    @Override
    public void scrollUp(int cnt) {
        this.updateCursor();
        for (int i = 0; i < cnt; ++i) {
            this.remove(this.y1);
            this.add(this.y2, new Line(this, this.sx, this.fc, this.bc));
        }
        this.updateCursor();
    }

    @Override
    public void scrollDown(int cnt) {
        this.updateCursor();
        for (int i = 0; i < cnt; ++i) {
            this.remove(this.y2);
            this.add(this.y1, new Line(this, this.sx, this.fc, this.bc));
        }
        this.updateCursor();
    }

    @Override
    public void delete() {
        Line line = this.getLine(this.cy);
        for (int p = this.cx; p < this.sx - 1; ++p) {
            line.chs[p] = line.chs[p + 1];
            line.fcs[p] = line.fcs[p + 1];
            line.bcs[p] = line.bcs[p + 1];
        }
        line.chs[this.sx - 1] = 32;
        line.fcs[this.sx - 1] = this.fc;
        line.bcs[this.sx - 1] = this.bc;
    }

    @Override
    public void insert() {
        Line line = this.getLine(this.cy);
        for (int p = this.sx - 2; p >= this.cx; --p) {
            line.chs[p + 1] = line.chs[p];
            line.fcs[p + 1] = line.fcs[p];
            line.bcs[p + 1] = line.bcs[p];
        }
        line.chs[this.cx] = 32;
        line.fcs[this.cx] = this.fc;
        line.bcs[this.cx] = this.bc;
    }

    @Override
    public void gotoPos(int x, int y) {
        if (debug) {
            JFLog.log("gotoPos:" + x + "," + y);
        }
        this.updateCursor();
        this.cx = x - 1;
        if (this.cx < 0) {
            this.cx = 0;
        }
        if (this.cx >= this.sx) {
            this.cx = this.sx - 1;
        }
        this.cy = y - 1;
        if (this.cy < 0) {
            this.cy = 0;
        }
        if (this.cy >= this.sy) {
            this.cy = this.sy - 1;
        }
        this.eol = false;
        this.updateCursor();
    }

    @Override
    public void setChar(int x, int y, char ch) {
        Line line;
        if (debug) {
            JFLog.log("setChar:" + x + "," + y + ":" + ch + ":" + ch);
        }
        --x;
        if ((line = this.getLine(--y)) == null) {
            return;
        }
        if (x < 0 || x >= line.len) {
            return;
        }
        line.chs[x] = ch;
        if (this.reverse) {
            line.fcs[x] = this.bc;
            line.bcs[x] = this.fc;
        } else {
            line.fcs[x] = this.fc;
            line.bcs[x] = this.bc;
        }
        line.blink = this.blinker;
        line.dirty = true;
    }

    @Override
    public void setAutoWrap(boolean state) {
        this.autowrap = state;
    }

    @Override
    public void clrscr() {
        this.updateCursor();
        int cnt = this.count();
        for (int i = 0; i < cnt; ++i) {
            Line line = (Line)this.get(i);
            line.clear(this.fc, this.bc);
        }
        this.cx = 0;
        this.cy = 0;
        this.updateCursor();
    }

    @Override
    public void setBlinker(boolean state) {
        this.blinker = state;
    }

    @Override
    public void setReverse(boolean state) {
        this.reverse = state;
    }

    @Override
    public void setForeColor(int newClr) {
        if (debug) {
            JFLog.log("fc=" + newClr);
        }
        this.fc = newClr & 0xFFFFFF;
    }

    @Override
    public void setBackColor(int newClr) {
        if (debug) {
            JFLog.log("bc=" + newClr);
        }
        this.bc = newClr & 0xFFFFFF;
    }

    @Override
    public String getTermType() {
        return "vt100";
    }

    public static void main(String[] args) {
        new WebUIServer().start(new Test(), 8080);
    }

    private class PtyTerm
    implements Term {
        private LnxPty pty;
        final /* synthetic */ TerminalPanel this$0;

        public PtyTerm(TerminalPanel terminalPanel) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
        }

        public PtyTerm(TerminalPanel terminalPanel, LnxPty pty) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
            this.pty = pty;
        }

        @Override
        public boolean connect() {
            try {
                if (this.pty == null) {
                    this.pty = LnxPty.exec(this.this$0.cmd[0], this.this$0.cmd, LnxPty.makeEnvironment(new String[]{"TERM=xterm"}));
                    if (this.pty == null) {
                        throw new Exception("pty failed");
                    }
                }
                this.this$0.in = new InputStream(this){
                    final /* synthetic */ PtyTerm this$1;
                    {
                        PtyTerm ptyTerm = this$1;
                        Objects.requireNonNull(ptyTerm);
                        this.this$1 = ptyTerm;
                    }

                    @Override
                    public int read() {
                        return -1;
                    }

                    @Override
                    public int read(byte[] buf) {
                        return this.this$1.pty.read(buf);
                    }
                };
                this.this$0.out = new OutputStream(this){
                    final /* synthetic */ PtyTerm this$1;
                    {
                        PtyTerm ptyTerm = this$1;
                        Objects.requireNonNull(ptyTerm);
                        this.this$1 = ptyTerm;
                    }

                    @Override
                    public void write(int x) {
                    }

                    @Override
                    public void write(byte[] buf) {
                        this.this$1.pty.write(buf);
                    }
                };
                this.setSize();
                return true;
            }
            catch (Exception e) {
                JFLog.log(e);
                this.this$0.print(e.toString().toCharArray(), e.toString().length());
                return false;
            }
        }

        @Override
        public void disconnect() {
            if (this.pty != null) {
                this.pty.close();
                this.pty = null;
            }
        }

        @Override
        public void setSize() {
            if (debug) {
                JFLog.log("TerminalPanel.SetSize:" + this.this$0.sx + "x" + this.this$0.sy);
            }
            if (this.pty != null) {
                try {
                    this.pty.setSize(this.this$0.sx, this.this$0.sy);
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private static interface Term {
        public boolean connect();

        public void disconnect();

        public void setSize();
    }

    private class SSHTerm
    implements Term {
        private SSH client;
        private String host;
        private int port;
        private String user;
        private String pass;
        final /* synthetic */ TerminalPanel this$0;

        public SSHTerm(TerminalPanel terminalPanel, String host, int port, String user, String pass) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
            this.client = new SSH();
            this.host = host;
            this.port = port;
            this.user = user;
            this.pass = pass;
        }

        @Override
        public boolean connect() {
            if (this.client == null) {
                this.client = new SSH();
            }
            SSH.Options ops = new SSH.Options();
            ops.username = this.user;
            ops.password = this.pass;
            if (!this.client.connect(this.host, this.port, ops)) {
                return false;
            }
            this.this$0.in = this.client.getInputStream();
            this.this$0.out = this.client.getOutputStream();
            this.setSize();
            return true;
        }

        @Override
        public void disconnect() {
            if (this.client == null) {
                return;
            }
            this.client.disconnect();
            this.client = null;
        }

        @Override
        public void setSize() {
            if (debug) {
                JFLog.log("TerminalPanel.SetSize:" + this.this$0.sx + "x" + this.this$0.sy);
            }
            try {
                this.client.setSize(this.this$0.sx, this.this$0.sy);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private class ComTerm
    implements Term {
        private ComPort com;
        final /* synthetic */ TerminalPanel this$0;

        public ComTerm(TerminalPanel terminalPanel, ComPort com) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
            this.com = com;
        }

        @Override
        public boolean connect() {
            this.this$0.in = new InputStream(this){
                final /* synthetic */ ComTerm this$1;
                {
                    ComTerm comTerm = this$1;
                    Objects.requireNonNull(comTerm);
                    this.this$1 = comTerm;
                }

                @Override
                public int read() {
                    return -1;
                }

                @Override
                public int read(byte[] buf) {
                    return this.this$1.com.read(buf);
                }
            };
            this.this$0.out = new OutputStream(this){
                final /* synthetic */ ComTerm this$1;
                {
                    ComTerm comTerm = this$1;
                    Objects.requireNonNull(comTerm);
                    this.this$1 = comTerm;
                }

                @Override
                public void write(int x) {
                }

                @Override
                public void write(byte[] buf) {
                    this.this$1.com.write(buf);
                }
            };
            return true;
        }

        @Override
        public void disconnect() {
            if (this.com == null) {
                return;
            }
            this.com.close();
            this.com = null;
        }

        @Override
        public void setSize() {
        }
    }

    private class Line
    extends Component {
        public boolean dirty;
        public boolean blink;
        private int len;
        private char[] chs;
        private int[] fcs;
        private int[] bcs;
        public int y;
        final /* synthetic */ TerminalPanel this$0;

        public Line(TerminalPanel terminalPanel, int len, int fc, int bc) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
            this.len = len;
            this.chs = new char[len];
            this.fcs = new int[len];
            this.bcs = new int[len];
            for (int i = 0; i < len; ++i) {
                this.fcs[i] = fc;
                this.bcs[i] = bc;
                this.chs[i] = 32;
            }
            this.dirty = true;
        }

        @Override
        public String html() {
            int fc = -1;
            int bc = -1;
            StringBuilder html = new StringBuilder();
            html.append("<div");
            html.append(this.getAttrs());
            html.append(">");
            block5: for (int x = 0; x < this.len; ++x) {
                int nfc = this.fcs[x];
                int nbc = this.bcs[x];
                if (this.this$0.cursorShown && this.y == this.this$0.cy && x == this.this$0.cx) {
                    nbc ^= 0xFFFFFF;
                }
                if (fc != nfc || bc != nbc) {
                    fc = nfc;
                    bc = nbc;
                    if (x > 0) {
                        html.append("</pre>");
                    }
                    html.append("<pre style='");
                    html.append("color: #" + String.format("%06x", fc) + ";");
                    html.append("background-color: #" + String.format("%06x", bc) + ";");
                    html.append("'>");
                }
                char ch = this.chs[x];
                switch (ch) {
                    case '<': {
                        html.append("&lt;");
                        continue block5;
                    }
                    case '>': {
                        html.append("&gt;");
                        continue block5;
                    }
                    case '&': {
                        html.append("&amp;");
                        continue block5;
                    }
                    default: {
                        html.append(ch);
                    }
                }
            }
            html.append("</pre>");
            html.append("</div>");
            return html.toString();
        }

        public void setlen(int len, int fc, int bc) {
            int oldlen = this.len;
            if (oldlen == len) {
                return;
            }
            this.chs = Arrays.copyOf(this.chs, len);
            this.fcs = Arrays.copyOf(this.fcs, len);
            this.bcs = Arrays.copyOf(this.bcs, len);
            for (int i = oldlen; i < len; ++i) {
                this.chs[i] = 32;
                this.fcs[i] = fc;
                this.bcs[i] = bc;
            }
            this.len = len;
            this.dirty = true;
        }

        public void clear(int fc, int bc) {
            for (int i = 0; i < this.len; ++i) {
                this.chs[i] = 32;
                this.fcs[i] = fc;
                this.bcs[i] = bc;
            }
            this.dirty = true;
        }

        @Override
        public String toString() {
            StringBuilder txt = new StringBuilder();
            for (int i = 0; i < this.len; ++i) {
                txt.append(this.chs[i]);
            }
            return txt.toString();
        }
    }

    private class Reader
    extends Thread {
        final /* synthetic */ TerminalPanel this$0;

        private Reader(TerminalPanel terminalPanel) {
            TerminalPanel terminalPanel2 = terminalPanel;
            Objects.requireNonNull(terminalPanel2);
            this.this$0 = terminalPanel2;
        }

        @Override
        public void run() {
            byte[] buf = new byte[256];
            try {
                while (this.this$0.active) {
                    int buflen = this.this$0.in.read(buf);
                    if (buflen > 0) {
                        if (debug) {
                            JFLog.log("read=" + buflen);
                        }
                        this.this$0.input(this.this$0.byte2char(buf, buflen), buflen);
                    }
                    if (buflen != 0) continue;
                    JF.sleep(100);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                this.this$0.disconnect();
            }
        }
    }

    private static class Test
    implements WebUIHandler {
        private Test() {
        }

        @Override
        public Panel getPanel(String name, HTTP.Parameters params, WebUIClient client) {
            Panel panel = new Panel();
            TerminalPanel terminal = new TerminalPanel();
            terminal.setup(new String[]{"/usr/bin/bash", "-i", "-l"});
            terminal.connect();
            panel.add(terminal);
            return panel;
        }

        @Override
        public byte[] getResource(String url, HTTP.Parameters params, WebRequest request, WebResponse response) {
            return null;
        }

        @Override
        public void clientConnected(WebUIClient client) {
        }

        @Override
        public void clientDisconnected(WebUIClient client) {
        }
    }
}

