/*
 * Decompiled with CFR 0.152.
 */
package io.github.psycotrompus.sql;

import io.github.psycotrompus.sql.FinalStep;
import io.github.psycotrompus.sql.PartialSql;
import io.github.psycotrompus.sql.SqlBuilderException;
import io.github.psycotrompus.sql.SqlJoinBuilder;
import io.github.psycotrompus.sql.SqlLimitBuilder;
import io.github.psycotrompus.sql.SqlOrder;
import io.github.psycotrompus.sql.SqlProjection;
import io.github.psycotrompus.sql.SqlTable;
import io.github.psycotrompus.sql.SqlTypeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class SqlBuilderContext
implements FinalStep {
    private final SqlProjection projection;
    private SqlTable rootTable;
    private final List<SqlJoinBuilder> joins = new ArrayList<SqlJoinBuilder>();
    private final List<SqlTypeFilter> filters = new ArrayList<SqlTypeFilter>();
    private final List<SqlOrder> orders = new ArrayList<SqlOrder>();
    private SqlLimitBuilder limit;

    SqlBuilderContext(SqlProjection projection) {
        this.projection = projection;
    }

    void setRootTable(SqlTable rootTable) {
        this.rootTable = rootTable;
    }

    void addJoin(SqlJoinBuilder join) {
        this.joins.add(join);
    }

    void addFilter(SqlTypeFilter filter) {
        this.filters.add(filter);
    }

    void addOrder(SqlOrder order) {
        this.orders.add(order);
    }

    void addLimit(SqlLimitBuilder limit) {
        this.limit = limit;
    }

    @Override
    public String build() {
        if (this.projection == null) {
            throw new SqlBuilderException("No projections specified");
        }
        if (this.rootTable == null) {
            throw new SqlBuilderException("No tables to select from.");
        }
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(this.projection.toSql());
        sql.append(" FROM ").append(this.rootTable.toSql());
        if (!this.joins.isEmpty()) {
            sql.append(" ");
            sql.append(this.joins.stream().map(SqlJoinBuilder::toSql).collect(Collectors.joining(" ")));
        }
        if (!this.filters.isEmpty()) {
            sql.append(" WHERE 1=1 AND ");
            sql.append(this.filters.stream().map(PartialSql::toSql).collect(Collectors.joining(" AND ")));
        }
        if (!this.orders.isEmpty()) {
            sql.append(" ORDER BY ");
            sql.append(this.orders.stream().map(SqlOrder::toSql).collect(Collectors.joining(", ")));
        }
        if (this.limit != null) {
            sql.append(this.limit.toSql());
        }
        return sql.append(";").toString();
    }
}

