/*
 * Decompiled with CFR 0.152.
 */
package io.github.psycotrompus.sql;

import io.github.psycotrompus.sql.PartialSql;
import io.github.psycotrompus.sql.SqlColumnFilter;
import io.github.psycotrompus.sql.SqlOrder;
import io.github.psycotrompus.sql.SqlTable;
import io.github.psycotrompus.sql.SqlTypeFilter;
import io.github.psycotrompus.sql.SqlUtils;
import io.github.psycotrompus.sql.SqlValueFilter;

public class SqlColumn
extends PartialSql {
    private final SqlTable table;
    private final String name;
    private final String alias;

    SqlColumn(SqlTable table, String name) {
        this(table, name, null);
    }

    SqlColumn(SqlTable table, String name, String alias) {
        this.table = table;
        this.name = name;
        this.alias = alias;
    }

    public SqlTypeFilter eq(String parameter) {
        return new SqlValueFilter(this, "=", ":" + parameter);
    }

    public SqlTypeFilter in(String parameter) {
        return new SqlValueFilter(this, "IN", ":" + parameter);
    }

    public SqlTypeFilter isTrue() {
        return new SqlValueFilter(this, "IS", "true");
    }

    public SqlTypeFilter isFalse() {
        return new SqlValueFilter(this, "IS", "false");
    }

    public SqlTypeFilter isNull() {
        return new SqlValueFilter(this, "IS", "null");
    }

    public SqlTypeFilter like(String parameter) {
        return new SqlValueFilter(this, "LIKE", ":" + parameter);
    }

    public SqlTypeFilter gt(String parameter) {
        return new SqlValueFilter(this, ">", ":" + parameter);
    }

    public SqlTypeFilter lt(String parameter) {
        return new SqlValueFilter(this, "<", ":" + parameter);
    }

    public SqlTypeFilter gte(String parameter) {
        return new SqlValueFilter(this, ">=", ":" + parameter);
    }

    public SqlTypeFilter lte(String parameter) {
        return new SqlValueFilter(this, "<=", ":" + parameter);
    }

    public SqlTypeFilter ne(String parameter) {
        return new SqlValueFilter(this, "<>", ":" + parameter);
    }

    public SqlTypeFilter eq(SqlColumn column) {
        return new SqlColumnFilter(this, "=", column);
    }

    public SqlTypeFilter ne(SqlColumn column) {
        return new SqlColumnFilter(this, "<>", column);
    }

    public SqlOrder asc() {
        return new SqlOrder(this, false);
    }

    public SqlOrder desc() {
        return new SqlOrder(this, true);
    }

    @Override
    String toSql() {
        if (!SqlUtils.isBlank(this.table.getAlias()) && !SqlUtils.isBlank(this.alias)) {
            return String.format("%s.%s AS %s", this.table.getAlias(), this.name, this.alias);
        }
        if (SqlUtils.isBlank(this.table.getAlias()) && !SqlUtils.isBlank(this.alias)) {
            return String.format("%s AS %s", this.name, this.alias);
        }
        if (!SqlUtils.isBlank(this.table.getAlias()) && SqlUtils.isBlank(this.alias)) {
            return String.format("%s.%s", this.table.getAlias(), this.name);
        }
        return this.name;
    }
}

