/*
 * Decompiled with CFR 0.152.
 */
package io.github.psycotrompus.sql;

import io.github.psycotrompus.sql.FromStep;
import io.github.psycotrompus.sql.JoinStep;
import io.github.psycotrompus.sql.PartialSql;
import io.github.psycotrompus.sql.SqlFromBuilder;
import io.github.psycotrompus.sql.SqlTable;
import io.github.psycotrompus.sql.SqlTypeFilter;
import io.github.psycotrompus.sql.SqlUtils;

public class SqlJoinBuilder
extends PartialSql
implements JoinStep {
    private final SqlFromBuilder fromBuilder;
    private final String joinType;
    private final SqlTable table;
    private SqlTypeFilter filter;

    public SqlJoinBuilder(SqlFromBuilder fromBuilder, String joinType, SqlTable table) {
        this.fromBuilder = fromBuilder;
        this.joinType = joinType;
        this.table = table;
    }

    @Override
    public FromStep on(SqlTypeFilter filter) {
        this.filter = filter;
        return this.fromBuilder;
    }

    @Override
    String toSql() {
        if (SqlUtils.isBlank(this.table.getAlias())) {
            throw new RuntimeException("Table alias is required.");
        }
        return String.format("%s %s ON %s", this.joinType, this.table.toSql(), this.filter.toSql());
    }
}

