/*
 * Decompiled with CFR 0.152.
 */
package io.github.psycotrompus.sql;

import io.github.psycotrompus.sql.PartialSql;
import io.github.psycotrompus.sql.SqlColumn;
import io.github.psycotrompus.sql.SqlProjection;
import io.github.psycotrompus.sql.SqlUtils;
import java.util.Arrays;
import javax.annotation.Nullable;

public class SqlTable
extends PartialSql {
    private final String schema;
    private final String table;
    private final String alias;

    public static Builder of(String table) {
        return new Builder(table);
    }

    private SqlTable(String schema, String table, String alias) {
        this.schema = schema;
        this.table = table;
        this.alias = alias;
    }

    @Nullable
    String getAlias() {
        return this.alias;
    }

    public SqlProjection asterisk() {
        return new SqlProjection(Arrays.asList(new SqlColumn(this, "*")));
    }

    public SqlColumn column(String name) {
        return new SqlColumn(this, name);
    }

    @Override
    String toSql() {
        if (!SqlUtils.isBlank(this.schema) && !SqlUtils.isBlank(this.alias)) {
            return String.format("%s.%s AS %s", this.schema, this.table, this.alias);
        }
        if (!SqlUtils.isBlank(this.schema) && SqlUtils.isBlank(this.alias)) {
            return String.format("%s.%s", this.schema, this.table);
        }
        if (SqlUtils.isBlank(this.schema) && !SqlUtils.isBlank(this.alias)) {
            return String.format("%s AS %s", this.table, this.alias);
        }
        return this.table;
    }

    public static class Builder {
        private String schema;
        private final String table;
        private String alias;

        Builder(String table) {
            this.table = table;
        }

        public Builder on(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder as(String alias) {
            this.alias = alias;
            return this;
        }

        public SqlTable build() {
            return new SqlTable(this.schema, this.table, this.alias);
        }
    }
}

