/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.batchinsert;

import com.jn.langx.util.Dates;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.sqlhelper.batchinsert.BatchInsertResult;
import com.jn.sqlhelper.batchinsert.BatchInsertTask;
import com.jn.sqlhelper.batchinsert.BatchInsertTaskFactory;
import com.jn.sqlhelper.common.connection.ConnectionFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInsertExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BatchInsertExecutor.class);
    private ConnectionFactory connFactory;
    protected Calendar start;
    private final long end;
    private final ExecutorService executor;
    private final List<Future<BatchInsertResult>> futures = new LinkedList<Future<BatchInsertResult>>();
    private BatchInsertTaskFactory taskFactory;

    public BatchInsertExecutor(long start, long end, int concurrency, ConnectionFactory connectionFactory) {
        this.start = Calendar.getInstance();
        this.start.setTimeInMillis(start);
        this.end = end;
        this.connFactory = connectionFactory;
        concurrency = concurrency > 0 ? concurrency : 1;
        this.executor = Executors.newFixedThreadPool(concurrency);
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public void setTaskFactory(BatchInsertTaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public void setStartTimeAsZero() {
        this.start.set(10, 0);
        this.start.set(12, 0);
        this.start.set(13, 0);
    }

    protected long nextTime() {
        this.start.add(10, 1);
        return this.start.getTimeInMillis();
    }

    public void startup() {
        long time;
        logger.info("startup() insert time: {}", (Object)Dates.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        while ((time = this.nextTime()) <= this.end) {
            if (logger.isInfoEnabled()) {
                logger.info(Dates.format((Date)new Date(time), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            Object task = this.taskFactory.createTask(Dates.format((Date)new Date(time), (String)"yyyy-MM-dd HH:mm:ss"), GlobalThreadLocalMap.getRandom().nextInt());
            this.submitTask((BatchInsertTask)task);
        }
    }

    private void submitTask(BatchInsertTask task) {
        task.setConnFactory(this.connFactory);
        this.futures.add(this.executor.submit(task));
    }

    public void shutdown() throws InterruptedException, ExecutionException {
        try {
            for (int i = 0; i < this.futures.size(); ++i) {
                BatchInsertResult result = this.futures.get(i).get();
                if (result.getExpectResult() == result.getRealInsertNum()) {
                    logger.info("success! time: {}", (Object)result.getTime());
                    continue;
                }
                logger.warn("failed! time: {}", (Object)result.getTime());
            }
        }
        finally {
            if (this.executor != null && !this.executor.isShutdown() && !this.executor.isTerminated()) {
                this.executor.shutdownNow();
            }
            logger.info("shutdown() insert time: {}", (Object)Dates.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }
}

