/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli;

import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.cli.utils.ProjectBanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class CLI {
    private static final String HOME_DIR_KEY = "SQLHelper-CLI.location";
    private static final String RUN_MODE_KEY = "runMode";
    private static Logger logger;
    private static final List<String> configLocations;

    public static void main(String[] args) {
        String specifiedProfiles;
        boolean devMode = Boolean.parseBoolean(System.getProperty("dev", "false"));
        System.clearProperty("dev");
        String runMode = devMode ? "dev" : "production";
        System.setProperty(RUN_MODE_KEY, runMode);
        String applicationDefaultConfigPath = Reflects.getCodeLocation(CLI.class).getPath();
        String homeDirDefault = "./..";
        if (devMode) {
            homeDirDefault = new File(applicationDefaultConfigPath).getPath();
        }
        String homeDir = System.getProperty(HOME_DIR_KEY, homeDirDefault);
        homeDir = new File(homeDir).getAbsolutePath();
        System.setProperty(HOME_DIR_KEY, homeDir);
        CLI.recordPid(homeDir);
        Files.makeDirs((String)(homeDir + File.separator + "logs"));
        logger = LoggerFactory.getLogger(CLI.class);
        String customConfigDir = "file:" + new File(homeDir).getPath() + "/config/";
        String configDirInJar = "classpath:./";
        configLocations.add(customConfigDir);
        configLocations.add(configDirInJar);
        final List activeProfiles = Collects.emptyArrayList();
        activeProfiles.add("sqlhelper-cli");
        if (devMode) {
            activeProfiles.add("dev");
        }
        if ((specifiedProfiles = System.getProperty("spring.profiles.active")) != null) {
            Pipeline.of((Object[])Strings.split((String)specifiedProfiles, (String)",")).forEach((Consumer)new Consumer<String>(){

                public void accept(String s) {
                    if (Strings.isNotBlank((String)s)) {
                        activeProfiles.add(s.trim());
                    }
                }
            });
        }
        System.setProperty("spring.profiles.active", Strings.join((String)",", (Iterable)activeProfiles));
        System.setProperty("spring.config.location", Strings.join((String)",", configLocations));
        SpringApplication app = new SpringApplication(new Class[]{CLI.class});
        app.setBanner((Banner)new ProjectBanner());
        app.setBannerMode(Banner.Mode.LOG);
        ConfigurableApplicationContext context = app.run(args);
        Runtime.getRuntime().addShutdownHook(new Thread((ApplicationContext)context){
            final /* synthetic */ ApplicationContext val$context;
            {
                this.val$context = applicationContext;
            }

            @Override
            public void run() {
                SpringApplication.exit((ApplicationContext)this.val$context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordPid(String homeDir) {
        String pid = Platform.processId;
        File pidFile = new File(homeDir + File.separator + "bin/pid");
        FileWriter fw = null;
        try {
            boolean actionResult;
            if (!pidFile.getParentFile().exists()) {
                pidFile.getParentFile().mkdirs();
            }
            if (!pidFile.exists() && !(actionResult = pidFile.createNewFile())) {
                Loggers.getLogger(CLI.class).warn("create pid file failed: {}", (Object)pidFile);
            }
            fw = new FileWriter(pidFile, false);
            IOs.write((String)pid, (Writer)fw);
            IOs.close((Closeable)fw);
        }
        catch (IOException e) {
            logger.error("failed to write pid: {}", (Object)pid);
        }
        finally {
            IOs.close(fw);
        }
    }

    private static boolean hasCustomLogbackXml(String dir) {
        FileResource fileResource = Resources.loadFileResource((String)(dir + File.separator + "logback.xml"));
        return fileResource.exists();
    }

    static {
        configLocations = Collects.emptyArrayList();
    }
}

