/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.commands;

import com.jn.agileway.shell.command.annotation.Command;
import com.jn.agileway.shell.command.annotation.CommandComponent;
import com.jn.agileway.shell.command.annotation.CommandGroup;
import com.jn.agileway.shell.command.annotation.CommandOption;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationRepository;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.LineDelimiter;
import com.jn.langx.util.io.file.Files;
import com.jn.sqlhelper.common.connection.ConnectionConfiguration;
import com.jn.sqlhelper.common.connection.ConnectionFactory;
import com.jn.sqlhelper.common.connection.NamedConnectionConfiguration;
import com.jn.sqlhelper.common.ddl.dump.DatabaseLoader;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import com.jn.sqlhelper.common.ddl.model.Index;
import com.jn.sqlhelper.common.ddl.model.Table;
import com.jn.sqlhelper.common.utils.Connections;
import com.jn.sqlhelper.common.utils.SQLs;
import com.jn.sqlhelper.dialect.ddl.generator.CommonTableGenerator;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@CommandComponent
@CommandGroup(value="db")
public class ShowDatabaseCommands {
    private static final Logger logger = LoggerFactory.getLogger(ShowDatabaseCommands.class);
    @Autowired
    DirectoryBasedFileConfigurationRepository<NamedConnectionConfiguration> repository;

    private Connection getConnectionByConnectionConfigurationId(String id) {
        NamedConnectionConfiguration configuration = (NamedConnectionConfiguration)this.repository.getById(id);
        Preconditions.checkNotNull((Object)configuration, (String)StringTemplates.formatWithPlaceholder((String)"Can't find a connection configuration named {}", (Object[])new Object[]{id}));
        ConnectionFactory factory = new ConnectionFactory((ConnectionConfiguration)configuration);
        return factory.getConnection();
    }

    @Command(value="show tables", desc="Show table names")
    public List<String> getTableNames(@CommandOption(value="connectionName", desc="the connection configuration name") String connectionName) {
        Connection connection = this.getConnectionByConnectionConfigurationId(connectionName);
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            final DatabaseDescription databaseDescription = new DatabaseDescription(dbMetaData);
            List tables = new DatabaseLoader().loadTables(databaseDescription, Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), null);
            List list = Pipeline.of((Iterable)tables).map((Function)new Function<Table, String>(){

                public String apply(Table table) {
                    return SQLs.getTableFQN((DatabaseDescription)databaseDescription, (String)table.getCatalog(), (String)table.getSchema(), (String)table.getName());
                }
            }).asList();
            return list;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
        finally {
            IOs.close((Object)connection);
        }
    }

    @Command(value="show table", desc="Show table detail")
    public Table getTable(@CommandOption(desc="the connection configuration name") String connectionName, @CommandOption(desc="the table name") String table) {
        Connection connection = this.getConnectionByConnectionConfigurationId(connectionName);
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            Table table2 = new DatabaseLoader().loadTable(new DatabaseDescription(dbMetaData), Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), table);
            return table2;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
        finally {
            IOs.close((Object)connection);
        }
    }

    @Command(value="show indexes", desc="Show table index")
    public List<String> getIndexNames(@CommandOption(desc="the connection configuration name") String connectionName, @CommandOption(desc="the table name") String table) {
        Connection connection = this.getConnectionByConnectionConfigurationId(connectionName);
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            DatabaseDescription databaseDescription = new DatabaseDescription(dbMetaData);
            List indexes = new DatabaseLoader().findTableIndexes(databaseDescription, Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), table);
            List list = Pipeline.of((Iterable)indexes).map((Function)new Function<Index, String>(){

                public String apply(Index index) {
                    return index.getName() + "\t" + SQLs.getTableFQN((String)index.getCatalog(), (String)index.getSchema(), (String)index.getTableName());
                }
            }).asList();
            return list;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
        finally {
            IOs.close((Object)connection);
        }
    }

    @Command(value="show index", desc="Show index detail")
    public Index getIndex(@CommandOption(desc="the connection configuration name") String connectionName, @CommandOption(desc="the table name") String table, @CommandOption(desc="the index name") String index) {
        Connection connection = this.getConnectionByConnectionConfigurationId(connectionName);
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            Table t = new DatabaseLoader().loadTable(new DatabaseDescription(dbMetaData), Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), table);
            Index index2 = t.getIndex(index);
            return index2;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
        finally {
            IOs.close((Object)connection);
        }
    }

    @Command(value="show ddl", desc="Show table DDL")
    public String getTableDDL(@CommandOption(desc="the connection configuration name") String connectionName, @CommandOption(desc="the table name") String table) {
        Connection connection = this.getConnectionByConnectionConfigurationId(connectionName);
        try {
            DatabaseMetaData dbMetaData = connection.getMetaData();
            DatabaseDescription databaseDescription = new DatabaseDescription(dbMetaData);
            Table t = new DatabaseLoader().loadTable(databaseDescription, Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), table);
            Preconditions.checkNotNull((Object)t, (String)StringTemplates.formatWithPlaceholder((String)"table {} is not exists", (Object[])new Object[]{table}));
            CommonTableGenerator generator = new CommonTableGenerator(databaseDescription);
            String string = generator.generate(t);
            return string;
        }
        catch (Throwable ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
        finally {
            IOs.close((Object)connection);
        }
    }

    @Command(value="dump ddl", desc="Show table DDL")
    public String dumpTablesDDL(@CommandOption(desc="the connection configuration name") String connectionName, @CommandOption(desc="the table name", defaultValue="") String table, @CommandOption(desc="the dump directory") String directory, @CommandOption(desc="the dump filename") String filename, @CommandOption(desc="postback to you", defaultValue="false") boolean postback) {
        String string;
        BufferedWriter bf;
        Connection connection;
        block6: {
            connection = this.getConnectionByConnectionConfigurationId(connectionName);
            bf = null;
            DatabaseMetaData dbMetaData = connection.getMetaData();
            DatabaseDescription databaseDescription = new DatabaseDescription(dbMetaData);
            table = Strings.getNullIfBlank((String)table);
            List ts = new DatabaseLoader().loadTables(databaseDescription, Connections.getCatalog((Connection)connection), Connections.getSchema((Connection)connection), table, true, true, true, true);
            Preconditions.checkNotNull((Object)ts, (String)StringTemplates.formatWithPlaceholder((String)"table {} is not exists", (Object[])new Object[]{table}));
            if (!Strings.endsWithIgnoreCase((CharSequence)filename, (CharSequence)".sql")) {
                filename = (String)filename + ".sql";
            }
            Files.makeDirs((String)directory);
            File file = new File(directory, (String)filename);
            Files.makeFile((File)file);
            final BufferedWriter bufferedWriter = bf = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            final CommonTableGenerator generator = new CommonTableGenerator(databaseDescription);
            final StringBuilder builder = new StringBuilder();
            Collects.forEach((Iterable)ts, (Consumer)new Consumer<Table>(){

                public void accept(Table t) {
                    try {
                        String ddl = generator.generate(t);
                        builder.append(ddl);
                        builder.append(LineDelimiter.DEFAULT.getValue());
                        IOs.write((byte[])ddl.getBytes(Charsets.UTF_8), (Writer)bufferedWriter, (Charset)Charsets.UTF_8);
                        bufferedWriter.write(LineDelimiter.DEFAULT.getValue());
                        bufferedWriter.flush();
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage());
                    }
                }
            });
            if (!postback) break block6;
            String string2 = builder.toString();
            IOs.close((Closeable)bf);
            IOs.close((Object)connection);
            return string2;
        }
        try {
            string = null;
        }
        catch (Throwable ex) {
            try {
                throw Throwables.wrapAsRuntimeException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOs.close(bf);
                IOs.close((Object)connection);
                throw throwable;
            }
        }
        IOs.close((Closeable)bf);
        IOs.close((Object)connection);
        return string;
    }
}

