/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.config;

import com.jn.langx.cache.Cache;
import com.jn.langx.cache.CacheBuilder;
import com.jn.langx.cache.Loader;
import com.jn.langx.configuration.ConfigurationCacheLoaderAdapter;
import com.jn.langx.configuration.ConfigurationEventFactory;
import com.jn.langx.configuration.ConfigurationSerializer;
import com.jn.langx.configuration.InputStreamConfigurationParser;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationLoader;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationRepository;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationWriter;
import com.jn.langx.event.EventListener;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.event.local.SimpleEventPublisher;
import com.jn.langx.util.Strings;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.file.FileFilter;
import com.jn.langx.util.io.file.filter.PatternFilenameFilter;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.sqlhelper.cli.config.JdbcConnectionRepositoryProperties;
import com.jn.sqlhelper.cli.config.LogConfigurationMutationEventListener;
import com.jn.sqlhelper.common.connection.NamedConnectionConfiguration;
import com.jn.sqlhelper.common.connection.PropertiesNamedConnectionConfigurationParser;
import com.jn.sqlhelper.common.connection.PropertiesNamedConnectionConfigurationSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JdbcConnectionRepositoryProperties.class})
public class JdbcConnectionRepositoryConfig {
    @Autowired
    private JdbcConnectionRepositoryProperties jdbcProperties;

    @Bean
    public PropertiesNamedConnectionConfigurationParser propertiesNamedConnectionConfigurationParser() {
        return new PropertiesNamedConnectionConfigurationParser();
    }

    @Bean(value={"configurationIdSupplier"})
    public Supplier<String, String> configurationIdSupplier() {
        return new Supplier<String, String>(){

            public String get(String filename) {
                return Strings.replace((String)filename, (String)"jdbcConn-", (String)"");
            }
        };
    }

    @Bean
    public Supplier<String, String> filenameSupplier() {
        return new Supplier<String, String>(){

            public String get(String configurationId) {
                return "jdbcConn-" + configurationId + ".properties";
            }
        };
    }

    @Bean
    public FileFilter jdbcConnectionConfigPatternFilter() {
        return new PatternFilenameFilter("jdbcConn-.*\\.properties");
    }

    @Bean(value={"jdbcDirectoryBasedFileConfigurationLoader"})
    public DirectoryBasedFileConfigurationLoader<NamedConnectionConfiguration> jdbcDirectoryBasedFileConfigurationLoader(@Autowired PropertiesNamedConnectionConfigurationParser propertiesConfigurationParser, @Autowired @Qualifier(value="filenameSupplier") Supplier<String, String> filenameSupplier, @Autowired @Qualifier(value="configurationIdSupplier") Supplier<String, String> configurationIdSupplier) {
        DirectoryBasedFileConfigurationLoader loader = new DirectoryBasedFileConfigurationLoader();
        loader.setFilenameSupplier(filenameSupplier);
        loader.setConfigurationIdSupplier(configurationIdSupplier);
        loader.setConfigurationParser((InputStreamConfigurationParser)propertiesConfigurationParser);
        return loader;
    }

    @Bean
    public Cache<String, NamedConnectionConfiguration> jdbcConnectionConfigurationCache(@Autowired @Qualifier(value="jdbcDirectoryBasedFileConfigurationLoader") DirectoryBasedFileConfigurationLoader<NamedConnectionConfiguration> loader, @Autowired @Qualifier(value="timer") Timer timer) {
        return CacheBuilder.newBuilder().loader((Loader)new ConfigurationCacheLoaderAdapter(loader)).timer(timer).build();
    }

    @Bean
    public PropertiesNamedConnectionConfigurationSerializer propertiesNamedConnectionConfigurationSerializer() {
        return new PropertiesNamedConnectionConfigurationSerializer();
    }

    @Bean(value={"jdbcDirectoryBasedFileConfigurationWriter"})
    public DirectoryBasedFileConfigurationWriter<NamedConnectionConfiguration> directoryBasedFileConfigurationWriter(@Autowired PropertiesNamedConnectionConfigurationSerializer serializer, @Autowired @Qualifier(value="filenameSupplier") Supplier<String, String> filenameSupplier) {
        DirectoryBasedFileConfigurationWriter writer = new DirectoryBasedFileConfigurationWriter();
        writer.setFilenameSupplier(filenameSupplier);
        writer.setConfigurationSerializer((ConfigurationSerializer)serializer);
        writer.setEncoding("iso-8859-1");
        return writer;
    }

    @Bean(value={"jdbcConfigurationEventFactory"})
    public ConfigurationEventFactory<NamedConnectionConfiguration> configurationEventFactory() {
        return new ConfigurationEventFactory("JdbcConnectionConfiguration");
    }

    @Bean
    public EventPublisher eventPublisher() {
        SimpleEventPublisher eventPublisher = new SimpleEventPublisher();
        eventPublisher.addEventListener("JdbcConnectionConfiguration", (EventListener)new LogConfigurationMutationEventListener());
        return eventPublisher;
    }

    @Bean
    public DirectoryBasedFileConfigurationRepository<NamedConnectionConfiguration> directoryPropertiesFileConfigurationRepository(@Autowired @Qualifier(value="jdbcConnectionConfigurationCache") Cache<String, NamedConnectionConfiguration> cache, @Autowired @Qualifier(value="jdbcDirectoryBasedFileConfigurationLoader") DirectoryBasedFileConfigurationLoader<NamedConnectionConfiguration> loader, @Autowired @Qualifier(value="jdbcDirectoryBasedFileConfigurationWriter") DirectoryBasedFileConfigurationWriter<NamedConnectionConfiguration> writer, @Autowired @Qualifier(value="jdbcConfigurationEventFactory") ConfigurationEventFactory<NamedConnectionConfiguration> eventFactory, @Autowired @Qualifier(value="jdbcConnectionConfigPatternFilter") FileFilter jdbcConnectionConfigPatternFilter, @Autowired EventPublisher eventPublisher, @Autowired Timer timer) {
        DirectoryBasedFileConfigurationRepository repository = new DirectoryBasedFileConfigurationRepository();
        repository.setCache(cache);
        repository.setName("JdbcConnectionConfigurationRepository");
        repository.setDirectory(this.jdbcProperties.getDirectory());
        repository.setConfigurationLoader(loader);
        repository.setConfigurationWriter(writer);
        repository.setTimer(timer);
        repository.setEventPublisher(eventPublisher);
        repository.setEventFactory(eventFactory);
        repository.setReloadIntervalInSeconds(this.jdbcProperties.getReloadIntervalInSeconds());
        repository.startup();
        return repository;
    }
}

