/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.utils;

import com.jn.langx.io.resource.Resources;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.jar.Manifests;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.core.env.Environment;

public class ProjectBanner
implements Banner {
    private static final Logger logger = LoggerFactory.getLogger(ProjectBanner.class);
    private static final List<String> BANNER = Collects.emptyArrayList();
    private String defaultValue = "Project";

    public ProjectBanner() {
    }

    public ProjectBanner(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        out.println();
        if (Emptys.isNotEmpty(BANNER)) {
            for (String line : BANNER) {
                out.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.YELLOW, line}));
            }
        } else {
            out.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.YELLOW, this.defaultValue}));
        }
        Manifest manifest = Manifests.loadManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            String majorVersion = attributes.getValue("Build-Major-Version");
            String scmVersion = attributes.getValue("Build-SCM-Version");
            String fixedScmVersion = attributes.getValue("Build-FIXED-SCM-Version");
            if (Strings.isNotBlank((String)fixedScmVersion) && !fixedScmVersion.contains("fixed_version")) {
                scmVersion = fixedScmVersion;
            }
            String buildTime = attributes.getValue("Build-Timestamp");
            out.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.RED, StringTemplates.formatWithPlaceholder((String)"Version: {} ({})", (Object[])new Object[]{majorVersion, scmVersion})}));
            out.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.RED, StringTemplates.formatWithPlaceholder((String)"Build Time: {}", (Object[])new Object[]{buildTime})}));
        }
    }

    static {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(Resources.loadClassPathResource((String)"banner").getInputStream()));
            reader.lines().forEach(BANNER::add);
            IOs.close((Closeable)reader);
        }
        catch (IOException ex) {
            logger.warn("Can't find the banner resource: {}", (Object)"classpath:banner");
        }
        finally {
            IOs.close(reader);
        }
    }
}

