/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.commands;

import com.jn.agileway.shell.command.annotation.Command;
import com.jn.agileway.shell.command.annotation.CommandComponent;
import com.jn.agileway.shell.command.annotation.CommandOption;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationRepository;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.common.connection.NamedConnectionConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;

@CommandComponent
public class JdbcConnectionCommands {
    @Autowired
    DirectoryBasedFileConfigurationRepository<NamedConnectionConfiguration> repository;

    @Command(value="jdbc list", desc="list all connection configuration names")
    public List<String> getConnectionNames() {
        return Collects.asList(this.repository.getAll().keySet());
    }

    @Command(value="jdbc create", desc="create an new connection configuration")
    public NamedConnectionConfiguration addConnection(@CommandOption String name, @CommandOption String driver, @CommandOption String url, @CommandOption String username, @CommandOption(defaultValue="") String password, @CommandOption(defaultValue="") String catalog, @CommandOption(defaultValue="") String schema, @CommandOption(defaultValue="") String props) {
        Preconditions.checkTrue((boolean)Strings.isNotEmpty((String)name));
        Preconditions.checkTrue((boolean)Strings.isNotEmpty((String)driver));
        Preconditions.checkTrue((boolean)Strings.isNotEmpty((String)url));
        Preconditions.checkTrue((boolean)Strings.isNotEmpty((String)username));
        StringMap propsMap = new StringMap(props, "=", "&");
        final Properties properties = new Properties();
        Collects.forEach((Map)propsMap, (Consumer2)new Consumer2<String, String>(){

            public void accept(String key, String value) {
                properties.setProperty(key, value);
            }
        });
        NamedConnectionConfiguration configuration = new NamedConnectionConfiguration();
        configuration.setName(name);
        configuration.setDriver(driver);
        configuration.setUrl(url);
        configuration.setUser(username);
        configuration.setPassword(password);
        configuration.setDriverProps(properties);
        properties.setProperty("user", username);
        properties.setProperty("password", password);
        this.repository.add((Configuration)configuration);
        return configuration;
    }

    @Command(value="jdbc get", desc="get a connection configuration by name")
    public NamedConnectionConfiguration getConnection(String name) {
        return (NamedConnectionConfiguration)this.repository.getById(name);
    }

    @Command(value="jdbc remove", desc="remove a connection configuration by name")
    public boolean removeConnection(String name) {
        this.repository.removeById(name);
        return true;
    }
}

