/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.commands;

import com.jn.agileway.shell.command.annotation.Command;
import com.jn.agileway.shell.command.annotation.CommandComponent;
import com.jn.agileway.shell.command.annotation.CommandOption;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.security.crypto.JCAEStandardName;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.sqlhelper.common.security.DriverPropertiesRsaCipher;
import java.security.KeyPair;
import java.security.SecureRandom;

@CommandComponent
public class SecurityCommands {
    @Command(value="gen-rsa", desc="generate rsa")
    public String genRSAKeyPair() {
        KeyPair keyPair = PKIs.createKeyPair((String)JCAEStandardName.RSA.getName(), (String)null, (int)512, (SecureRandom)new SecureRandom());
        String publicKey = Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded());
        String privateKey = Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded());
        return StringTemplates.formatWithPlaceholder((String)"publicKey: {}\nprivateKey:{}", (Object[])new Object[]{publicKey, privateKey});
    }

    @Command(value="encrypt", desc="encrypt with rsa")
    public String encrypt(@CommandOption(defaultValue="__NULL__") String publicKey, String text) {
        DriverPropertiesRsaCipher cipherer = new DriverPropertiesRsaCipher();
        if (Emptys.isNotEmpty((Object)publicKey)) {
            cipherer.setPublicKey(publicKey);
        }
        return cipherer.encrypt(text);
    }
}

