package io.github.qsy7.examples.queue;

import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.annotation.JobExecutionConfiguration;
import io.github.qsy7.queue.api.annotation.scheduling.FixedDelay;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.impl.worker.property.JobExecutionHeartbeatTimeoutUnits;
import io.github.qsy7.queue.impl.worker.property.JobExecutionHeartbeatTimeoutValue;
import java.time.temporal.ChronoUnit;
import jakarta.inject.Inject;

/** Runs every 10 seconds with no initial delay */
@Job(
    jobExecutionConfiguration = @JobExecutionConfiguration(),
    fixedDelay = @FixedDelay(fixedDelay = 10))
public class SimpleQueuedJob extends AbstractRunnable {
  protected int invocationCount = 0;

  @Inject
  public SimpleQueuedJob(
      @Property(JobExecutionHeartbeatTimeoutValue.class) long heartbeatIntervalValue,
      @Property(JobExecutionHeartbeatTimeoutUnits.class) ChronoUnit heartbeatIntervalUnits) {}

  @Override
  protected void doCall() {}
}
