package io.github.qsy7.amazon;

import com.amazonaws.auth.AWSCredentialsProvider;
import io.github.qsy7.amazon.property.AmazonAccessKeyId;
import io.github.qsy7.amazon.property.AmazonSecretAccessKey;
import io.github.qsy7.property.api.annotation.Property;
import jakarta.inject.Inject;
import jakarta.inject.Provider;

public class AmazonCredentialsProvider implements Provider<AWSCredentialsProvider> {
  protected final AWSCredentialsProvider amazonCredentialsProvider;

  @Inject
  public AmazonCredentialsProvider(
      @Property(AmazonAccessKeyId.class) String amazonAccessKeyId,
      @Property(AmazonSecretAccessKey.class) String amazonSecretAccessKey) {

    amazonCredentialsProvider =
        new DefaultAWSCredentialsProvider(amazonAccessKeyId, amazonSecretAccessKey);
  }

  @Override
  public AWSCredentialsProvider get() {
    return amazonCredentialsProvider;
  }
}
