/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.model;

import io.github.qsy7.encryption.enumeration.EncryptionType;
import io.github.qsy7.encryption.model.EncryptionPolicy;
import io.github.qsy7.encryption.service.DigestService;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.annotation.Sensitive;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.enterprise.util.AnnotationLiteral;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.codec.binary.Base64;

@Embeddable
public class Encrypted {
    @Sensitive
    @Transient
    protected transient String plainText;
    @Enumerated(value=EnumType.STRING)
    @Column
    protected EncryptionType encryptionType;
    @Lob
    @Column
    protected String cipherText;
    @Sensitive
    @Column
    protected String salt;
    @ManyToOne
    @JoinColumn
    protected EncryptionPolicy applicableEncryptionPolicy;
    private static transient EncryptionService ENCRYPTION_SERVICE;
    private static transient DigestService DIGEST_SERVICE;

    /*
     * WARNING - void declaration
     */
    public Encrypted(String string, EncryptionType encryptionType) {
        void encryptionType2;
        void plainText;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[]{string, encryptionType});
        Encrypted encrypted = this;
        String string2 = string;
        EncryptionType encryptionType3 = encryptionType;
        plainText.plainText = encryptionType2;
        plainText.encryptionType = encryptionType3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[]{string, encryptionType}, null, (long)l);
    }

    private static synchronized void init() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"init", (Object[])new Object[0]);
        if (DIGEST_SERVICE == null) {
            DIGEST_SERVICE = (DigestService)ApplicationHelper.getApplicationInstance().getInjector().getInstance(DigestService.class, new AnnotationLiteral[0]);
            ENCRYPTION_SERVICE = (EncryptionService)ApplicationHelper.getApplicationInstance().getInjector().getInstance(EncryptionService.class, new AnnotationLiteral[0]);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"init", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doEncrypt() throws IOException, NoSuchAlgorithmException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doEncrypt", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted.init();
        if (EncryptionType.Encrypt.equals((Object)encrypted.encryptionType)) {
            void cipherOutputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ENCRYPTION_SERVICE.encrypt(new ByteArrayInputStream(cipherOutputStream.plainText.getBytes(Charset.defaultCharset())), byteArrayOutputStream);
            cipherOutputStream.cipherText = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
        } else {
            encrypted.cipherText = DIGEST_SERVICE.compute(new ByteArrayInputStream(encrypted.plainText.getBytes(Charset.defaultCharset())));
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doEncrypt", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doDecrypt() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doDecrypt", (Object[])new Object[0]);
        Encrypted encrypted = this;
        if (EncryptionType.Encrypt.equals((Object)encrypted.encryptionType)) {
            void plaintextStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ENCRYPTION_SERVICE.decrypt(new ByteArrayInputStream(Base64.decodeBase64((String)plaintextStream.cipherText)), byteArrayOutputStream);
            plaintextStream.plainText = byteArrayOutputStream.toString(Charset.defaultCharset());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doDecrypt", (Object[])new Object[0], null, (long)l);
    }

    @PostLoad
    public void onPostLoad() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPostLoad", (Object[])new Object[0]);
        Encrypted encrypted = this;
        encrypted.doDecrypt();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPostLoad", (Object[])new Object[0], null, (long)l);
    }

    @PrePersist
    @PreUpdate
    public void onPreStore() throws IOException, NoSuchAlgorithmException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPreStore", (Object[])new Object[0]);
        Encrypted encrypted = this;
        encrypted.doEncrypt();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPreStore", (Object[])new Object[0], null, (long)l);
    }

    public Encrypted() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[0]);
        Encrypted encrypted = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[0], null, (long)l);
    }

    public EncryptionType getEncryptionType() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getEncryptionType", (Object[])new Object[0]);
        Object object = this;
        object = object.encryptionType;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getEncryptionType", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public String getCipherText() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getCipherText", (Object[])new Object[0]);
        Object object = this;
        object = ((Encrypted)object).cipherText;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getCipherText", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public EncryptionPolicy getApplicableEncryptionPolicy() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getApplicableEncryptionPolicy", (Object[])new Object[0]);
        Object object = this;
        object = object.applicableEncryptionPolicy;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getApplicableEncryptionPolicy", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        EncryptionType encryptionType2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setEncryptionType", (Object[])new Object[]{encryptionType});
        Encrypted encrypted = this;
        encryptionType.encryptionType = encryptionType2 = encryptionType;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setEncryptionType", (Object[])new Object[]{encryptionType}, null, (long)l);
    }

    public void setCipherText(String string) {
        String string2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setCipherText", (Object[])new Object[]{string});
        Encrypted encrypted = this;
        cipherText.cipherText = string2 = string;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setCipherText", (Object[])new Object[]{string}, null, (long)l);
    }

    public void setApplicableEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        EncryptionPolicy encryptionPolicy2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setApplicableEncryptionPolicy", (Object[])new Object[]{encryptionPolicy});
        Encrypted encrypted = this;
        applicableEncryptionPolicy.applicableEncryptionPolicy = encryptionPolicy2 = encryptionPolicy;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setApplicableEncryptionPolicy", (Object[])new Object[]{encryptionPolicy}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        void o;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"equals", (Object[])new Object[]{object});
        Encrypted encrypted = this;
        Object object2 = object;
        if (object2 == o) {
            bl = true;
        } else if (!(object2 instanceof Encrypted)) {
            bl = false;
        } else {
            Encrypted encrypted2 = (Encrypted)object2;
            if (!encrypted2.canEqual(o)) {
                bl = false;
            } else {
                void other$encryptionType;
                void this$encryptionType;
                EncryptionType encryptionType = o.getEncryptionType();
                EncryptionType encryptionType2 = this$encryptionType.getEncryptionType();
                if (other$encryptionType == null ? encryptionType2 != null : !other$encryptionType.equals((Object)encryptionType2)) {
                    bl = false;
                } else {
                    void other$applicableEncryptionPolicy;
                    EncryptionPolicy encryptionPolicy = o.getApplicableEncryptionPolicy();
                    EncryptionPolicy encryptionPolicy2 = this$encryptionType.getApplicableEncryptionPolicy();
                    bl = !(other$applicableEncryptionPolicy == null ? encryptionPolicy2 != null : !other$applicableEncryptionPolicy.equals((Object)encryptionPolicy2));
                }
            }
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"equals", (Object[])new Object[]{object}, (Object)bl2, (long)l);
        return bl2;
    }

    protected boolean canEqual(Object object) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"canEqual", (Object[])new Object[]{object});
        Encrypted encrypted = this;
        Object object2 = object;
        boolean bl = object2 instanceof Encrypted;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"canEqual", (Object[])new Object[]{object}, (Object)bl, (long)l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $encryptionType;
        void PRIME;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"hashCode", (Object[])new Object[0]);
        Encrypted encrypted = this;
        int n = 59;
        boolean bl = true;
        EncryptionType encryptionType = PRIME.getEncryptionType();
        $encryptionType = $encryptionType * 59 + (encryptionType == null ? 43 : ((Object)((Object)encryptionType)).hashCode());
        EncryptionPolicy encryptionPolicy = PRIME.getApplicableEncryptionPolicy();
        void var3_3 = $encryptionType = $encryptionType * 59 + (encryptionPolicy == null ? 43 : ((Object)((Object)encryptionPolicy)).hashCode());
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"hashCode", (Object[])new Object[0], (Object)((int)var3_3), (long)l);
        return (int)var3_3;
    }

    public String toString() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"toString", (Object[])new Object[0]);
        Object object = this;
        object = "Encrypted(encryptionType=" + ((Encrypted)object).encryptionType + ", applicableEncryptionPolicy=" + ((Encrypted)object).applicableEncryptionPolicy + ")";
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"toString", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    @Sensitive
    public String getPlainText() {
        return this.plainText;
    }

    @Sensitive
    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    @Sensitive
    public String getSalt() {
        return this.salt;
    }

    @Sensitive
    public void setSalt(String salt) {
        this.salt = salt;
    }
}

