// Generated by delombok at Fri Jan 12 23:31:44 EST 2024
package io.github.qsy7.encryption.model;

import io.github.qsy7.encryption.enumeration.EncryptionType;
import io.github.qsy7.encryption.service.DigestService;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.annotation.Sensitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceAware;
import javax.jdo.annotations.PostLoad;
import javax.jdo.annotations.PreStore;
import lombok.*;
import org.apache.commons.codec.binary.Base64;

@PersistenceAware
public class Encrypted {
  /*implements StoreCallback, LoadCallback*/ @Sensitive
  @NotPersistent
  protected transient String plainText;
  protected EncryptionType encryptionType;
  protected String cipherText;
  @Sensitive
  protected String salt;
  protected EncryptionPolicy applicableEncryptionPolicy;

  public Encrypted(String plainText, EncryptionType encryptionType) {
    this.plainText = plainText;
    this.encryptionType = encryptionType;
  }

  private static transient EncryptionService ENCRYPTION_SERVICE;
  private static transient DigestService DIGEST_SERVICE;

  private static synchronized void init() {
    if (DIGEST_SERVICE != null) {
      return;
    }
    DIGEST_SERVICE = ApplicationHelper.getApplicationInstance().getInjector().getInstance(DigestService.class);
    ENCRYPTION_SERVICE = ApplicationHelper.getApplicationInstance().getInjector().getInstance(EncryptionService.class);
    //    final SaltService saltService =
    //
    // ApplicationHelper.getApplicationInstance().getInjector().getInstance(SaltService.class);
  }

  protected void doEncrypt() throws IOException, NoSuchAlgorithmException {
    init();
    if (EncryptionType.Encrypt.equals(encryptionType)) {
      //      final EncryptionService encryptionService =
      //          ApplicationHelper.getApplicationInstance().getInjector()
      //              .getInstance(EncryptionServiceProvider.class)
      //              .get(applicableEncryptionPolicy);
      // cipherText =
      final ByteArrayOutputStream cipherOutputStream = new ByteArrayOutputStream();
      ENCRYPTION_SERVICE.encrypt(new ByteArrayInputStream(plainText.getBytes(Charset.defaultCharset())), cipherOutputStream);
      cipherText = Base64.encodeBase64String(cipherOutputStream.toByteArray());
    } else {
      //      final DigestService digestService =
      //          ApplicationHelper.getApplicationInstance().getInjector()
      //              .getInstance(DigestServiceProvider.class)
      //              .get(applicableEncryptionPolicy);
      cipherText = DIGEST_SERVICE.compute(new ByteArrayInputStream(plainText.getBytes(Charset.defaultCharset())));
      //        final byte[] salt = saltService.generate();
      // salt = Base64.encodeBase64String(salt);
    }
  }

  protected void doDecrypt() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
    if (EncryptionType.Encrypt.equals(encryptionType)) {
      //      final EncryptionService encryptionService =
      //          ApplicationHelper.getApplicationInstance().getInjector()
      //              .getInstance(EncryptionServiceProvider.class)
      //              .get(applicableEncryptionPolicy);
      final ByteArrayOutputStream plaintextStream = new ByteArrayOutputStream();
      ENCRYPTION_SERVICE.decrypt(new ByteArrayInputStream(Base64.decodeBase64(cipherText)), plaintextStream);
      plainText = plaintextStream.toString(Charset.defaultCharset());
    }
  }

  // @Override
  @PostLoad
  public void onPostLoad() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
    doDecrypt();
  }

  // @Override
  //  @PrePersist
  //  @PreUpdate
  @PreStore
  public void onPreStore() throws IOException, NoSuchAlgorithmException {
    doEncrypt();
  }

  @Sensitive
  public String getPlainText() {
    return plainText;
  }

  @Sensitive
  public void setPlainText(final String plainText) {
    this.plainText = plainText;
  }

  @Sensitive
  public String getSalt() {
    return salt;
  }

  @Sensitive
  public void setSalt(final String salt) {
    this.salt = salt;
  }

  @java.lang.SuppressWarnings("all")
  public Encrypted() {
  }

  @java.lang.SuppressWarnings("all")
  public EncryptionType getEncryptionType() {
    return this.encryptionType;
  }

  @java.lang.SuppressWarnings("all")
  public String getCipherText() {
    return this.cipherText;
  }

  @java.lang.SuppressWarnings("all")
  public EncryptionPolicy getApplicableEncryptionPolicy() {
    return this.applicableEncryptionPolicy;
  }

  @java.lang.SuppressWarnings("all")
  public void setEncryptionType(final EncryptionType encryptionType) {
    this.encryptionType = encryptionType;
  }

  @java.lang.SuppressWarnings("all")
  public void setCipherText(final String cipherText) {
    this.cipherText = cipherText;
  }

  @java.lang.SuppressWarnings("all")
  public void setApplicableEncryptionPolicy(final EncryptionPolicy applicableEncryptionPolicy) {
    this.applicableEncryptionPolicy = applicableEncryptionPolicy;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Encrypted)) return false;
    final Encrypted other = (Encrypted) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$encryptionType = this.getEncryptionType();
    final java.lang.Object other$encryptionType = other.getEncryptionType();
    if (this$encryptionType == null ? other$encryptionType != null : !this$encryptionType.equals(other$encryptionType)) return false;
    final java.lang.Object this$applicableEncryptionPolicy = this.getApplicableEncryptionPolicy();
    final java.lang.Object other$applicableEncryptionPolicy = other.getApplicableEncryptionPolicy();
    if (this$applicableEncryptionPolicy == null ? other$applicableEncryptionPolicy != null : !this$applicableEncryptionPolicy.equals(other$applicableEncryptionPolicy)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Encrypted;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $encryptionType = this.getEncryptionType();
    result = result * PRIME + ($encryptionType == null ? 43 : $encryptionType.hashCode());
    final java.lang.Object $applicableEncryptionPolicy = this.getApplicableEncryptionPolicy();
    result = result * PRIME + ($applicableEncryptionPolicy == null ? 43 : $applicableEncryptionPolicy.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "Encrypted(encryptionType=" + this.encryptionType + ", applicableEncryptionPolicy=" + this.applicableEncryptionPolicy + ")";
  }
}
