/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.model;

import io.github.qsy7.encryption.enumeration.EncryptionType;
import io.github.qsy7.encryption.model.EncryptionPolicy;
import io.github.qsy7.encryption.service.DigestService;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.annotation.Sensitive;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceAware;
import javax.jdo.annotations.PostLoad;
import javax.jdo.annotations.PreStore;
import org.apache.commons.codec.binary.Base64;

@PersistenceAware
public class Encrypted {
    @Sensitive
    @NotPersistent
    protected transient String plainText;
    protected EncryptionType encryptionType;
    protected String cipherText;
    @Sensitive
    protected String salt;
    protected EncryptionPolicy applicableEncryptionPolicy;
    private static transient EncryptionService ENCRYPTION_SERVICE;
    private static transient DigestService DIGEST_SERVICE;

    /*
     * WARNING - void declaration
     */
    public Encrypted(String string, EncryptionType encryptionType) {
        void encryptionType2;
        void plainText;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[]{string, encryptionType});
        Encrypted encrypted = this;
        String string2 = string;
        EncryptionType encryptionType3 = encryptionType;
        encrypted.plainText = plainText;
        encrypted.encryptionType = encryptionType2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[]{string, encryptionType}, null, (long)l);
    }

    private static synchronized void init() {
        Throwable throwable;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"init", (Object[])new Object[0]);
        try {
            if (DIGEST_SERVICE == null) {
                DIGEST_SERVICE = (DigestService)ApplicationHelper.getApplicationInstance().getInjector().getInstance(DigestService.class, new AnnotationLiteral[0]);
                ENCRYPTION_SERVICE = (EncryptionService)ApplicationHelper.getApplicationInstance().getInjector().getInstance(EncryptionService.class, new AnnotationLiteral[0]);
            }
            throwable = null;
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"init", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"init", (Object[])new Object[0], null, (long)l);
    }

    protected void doEncrypt() throws IOException, NoSuchAlgorithmException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doEncrypt", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted encrypted2 = encrypted;
        try {
            Encrypted.init();
            if (EncryptionType.Encrypt.equals((Object)encrypted2.encryptionType)) {
                ByteArrayOutputStream cipherOutputStream = new ByteArrayOutputStream();
                ENCRYPTION_SERVICE.encrypt(new ByteArrayInputStream(encrypted2.plainText.getBytes(Charset.defaultCharset())), cipherOutputStream);
                encrypted2.cipherText = Base64.encodeBase64String((byte[])cipherOutputStream.toByteArray());
            } else {
                encrypted2.cipherText = DIGEST_SERVICE.compute(new ByteArrayInputStream(encrypted2.plainText.getBytes(Charset.defaultCharset())));
            }
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"doEncrypt", (Object[])new Object[0], (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doEncrypt", (Object[])new Object[0], null, (long)l);
    }

    protected void doDecrypt() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doDecrypt", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted encrypted2 = encrypted;
        try {
            if (EncryptionType.Encrypt.equals((Object)encrypted2.encryptionType)) {
                ByteArrayOutputStream plaintextStream = new ByteArrayOutputStream();
                ENCRYPTION_SERVICE.decrypt(new ByteArrayInputStream(Base64.decodeBase64((String)encrypted2.cipherText)), plaintextStream);
                encrypted2.plainText = plaintextStream.toString(Charset.defaultCharset());
            }
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"doDecrypt", (Object[])new Object[0], (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"doDecrypt", (Object[])new Object[0], null, (long)l);
    }

    @PostLoad
    public void onPostLoad() throws InvalidAlgorithmParameterException, IOException, InvalidKeyException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPostLoad", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted encrypted2 = encrypted;
        try {
            encrypted2.doDecrypt();
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPostLoad", (Object[])new Object[0], (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPostLoad", (Object[])new Object[0], null, (long)l);
    }

    @PreStore
    public void onPreStore() throws IOException, NoSuchAlgorithmException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPreStore", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted encrypted2 = encrypted;
        try {
            encrypted2.doEncrypt();
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPreStore", (Object[])new Object[0], (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"onPreStore", (Object[])new Object[0], null, (long)l);
    }

    @Sensitive
    public String getPlainText() {
        return this.plainText;
    }

    @Sensitive
    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    @Sensitive
    public String getSalt() {
        return this.salt;
    }

    @Sensitive
    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Encrypted() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[0]);
        Encrypted encrypted = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"<init>", (Object[])new Object[0], null, (long)l);
    }

    public EncryptionType getEncryptionType() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getEncryptionType", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Object object = encrypted;
        try {
            object = object.encryptionType;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public String getCipherText() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getCipherText", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Object object = encrypted;
        try {
            object = ((Encrypted)object).cipherText;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public EncryptionPolicy getApplicableEncryptionPolicy() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"getApplicableEncryptionPolicy", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Object object = encrypted;
        try {
            object = object.applicableEncryptionPolicy;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEncryptionType(EncryptionType encryptionType) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setEncryptionType", (Object[])new Object[]{encryptionType});
        Encrypted encrypted = this;
        EncryptionType encryptionType2 = encryptionType;
        Encrypted encrypted2 = encrypted;
        EncryptionType encryptionType3 = encryptionType2;
        try {
            void encryptionType4;
            encrypted2.encryptionType = encryptionType4;
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"setEncryptionType", (Object[])new Object[]{encryptionType2}, (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setEncryptionType", (Object[])new Object[]{encryptionType}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void setCipherText(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setCipherText", (Object[])new Object[]{string});
        Encrypted encrypted = this;
        String string2 = string;
        Encrypted encrypted2 = encrypted;
        String string3 = string2;
        try {
            void cipherText;
            encrypted2.cipherText = cipherText;
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"setCipherText", (Object[])new Object[]{string2}, (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setCipherText", (Object[])new Object[]{string}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void setApplicableEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setApplicableEncryptionPolicy", (Object[])new Object[]{encryptionPolicy});
        Encrypted encrypted = this;
        EncryptionPolicy encryptionPolicy2 = encryptionPolicy;
        Encrypted encrypted2 = encrypted;
        EncryptionPolicy encryptionPolicy3 = encryptionPolicy2;
        try {
            void applicableEncryptionPolicy;
            encrypted2.applicableEncryptionPolicy = applicableEncryptionPolicy;
            encrypted2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (encrypted2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"setApplicableEncryptionPolicy", (Object[])new Object[]{encryptionPolicy2}, (Throwable)((Object)encrypted2));
        }
        if (encrypted2 != null) {
            throw encrypted2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"setApplicableEncryptionPolicy", (Object[])new Object[]{encryptionPolicy}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        long l;
        block8: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"equals", (Object[])new Object[]{object});
            Encrypted encrypted = this;
            object3 = object;
            Encrypted encrypted2 = encrypted;
            object2 = object3;
            try {
                void o;
                if (o == encrypted2) {
                    bl2 = true;
                    break block8;
                }
                if (!(o instanceof Encrypted)) {
                    bl2 = false;
                    break block8;
                }
                Encrypted other = (Encrypted)o;
                if (!other.canEqual(encrypted2)) {
                    bl2 = false;
                    break block8;
                }
                EncryptionType this$encryptionType = encrypted2.getEncryptionType();
                EncryptionType other$encryptionType = other.getEncryptionType();
                if (this$encryptionType == null ? other$encryptionType != null : !((Object)((Object)this$encryptionType)).equals((Object)other$encryptionType)) {
                    bl2 = false;
                    break block8;
                }
                EncryptionPolicy this$applicableEncryptionPolicy = encrypted2.getApplicableEncryptionPolicy();
                EncryptionPolicy other$applicableEncryptionPolicy = other.getApplicableEncryptionPolicy();
                bl2 = !(this$applicableEncryptionPolicy == null ? other$applicableEncryptionPolicy != null : !((Object)((Object)this$applicableEncryptionPolicy)).equals((Object)other$applicableEncryptionPolicy));
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        bl = bl2;
        object2 = null;
        if (object2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"equals", (Object[])new Object[]{object3}, (Throwable)object2);
        }
        if (object2 != null) {
            throw object2;
        }
        boolean bl3 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"equals", (Object[])new Object[]{object}, (Object)bl3, (long)l);
        return bl3;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean canEqual(Object object) {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"canEqual", (Object[])new Object[]{object});
        Encrypted encrypted = this;
        Object object2 = object;
        Encrypted encrypted2 = encrypted;
        Object object3 = object2;
        try {
            void other;
            bl = other instanceof Encrypted;
            object3 = null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (object3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"canEqual", (Object[])new Object[]{object2}, (Throwable)object3);
        }
        if (object3 != null) {
            throw object3;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"canEqual", (Object[])new Object[]{object}, (Object)bl2, (long)l);
        return bl2;
    }

    public int hashCode() {
        Object var5_7;
        int n;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"hashCode", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Encrypted encrypted2 = encrypted;
        try {
            int PRIME = 59;
            int result = 1;
            EncryptionType $encryptionType = encrypted2.getEncryptionType();
            result = result * 59 + ($encryptionType == null ? 43 : ((Object)((Object)$encryptionType)).hashCode());
            EncryptionPolicy $applicableEncryptionPolicy = encrypted2.getApplicableEncryptionPolicy();
            n = result = result * 59 + ($applicableEncryptionPolicy == null ? 43 : ((Object)((Object)$applicableEncryptionPolicy)).hashCode());
            var5_7 = null;
        }
        catch (Throwable throwable) {
            n = 0;
        }
        if (var5_7 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.model.Encrypted", (String)"hashCode", (Object[])new Object[0], (Throwable)var5_7);
        }
        if (var5_7 != null) {
            throw var5_7;
        }
        int n2 = n;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"hashCode", (Object[])new Object[0], (Object)n2, (long)l);
        return n2;
    }

    public String toString() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.model.Encrypted", (String)"toString", (Object[])new Object[0]);
        Encrypted encrypted = this;
        Object object = encrypted;
        try {
            object = "Encrypted(encryptionType=" + String.valueOf((Object)((Encrypted)object).encryptionType) + ", applicableEncryptionPolicy=" + String.valueOf((Object)((Encrypted)object).applicableEncryptionPolicy) + ")";
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }
}

