package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.enumeration.DigestAlgorithm;
import io.github.qsy7.encryption.enumeration.EncryptionAlgorithm;
import io.github.qsy7.encryption.enumeration.PaddingType;
import io.github.qsy7.encryption.enumeration.TransformationAlgorithm;
import io.github.qsy7.encryption.property.EncryptionKeyLength;
import io.github.qsy7.encryption.property.EncryptionSaltLength;
import io.github.qsy7.encryption.property.HashIterations;
import io.github.qsy7.encryption.property.InitializationVectorLength;
import io.github.qsy7.property.api.annotation.Property;
import javax.inject.Inject;
import javax.inject.Provider;

// TODO: rewrite this to a Configuration Provider
public class EncryptionConfigurationProvider implements Provider<EncryptionConfiguration> {
  protected final EncryptionConfiguration encryptionConfiguration;

  @Inject
  public EncryptionConfigurationProvider(
      @Property(EncryptionAlgorithm.class) EncryptionAlgorithm encryptionAlgorithm,
      @Property(TransformationAlgorithm.class) TransformationAlgorithm transformationAlgorithm,
      @Property(PaddingType.class) PaddingType paddingType,
      @Property(DigestAlgorithm.class) DigestAlgorithm digestAlgorithm,
      @Property(EncryptionSaltLength.class) int saltLength,
      @Property(EncryptionKeyLength.class) int keyLength,
      @Property(HashIterations.class) int hashIterations,
      @Property(InitializationVectorLength.class) int ivLength) {
    encryptionConfiguration =
        new EncryptionConfiguration(
            encryptionAlgorithm,
            transformationAlgorithm,
            paddingType,
            digestAlgorithm,
            saltLength,
            keyLength,
            hashIterations,
            ivLength);
  }

  @Override
  public EncryptionConfiguration get() {
    return encryptionConfiguration;
  }
}
