/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.impl.EncryptionConfiguration;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

public class DefaultEncryptionService
implements EncryptionService {
    protected final EncryptionConfiguration encryptionConfiguration;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultEncryptionService(EncryptionConfiguration encryptionConfiguration) {
        void encryptionConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration});
        DefaultEncryptionService defaultEncryptionService = this;
        EncryptionConfiguration encryptionConfiguration3 = encryptionConfiguration;
        encryptionConfiguration2.encryptionConfiguration = encryptionConfiguration3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void encrypt(InputStream inputStream, OutputStream outputStream) throws IOException {
        void plaintextStream;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"encrypt", (Object[])new Object[]{inputStream, outputStream});
        DefaultEncryptionService defaultEncryptionService = this;
        InputStream inputStream2 = inputStream;
        OutputStream outputStream2 = outputStream;
        try (OutputStream outputStream3 = plaintextStream.getEncryptionStream(outputStream2);){
            void outputStream4;
            IOUtils.copy((InputStream)outputStream4, (OutputStream)outputStream3);
            outputStream3.flush();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"encrypt", (Object[])new Object[]{inputStream, outputStream}, null, (long)l);
    }

    public OutputStream getEncryptionStream(OutputStream outputStream) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"getEncryptionStream", (Object[])new Object[]{outputStream});
        DefaultEncryptionService defaultEncryptionService = this;
        OutputStream outputStream2 = outputStream;
        throw new UnsupportedOperationException("Encryption is deimplemented");
    }

    /*
     * WARNING - void declaration
     */
    public void decrypt(InputStream inputStream, OutputStream outputStream) throws IOException {
        void plaintextStream;
        void cipherStream;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"decrypt", (Object[])new Object[]{inputStream, outputStream});
        DefaultEncryptionService defaultEncryptionService = this;
        InputStream inputStream2 = inputStream;
        OutputStream outputStream2 = outputStream;
        try (InputStream inputStream3 = cipherStream.getDecryptionStream((InputStream)plaintextStream);){
            void decryptedOutputStream;
            IOUtils.copy((InputStream)inputStream3, (OutputStream)decryptedOutputStream);
            decryptedOutputStream.flush();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"decrypt", (Object[])new Object[]{inputStream, outputStream}, null, (long)l);
    }

    public InputStream getDecryptionStream(InputStream inputStream) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"getDecryptionStream", (Object[])new Object[]{inputStream});
        DefaultEncryptionService defaultEncryptionService = this;
        InputStream inputStream2 = inputStream;
        throw new UnsupportedOperationException("Encryption is deimplemented");
    }

    protected String getTransformation() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"getTransformation", (Object[])new Object[0]);
        Object object = this;
        object = ((DefaultEncryptionService)object).encryptionConfiguration.getEncryptionAlgorithm().name() + "/" + ((DefaultEncryptionService)object).encryptionConfiguration.getTransformationAlgorithm().name() + "/" + ((DefaultEncryptionService)object).encryptionConfiguration.getPaddingType().name();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultEncryptionService", (String)"getTransformation", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }
}

