/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.EncryptionException;
import io.github.qsy7.encryption.enumeration.EncryptionType;
import io.github.qsy7.encryption.impl.EncryptionConfiguration;
import io.github.qsy7.encryption.impl.FieldUtil;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.encryption.service.FieldEncryptionService;
import io.github.qsy7.encryption.service.SaltService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;

public class DefaultFieldEncryptionService
implements FieldEncryptionService {
    protected final EncryptionConfiguration encryptionConfiguration;
    protected final SaltService saltService;
    protected final EncryptionService encryptionService;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultFieldEncryptionService(EncryptionConfiguration encryptionConfiguration, SaltService saltService, EncryptionService encryptionService) {
        void encryptionService2;
        void saltService2;
        void encryptionConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration, saltService, encryptionService});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        EncryptionConfiguration encryptionConfiguration3 = encryptionConfiguration;
        SaltService saltService3 = saltService;
        EncryptionService encryptionService3 = encryptionService;
        encryptionConfiguration2.encryptionConfiguration = saltService2;
        encryptionConfiguration2.saltService = encryptionService2;
        encryptionConfiguration2.encryptionService = encryptionService3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration, saltService, encryptionService}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void encrypt(Object object, Field field, EncryptionType encryptionType) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"encrypt", (Object[])new Object[]{object, field, encryptionType});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field2 = field;
        EncryptionType encryptionType2 = encryptionType;
        try {
            void field3;
            void encryptionType3;
            Field field4 = encryptionType3.getDeclaringClass().getDeclaredField(FieldUtil.getEncryptedField((Field)encryptionType3));
            String string = (String)FieldUtil.getValue(field3, (Field)encryptionType3);
            if (string != null) {
                void var12_16;
                void plaintext;
                void e;
                void encryptedField;
                if (EncryptionType.Digest.equals((Object)encryptedField)) {
                    void saltEncoded;
                    void salt;
                    Field field5 = encryptionType3.getDeclaringClass().getDeclaredField(FieldUtil.getSaltField((Field)encryptionType3));
                    byte[] byArray = e.saltService.generate();
                    String string2 = Base64.encodeBase64String((byte[])byArray);
                    FieldUtil.setValue(field3, (Field)salt, string2);
                    String saltField = e.doDigest(string, (byte[])saltEncoded);
                } else {
                    void encryptedValue;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    e.encryptionService.encrypt((InputStream)new ByteArrayInputStream(encryptedValue.getBytes(Charset.defaultCharset())), (OutputStream)byteArrayOutputStream);
                    String baos = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
                }
                FieldUtil.setValue(field3, (Field)plaintext, var12_16);
            }
        }
        catch (Exception exception) {
            throw new EncryptionException(exception);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"encrypt", (Object[])new Object[]{object, field, encryptionType}, null, (long)l);
    }

    protected String doDigest(String string, byte[] byArray) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDigest", (Object[])new Object[]{string, byArray});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        String string2 = string;
        byte[] byArray2 = byArray;
        throw new UnsupportedOperationException("Un-implemented.");
    }

    /*
     * WARNING - void declaration
     */
    public void decrypt(Object object, Field field, EncryptionType encryptionType) throws Exception {
        void encryptionType2;
        Field field2;
        void field3;
        String string;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"decrypt", (Object[])new Object[]{object, field, encryptionType});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field4 = field;
        EncryptionType encryptionType3 = encryptionType;
        if (EncryptionType.Encrypt.equals((Object)encryptionType3) && (string = (String)FieldUtil.getValue(field3, field2 = encryptionType2.getDeclaringClass().getDeclaredField(FieldUtil.getEncryptedField((Field)encryptionType2)))) != null) {
            void e;
            e.doDecrypt(field3, (Field)encryptionType2, string);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"decrypt", (Object[])new Object[]{object, field, encryptionType}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doDecrypt(Object object, Field field, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, IOException, IllegalAccessException {
        void value;
        void field2;
        void baos;
        void e;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDecrypt", (Object[])new Object[]{object, field, string});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field3 = field;
        String string2 = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        e.encryptionService.decrypt((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)baos)), (OutputStream)byteArrayOutputStream);
        FieldUtil.setValue(field2, (Field)value, byteArrayOutputStream.toString(Charset.defaultCharset()));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDecrypt", (Object[])new Object[]{object, field, string}, null, (long)l);
    }
}

