/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.impl.digest;

import io.github.qsy7.encryption.enumeration.DigestAlgorithm;
import io.github.qsy7.encryption.impl.EncryptionConfiguration;
import io.github.qsy7.encryption.impl.digest.SHA1DigestService;
import io.github.qsy7.encryption.impl.digest.SHA256DigestService;
import io.github.qsy7.encryption.impl.digest.SHA512DigestService;
import io.github.qsy7.encryption.service.DigestService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.lang.reflect.InvocationTargetException;

public enum DigestMapping {
    SHA_1(DigestAlgorithm.SHA_1, SHA1DigestService.class),
    SHA_256(DigestAlgorithm.SHA_256, SHA256DigestService.class),
    SHA_512(DigestAlgorithm.SHA_512, SHA512DigestService.class);

    private final DigestAlgorithm digestAlgorithm;
    private final Class<? extends DigestService> digestServiceClass;

    /*
     * WARNING - void declaration
     */
    public DigestService get(EncryptionConfiguration encryptionConfiguration) {
        DigestService digestService;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"get", (Object[])new Object[]{encryptionConfiguration});
        DigestMapping digestMapping = this;
        EncryptionConfiguration encryptionConfiguration2 = encryptionConfiguration;
        try {
            void encryptionConfiguration3;
            digestService = encryptionConfiguration3.digestServiceClass.getConstructor(EncryptionConfiguration.class).newInstance(encryptionConfiguration2);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("Application is mis-configured, unable to create digest service.");
        }
        digestMapping = digestService;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"get", (Object[])new Object[]{encryptionConfiguration}, (Object)((Object)digestMapping), (long)l);
        return digestMapping;
    }

    public static DigestMapping get(DigestAlgorithm digestAlgorithm) {
        DigestMapping digestMapping2;
        Object object;
        long l;
        block2: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"get", (Object[])new Object[]{digestAlgorithm});
            object = digestAlgorithm;
            for (DigestMapping digestMapping2 : DigestMapping.values()) {
                if (!digestMapping2.getDigestAlgorithm().equals(object)) {
                    continue;
                }
                break block2;
            }
            throw new IllegalArgumentException("No provider found for algorithm:");
        }
        object = digestMapping2;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"get", (Object[])new Object[]{digestAlgorithm}, (Object)object, (long)l);
        return object;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"getDigestAlgorithm", (Object[])new Object[0]);
        DigestMapping digestMapping = this;
        digestMapping = digestMapping.digestAlgorithm;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"getDigestAlgorithm", (Object[])new Object[0], (Object)((Object)digestMapping), (long)l);
        return digestMapping;
    }

    public Class<? extends DigestService> getDigestServiceClass() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"getDigestServiceClass", (Object[])new Object[0]);
        Object object = this;
        object = object.digestServiceClass;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"getDigestServiceClass", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private DigestMapping(DigestAlgorithm digestAlgorithm, Class<? extends DigestService> clazz) {
        void digestServiceClass;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"<init>", (Object[])new Object[]{string, n, digestAlgorithm, clazz});
        DigestMapping digestMapping = this;
        String string2 = string;
        int n2 = n;
        DigestAlgorithm digestAlgorithm3 = digestAlgorithm;
        Class<? extends DigestService> clazz2 = clazz;
        digestMapping.digestAlgorithm = digestServiceClass;
        digestMapping.digestServiceClass = clazz2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.digest.DigestMapping", (String)"<init>", (Object[])new Object[]{string, n, digestAlgorithm, clazz}, null, (long)l);
    }
}

