/*package io.github.qsy7.encryption.impl;

import io.github.qsy7.datastore.encryption.dto.EncryptionConfigurationDatastore;
import java.io.IOException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import sun.misc.BASE64Decoder;

public class SecretKeyProvider implements Provider<SecretKey> {
  protected final SecretKey secretKey;

  @Inject
  public SecretKeyProvider(EncryptionConfigurationDatastore encryptionConfiguration)
      throws IOException {
    final String secretPassword = encryptionConfiguration.getPassword();
    secretKey =
        new SecretKeySpec(
            new BASE64Decoder().decodeBuffer(secretPassword),
            encryptionConfiguration.getEncryptionAlgorithm().getAlgorithmName());
  }
  // TODO: get the secret key after prompting the user for the session key passphrase
  @Override
  public SecretKey get() {
    return (secretKey);
  }
}
*/
