/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.EncryptionException;
import io.github.qsy7.encryption.enumeration.EncryptionType;
import io.github.qsy7.encryption.impl.EncryptionConfiguration;
import io.github.qsy7.encryption.impl.FieldUtil;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.encryption.service.FieldEncryptionService;
import io.github.qsy7.encryption.service.SaltService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import org.apache.commons.codec.binary.Base64;

public class DefaultFieldEncryptionService
implements FieldEncryptionService {
    protected final EncryptionConfiguration encryptionConfiguration;
    protected final SaltService saltService;
    protected final EncryptionService encryptionService;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultFieldEncryptionService(EncryptionConfiguration encryptionConfiguration, SaltService saltService, EncryptionService encryptionService) {
        void encryptionService2;
        void saltService2;
        void encryptionConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration, saltService, encryptionService});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        EncryptionConfiguration encryptionConfiguration3 = encryptionConfiguration;
        SaltService saltService3 = saltService;
        EncryptionService encryptionService3 = encryptionService;
        defaultFieldEncryptionService.encryptionConfiguration = encryptionConfiguration2;
        defaultFieldEncryptionService.saltService = saltService2;
        defaultFieldEncryptionService.encryptionService = encryptionService2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"<init>", (Object[])new Object[]{encryptionConfiguration, saltService, encryptionService}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void encrypt(Object object, Field field, EncryptionType encryptionType) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"encrypt", (Object[])new Object[]{object, field, encryptionType});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field2 = field;
        EncryptionType encryptionType2 = encryptionType;
        DefaultFieldEncryptionService defaultFieldEncryptionService2 = defaultFieldEncryptionService;
        Object object3 = object2;
        Field field3 = field2;
        EncryptionType encryptionType3 = encryptionType2;
        try {
            try {
                void e;
                void field4;
                Field encryptedField = field4.getDeclaringClass().getDeclaredField(FieldUtil.getEncryptedField((Field)field4));
                String plaintext = (String)FieldUtil.getValue(e, (Field)field4);
                if (plaintext != null) {
                    String encryptedValue;
                    void encryptionType4;
                    if (EncryptionType.Digest.equals((Object)encryptionType4)) {
                        Field saltField = field4.getDeclaringClass().getDeclaredField(FieldUtil.getSaltField((Field)field4));
                        byte[] salt = defaultFieldEncryptionService2.saltService.generate();
                        String saltEncoded = Base64.encodeBase64String((byte[])salt);
                        FieldUtil.setValue(e, saltField, saltEncoded);
                        encryptedValue = defaultFieldEncryptionService2.doDigest(plaintext, salt);
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        defaultFieldEncryptionService2.encryptionService.encrypt((InputStream)new ByteArrayInputStream(plaintext.getBytes(Charset.defaultCharset())), (OutputStream)baos);
                        encryptedValue = Base64.encodeBase64String((byte[])baos.toByteArray());
                    }
                    FieldUtil.setValue(e, encryptedField, encryptedValue);
                }
            }
            catch (Exception exception) {
                throw new EncryptionException(exception);
            }
            defaultFieldEncryptionService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultFieldEncryptionService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"encrypt", (Object[])new Object[]{object2, field2, encryptionType2}, (Throwable)((Object)defaultFieldEncryptionService2));
        }
        if (defaultFieldEncryptionService2 != null) {
            throw defaultFieldEncryptionService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"encrypt", (Object[])new Object[]{object, field, encryptionType}, null, (long)l);
    }

    protected String doDigest(String string, byte[] byArray) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDigest", (Object[])new Object[]{string, byArray});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        String string2 = string;
        byte[] byArray2 = byArray;
        DefaultFieldEncryptionService defaultFieldEncryptionService2 = defaultFieldEncryptionService;
        String string3 = string2;
        byte[] byArray3 = byArray2;
        try {
            throw new UnsupportedOperationException("Un-implemented.");
        }
        catch (Throwable throwable) {
            defaultFieldEncryptionService2 = null;
            if (throwable != null) {
                ExceptionUtil.onException((String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDigest", (Object[])new Object[]{string2, byArray2}, (Throwable)throwable);
            }
            if (throwable != null) {
                throw throwable;
            }
            defaultFieldEncryptionService = defaultFieldEncryptionService2;
            MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDigest", (Object[])new Object[]{string, byArray}, (Object)defaultFieldEncryptionService, (long)l);
            return defaultFieldEncryptionService;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void decrypt(Object object, Field field, EncryptionType encryptionType) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"decrypt", (Object[])new Object[]{object, field, encryptionType});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field2 = field;
        EncryptionType encryptionType2 = encryptionType;
        DefaultFieldEncryptionService defaultFieldEncryptionService2 = defaultFieldEncryptionService;
        Object object3 = object2;
        Field field3 = field2;
        EncryptionType encryptionType3 = encryptionType2;
        try {
            void field4;
            Field encryptedField;
            void e;
            String value;
            void encryptionType4;
            if (EncryptionType.Encrypt.equals((Object)encryptionType4) && (value = (String)FieldUtil.getValue(e, encryptedField = field4.getDeclaringClass().getDeclaredField(FieldUtil.getEncryptedField((Field)field4)))) != null) {
                defaultFieldEncryptionService2.doDecrypt(e, (Field)field4, value);
            }
            defaultFieldEncryptionService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultFieldEncryptionService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"decrypt", (Object[])new Object[]{object2, field2, encryptionType2}, (Throwable)((Object)defaultFieldEncryptionService2));
        }
        if (defaultFieldEncryptionService2 != null) {
            throw defaultFieldEncryptionService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"decrypt", (Object[])new Object[]{object, field, encryptionType}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doDecrypt(Object object, Field field, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, IOException, IllegalAccessException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDecrypt", (Object[])new Object[]{object, field, string});
        DefaultFieldEncryptionService defaultFieldEncryptionService = this;
        Object object2 = object;
        Field field2 = field;
        String string2 = string;
        DefaultFieldEncryptionService defaultFieldEncryptionService2 = defaultFieldEncryptionService;
        Object object3 = object2;
        Field field3 = field2;
        String string3 = string2;
        try {
            void field4;
            void e;
            void value;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            defaultFieldEncryptionService2.encryptionService.decrypt((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)value)), (OutputStream)baos);
            FieldUtil.setValue(e, (Field)field4, baos.toString(Charset.defaultCharset()));
            defaultFieldEncryptionService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultFieldEncryptionService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDecrypt", (Object[])new Object[]{object2, field2, string2}, (Throwable)((Object)defaultFieldEncryptionService2));
        }
        if (defaultFieldEncryptionService2 != null) {
            throw defaultFieldEncryptionService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.DefaultFieldEncryptionService", (String)"doDecrypt", (Object[])new Object[]{object, field, string}, null, (long)l);
    }
}

