/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.index.service;

import io.github.qsy7.index.api.enumeration.IndexAction;
import io.github.qsy7.index.api.model.index.IndexSession;
import io.github.qsy7.index.api.service.IndexBulkService;
import io.github.qsy7.index.api.service.IndexService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.service.ForkJoinWork;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexBulkService<RequestType>
implements IndexBulkService<RequestType>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIndexBulkService.class);
    protected final int recordsPerBatch;
    protected final int timePerBatch;
    protected final IndexService indexService;
    protected transient IndexSession<RequestType> indexSession;
    protected final ForkJoinWork forkJoinWork;

    /*
     * WARNING - void declaration
     */
    public void add(RequestType RequestType) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"add", (Object[])new Object[]{RequestType});
        AbstractIndexBulkService abstractIndexBulkService = this;
        RequestType RequestType2 = RequestType;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        RequestType RequestType3 = RequestType2;
        try {
            void request;
            abstractIndexBulkService2.setupIndexSession();
            abstractIndexBulkService2.indexSession.getRequests().add(request);
            abstractIndexBulkService2.flushSession();
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"add", (Object[])new Object[]{RequestType2}, (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"add", (Object[])new Object[]{RequestType}, null, (long)l);
    }

    public List<RequestType> get() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"get", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        Object object = abstractIndexBulkService;
        try {
            object = ((AbstractIndexBulkService)object).indexSession.getRequests();
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    protected void setupIndexSession() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"setupIndexSession", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            if (abstractIndexBulkService2.indexSession == null) {
                abstractIndexBulkService2.indexSession = new IndexSession();
                abstractIndexBulkService2.indexSession.setEndDateTime(abstractIndexBulkService2.indexSession.getStartDateTime().plus(Duration.ofMillis(abstractIndexBulkService2.timePerBatch)));
            }
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"setupIndexSession", (Object[])new Object[0], (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"setupIndexSession", (Object[])new Object[0], null, (long)l);
    }

    protected void flushSession() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flushSession", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            if (abstractIndexBulkService2.isFlush()) {
                abstractIndexBulkService2.internalFlush();
            }
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flushSession", (Object[])new Object[0], (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flushSession", (Object[])new Object[0], null, (long)l);
    }

    protected boolean isFlush() {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlush", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            bl = abstractIndexBulkService2.indexSession.getRequests().size() >= abstractIndexBulkService2.recordsPerBatch ? true : LocalDateTime.now().isAfter(abstractIndexBulkService2.indexSession.getEndDateTime());
        }
        catch (Throwable throwable) {
            bl = false;
        }
        Object var5_6 = null;
        if (var5_6 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlush", (Object[])new Object[0], (Throwable)var5_6);
        }
        if (var5_6 != null) {
            throw var5_6;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlush", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    public void flush() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flush", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            if (abstractIndexBulkService2.isFlushable()) {
                abstractIndexBulkService2.internalFlush();
                abstractIndexBulkService2.forkJoinWork.waitForAll(1L, TimeUnit.SECONDS);
            }
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flush", (Object[])new Object[0], (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"flush", (Object[])new Object[0], null, (long)l);
    }

    protected boolean isFlushable() {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlushable", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            bl = abstractIndexBulkService2.indexSession != null && abstractIndexBulkService2.indexSession.getRequests() != null && !abstractIndexBulkService2.indexSession.getRequests().isEmpty();
        }
        catch (Throwable throwable) {
            bl = false;
        }
        Throwable throwable = null;
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlushable", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"isFlushable", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    protected void internalFlush() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"internalFlush", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            abstractIndexBulkService2.indexSession.getRequests().add(abstractIndexBulkService2.indexService.buildRequest(IndexAction.Index, abstractIndexBulkService2.indexService.buildIndexableRecord(IndexAction.Index, abstractIndexBulkService2.indexSession)));
            abstractIndexBulkService2.forkJoinWork.submit(() -> {
                try {
                    this.doFlush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"internalFlush", (Object[])new Object[0], (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"internalFlush", (Object[])new Object[0], null, (long)l);
    }

    protected abstract void doFlush() throws IOException;

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"close", (Object[])new Object[0]);
        AbstractIndexBulkService abstractIndexBulkService = this;
        AbstractIndexBulkService abstractIndexBulkService2 = abstractIndexBulkService;
        try {
            abstractIndexBulkService2.forkJoinWork.close();
            try {
                abstractIndexBulkService2.flush();
            }
            catch (Exception e) {
                LOGGER.warn("error while flushing", (Throwable)e);
            }
            abstractIndexBulkService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractIndexBulkService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"close", (Object[])new Object[0], (Throwable)((Object)abstractIndexBulkService2));
        }
        if (abstractIndexBulkService2 != null) {
            throw abstractIndexBulkService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndexBulkService(int n, int n2, IndexService indexService) {
        void indexService2;
        void timePerBatch;
        void recordsPerBatch;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"<init>", (Object[])new Object[]{n, n2, indexService});
        AbstractIndexBulkService abstractIndexBulkService = this;
        int n3 = n;
        int n4 = n2;
        IndexService indexService3 = indexService;
        abstractIndexBulkService.forkJoinWork = new ForkJoinWork();
        abstractIndexBulkService.recordsPerBatch = recordsPerBatch;
        abstractIndexBulkService.timePerBatch = timePerBatch;
        abstractIndexBulkService.indexService = indexService2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.index.service.AbstractIndexBulkService", (String)"<init>", (Object[])new Object[]{n, n2, indexService}, null, (long)l);
    }
}

