package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.download.api.service.DownloadService;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.DownloadConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = YamlConfigurer.class,
    configurationClass = DownloadConfiguration.class)
public class DownloadsModule extends AbstractCollectionModule<DownloadConfiguration> {
  protected final DownloadService downloadService;

  @Inject
  public DownloadsModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      DownloadService downloadService) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.downloadService = downloadService;
  }

  public void document() {
    // tex.link_file(documentation_directory, 'RunModule Script', self.chroot_file, prefix=prefix)
  }

  /**
   * Download all of the files. TODO: runInChroot each download in a separate thread and wait for
   * all to finish
   */
  protected void doRun(final DownloadConfiguration downloadConfiguration) throws Exception {
    downloadService.download(downloadConfiguration);
  }
}
