/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.util;

import io.github.qsy7.linux.builder.api.model.patch.Patch;
import io.github.qsy7.linux.builder.api.model.patch.PatchEdge;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure1;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure11;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure13;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure15;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure17;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure19;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure21;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure23;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure3;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure5;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure7;
import io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil$AjcClosure9;
import io.github.qsy7.linux.builder.impl.service.util.IOUtil;
import io.github.qsy7.logging.aspects.AfterThrowingAspect;
import io.github.qsy7.logging.aspects.InfoMethodLoggerAspect;
import io.github.qsy7.logging.aspects.TraceMethodLoggerAspect;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DependencyManagementUtil {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    public static Patch getPatchByName(String repositoryPath, String variant, String patchName) throws IOException {
        String string = repositoryPath;
        String string2 = variant;
        String string3 = patchName;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        try {
            Object[] objectArray2 = new Object[]{string, string2, string3, joinPoint};
            DependencyManagementUtil$AjcClosure1 dependencyManagementUtil$AjcClosure1 = new DependencyManagementUtil$AjcClosure1(objectArray2);
            return (Patch)InfoMethodLoggerAspect.aspectOf().doPublicAround(dependencyManagementUtil$AjcClosure1.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static Set<String> getSystemPatches(String repositoryPath, String variant) throws IOException {
        String string = repositoryPath;
        String string2 = variant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string, (Object)string2);
        try {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            DependencyManagementUtil$AjcClosure3 dependencyManagementUtil$AjcClosure3 = new DependencyManagementUtil$AjcClosure3(objectArray);
            return (Set)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure3.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static Set<Patch> getSystemPatchInstances(String repositoryPath, String system, String variant) throws IOException {
        String string = repositoryPath;
        String string2 = system;
        String string3 = variant;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        try {
            Object[] objectArray2 = new Object[]{string, string2, string3, joinPoint};
            DependencyManagementUtil$AjcClosure5 dependencyManagementUtil$AjcClosure5 = new DependencyManagementUtil$AjcClosure5(objectArray2);
            return (Set)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure5.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public static List<Patch> getOrderedSystemPatches(String repositoryPath, String variant) throws IOException {
        String string = repositoryPath;
        String string2 = variant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string, (Object)string2);
        try {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            DependencyManagementUtil$AjcClosure7 dependencyManagementUtil$AjcClosure7 = new DependencyManagementUtil$AjcClosure7(objectArray);
            return (List)InfoMethodLoggerAspect.aspectOf().doPublicAround(dependencyManagementUtil$AjcClosure7.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static void setupDependencies(Set<Patch> systemPatches) throws IOException {
        Set<Patch> set = systemPatches;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, set);
        try {
            Object[] objectArray = new Object[]{set, joinPoint};
            DependencyManagementUtil$AjcClosure9 dependencyManagementUtil$AjcClosure9 = new DependencyManagementUtil$AjcClosure9(objectArray);
            TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure9.linkClosureAndJoinPoint(65536));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static Set<Patch> prepareFirstLevel(Set<Patch> systemPatches) {
        Set<Patch> set = systemPatches;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, set);
        try {
            Object[] objectArray = new Object[]{set, joinPoint};
            DependencyManagementUtil$AjcClosure11 dependencyManagementUtil$AjcClosure11 = new DependencyManagementUtil$AjcClosure11(objectArray);
            return (Set)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure11.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static List<Patch> sortPatches(Set<Patch> firstLevel) {
        Set<Patch> set = firstLevel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, set);
        try {
            Object[] objectArray = new Object[]{set, joinPoint};
            DependencyManagementUtil$AjcClosure13 dependencyManagementUtil$AjcClosure13 = new DependencyManagementUtil$AjcClosure13(objectArray);
            return (List)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure13.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static void checkForCycle(Set<Patch> patches) {
        Set<Patch> set = patches;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, set);
        try {
            Object[] objectArray = new Object[]{set, joinPoint};
            DependencyManagementUtil$AjcClosure15 dependencyManagementUtil$AjcClosure15 = new DependencyManagementUtil$AjcClosure15(objectArray);
            TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure15.linkClosureAndJoinPoint(65536));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static Patch getPatch(Set<Patch> systemPatches, String systemPatchName) {
        Set<Patch> set = systemPatches;
        String string = systemPatchName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, set, (Object)string);
        try {
            Object[] objectArray = new Object[]{set, string, joinPoint};
            DependencyManagementUtil$AjcClosure17 dependencyManagementUtil$AjcClosure17 = new DependencyManagementUtil$AjcClosure17(objectArray);
            return (Patch)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure17.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static boolean doesVariantExist(String filename, String variant) {
        String string = filename;
        String string2 = variant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string, (Object)string2);
        try {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            DependencyManagementUtil$AjcClosure19 dependencyManagementUtil$AjcClosure19 = new DependencyManagementUtil$AjcClosure19(objectArray);
            return Conversions.booleanValue((Object)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure19.linkClosureAndJoinPoint(65536)));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static final String getPatchName(String filename) {
        String string = filename;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)string);
        try {
            Object[] objectArray = new Object[]{string, joinPoint};
            DependencyManagementUtil$AjcClosure21 dependencyManagementUtil$AjcClosure21 = new DependencyManagementUtil$AjcClosure21(objectArray);
            return (String)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure21.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static Set<String> getPatches(File parent) {
        File file = parent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)file);
        try {
            Object[] objectArray = new Object[]{file, joinPoint};
            DependencyManagementUtil$AjcClosure23 dependencyManagementUtil$AjcClosure23 = new DependencyManagementUtil$AjcClosure23(objectArray);
            return (Set)TraceMethodLoggerAspect.aspectOf().doPrivateAround(dependencyManagementUtil$AjcClosure23.linkClosureAndJoinPoint(65536));
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private DependencyManagementUtil() {
    }

    static {
        DependencyManagementUtil.ajc$preClinit();
    }

    static final /* synthetic */ Patch getPatchByName_aroundBody0(String repositoryPath, String variant, String patchName, JoinPoint joinPoint) {
        List<Patch> patches = DependencyManagementUtil.getOrderedSystemPatches(repositoryPath, variant);
        for (Patch patch : patches) {
            if (!patch.getName().equals(patchName)) continue;
            return patch;
        }
        throw new IllegalStateException("Patch : " + patchName + " not found.");
    }

    static final /* synthetic */ Set getSystemPatches_aroundBody2(String repositoryPath, String variant, JoinPoint joinPoint) {
        File patchFile = new File(repositoryPath + File.separator + "systems" + File.separator + variant + File.separator + "patches");
        List<String> systemPatches = IOUtil.readLines(patchFile.getAbsolutePath());
        HashSet<String> systemPatchset = new HashSet<String>();
        for (String systemPatch : systemPatches) {
            if (!systemPatch.endsWith(".patch")) {
                systemPatchset.addAll(DependencyManagementUtil.getPatches(new File(repositoryPath + File.separator + "patches" + File.separator + systemPatch)));
                continue;
            }
            systemPatchset.add(new File(repositoryPath + File.separator + "patches" + File.separator + systemPatch).getAbsolutePath());
        }
        return systemPatchset;
    }

    static final /* synthetic */ Set getSystemPatchInstances_aroundBody4(String repositoryPath, String system, String variant, JoinPoint joinPoint) {
        HashSet<Patch> systemPatches = new HashSet<Patch>();
        for (String systemPatchPath : DependencyManagementUtil.getSystemPatches(repositoryPath, system)) {
            systemPatches.add(new Patch(DependencyManagementUtil.getPatchName(systemPatchPath), systemPatchPath, DependencyManagementUtil.doesVariantExist(systemPatchPath, variant)));
        }
        return systemPatches;
    }

    static final /* synthetic */ List getOrderedSystemPatches_aroundBody6(String repositoryPath, String variant, JoinPoint joinPoint) {
        Set<Patch> systemPatches = DependencyManagementUtil.getSystemPatchInstances(repositoryPath, "base", variant);
        systemPatches.addAll(DependencyManagementUtil.getSystemPatchInstances(repositoryPath, variant, variant));
        DependencyManagementUtil.setupDependencies(systemPatches);
        List<Patch> sortedPatches = DependencyManagementUtil.sortPatches(DependencyManagementUtil.prepareFirstLevel(systemPatches));
        DependencyManagementUtil.checkForCycle(systemPatches);
        Collections.reverse(sortedPatches);
        return sortedPatches;
    }

    static final /* synthetic */ void setupDependencies_aroundBody8(Set systemPatches, JoinPoint joinPoint) {
        for (Patch systemPatch : systemPatches) {
            File dependencyFile = new File(systemPatch.getPath() + File.separator + "dependencies");
            if (!dependencyFile.exists()) continue;
            List<String> dependencies = IOUtil.readLines(dependencyFile.getAbsolutePath());
            for (String dependency : dependencies) {
                systemPatch.addDependency(DependencyManagementUtil.getPatch(systemPatches, dependency));
            }
        }
    }

    static final /* synthetic */ Set prepareFirstLevel_aroundBody10(Set systemPatches, JoinPoint joinPoint) {
        HashSet<Patch> firstLevel = new HashSet<Patch>();
        for (Patch patch : systemPatches) {
            if (patch.getInEdges().size() != 0) continue;
            firstLevel.add(patch);
        }
        return firstLevel;
    }

    static final /* synthetic */ List sortPatches_aroundBody12(Set firstLevel, JoinPoint joinPoint) {
        ArrayList<Patch> sortedPatches = new ArrayList<Patch>();
        while (!firstLevel.isEmpty()) {
            Patch patch = (Patch)firstLevel.iterator().next();
            firstLevel.remove(patch);
            sortedPatches.add(patch);
            Iterator patchEdgeIterator = patch.getOutEdges().iterator();
            while (patchEdgeIterator.hasNext()) {
                PatchEdge patchEdge = (PatchEdge)patchEdgeIterator.next();
                Patch edgePatch = patchEdge.getTo();
                patchEdgeIterator.remove();
                edgePatch.getInEdges().remove(patchEdge);
                if (!edgePatch.getInEdges().isEmpty()) continue;
                firstLevel.add(edgePatch);
            }
        }
        return sortedPatches;
    }

    static final /* synthetic */ void checkForCycle_aroundBody14(Set patches, JoinPoint joinPoint) {
        for (Patch patch : patches) {
            if (patch.getInEdges().isEmpty()) continue;
            throw new IllegalStateException("Cycle detected, blew up.");
        }
    }

    static final /* synthetic */ Patch getPatch_aroundBody16(Set systemPatches, String systemPatchName, JoinPoint joinPoint) {
        for (Patch systemPatch : systemPatches) {
            if (!systemPatch.getName().equals(systemPatchName)) continue;
            return systemPatch;
        }
        throw new IllegalStateException("Unable to resolve dependency for:" + systemPatchName);
    }

    static final /* synthetic */ boolean doesVariantExist_aroundBody18(String filename, String variant, JoinPoint joinPoint) {
        return new File(filename + File.separator + "variants" + File.separator + variant).exists();
    }

    static final /* synthetic */ String getPatchName_aroundBody20(String filename, JoinPoint joinPoint) {
        String[] filenameParts = filename.split("/");
        String baseName = filenameParts[filenameParts.length - 1];
        return baseName.replace(".patch", "");
    }

    static final /* synthetic */ Set getPatches_aroundBody22(File parent, JoinPoint joinPoint) {
        HashSet<String> patchFiles = new HashSet<String>();
        for (File child : parent.listFiles()) {
            if (!child.isDirectory()) continue;
            if (child.getAbsolutePath().endsWith(".patch")) {
                patchFiles.add(child.getAbsolutePath());
                continue;
            }
            patchFiles.addAll(DependencyManagementUtil.getPatches(child));
        }
        return patchFiles;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DependencyManagementUtil.java", DependencyManagementUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getPatchByName", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String:java.lang.String:java.lang.String", "repositoryPath:variant:patchName", "java.io.IOException", "io.github.qsy7.linux.builder.api.model.patch.Patch"), 15);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getSystemPatches", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String:java.lang.String", "repositoryPath:variant", "java.io.IOException", "java.util.Set"), 26);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "getPatchName", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String", "filename", "", "java.lang.String"), 121);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getPatches", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.io.File", "parent", "", "java.util.Set"), 127);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getSystemPatchInstances", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String:java.lang.String:java.lang.String", "repositoryPath:system:variant", "java.io.IOException", "java.util.Set"), 40);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getOrderedSystemPatches", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String:java.lang.String", "repositoryPath:variant", "java.io.IOException", "java.util.List"), 48);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "setupDependencies", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.util.Set", "systemPatches", "java.io.IOException", "void"), 59);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "prepareFirstLevel", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.util.Set", "systemPatches", "", "java.util.Set"), 71);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "sortPatches", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.util.Set", "firstLevel", "", "java.util.List"), 81);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkForCycle", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.util.Set", "patches", "", "void"), 100);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getPatch", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.util.Set:java.lang.String", "systemPatches:systemPatchName", "", "io.github.qsy7.linux.builder.api.model.patch.Patch"), 108);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "doesVariantExist", "io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", "java.lang.String:java.lang.String", "filename:variant", "", "boolean"), 117);
    }
}

