package io.github.qsy7.linux.builder.impl.service;

import io.github.qsy7.property.api.annotation.DefaultValue;
import io.github.qsy7.property.api.property.ConfigurableProperty;

public enum PackageFormat implements ConfigurableProperty {
  @DefaultValue
  Squashfs("squash");

  private final String extension;

  PackageFormat(String extension) {
    this.extension = extension;
  }

  public String getExtension() {
    return "." + extension;
  }
}
