package io.github.qsy7.linux.builder.impl.service.bootstrap;

import io.github.qsy7.linux.builder.api.model.BuildPhase;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.service.PackageManagementService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import javax.inject.Inject;

public class DebianBootstrappingService extends AbstractLinuxBootstrappingService {
  protected final ShellExecutionService shellExecutionService;

  protected final PackageManagementService packageManagementService;

  @Inject
  public DebianBootstrappingService(
      ShellExecutionService shellExecutionService,
      BuildConfiguration buildConfiguration,
      PackageManagementService packageManagementService) {
    super(buildConfiguration);
    this.shellExecutionService = shellExecutionService;
    this.packageManagementService = packageManagementService;
  }

  @Override
  public void doPostBuild(BuildPhase buildPhase) throws Exception {
    super.doPostBuild(buildPhase);
    packageManagementService.update();
  }
}
